@extends('layouts.master')

@section('title', 'Reports Modules - Prolex Law Firm')

@section('content')
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    .admin-container {
        min-height: 100vh;
        background: linear-gradient(135deg, #f8fafc 0%, #e0f2fe 100%);
        padding: 2rem 1.5rem;
    }

    .admin-header {
        max-width: 1400px;
        margin: 0 auto 3rem;
        text-align: center;
    }

    .admin-header h1 {
        font-size: 2.5rem;
        color: #1f2937;
        margin-bottom: 0.5rem;
        font-weight: bold;
    }

    .admin-header p {
        color: #6b7280;
        font-size: 1.125rem;
    }

    .services-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 1.5rem;
        max-width: 1400px;
        margin: 0 auto;
    }

    .service-card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        overflow: hidden;
        cursor: pointer;
        transition: all 0.3s ease;
        position: relative;
        text-decoration: none;
        display: block;
    }

    .service-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 20px 25px rgba(0,0,0,0.15);
    }

    .card-header {
        height: 8px;
    }

    .card-header.red { background: linear-gradient(90deg, #f43f5e, #e11d48); }
    .card-header.blue { background: linear-gradient(90deg, #3b82f6, #2563eb); }
    .card-header.green { background: linear-gradient(90deg, #22c55e, #16a34a); }
    .card-header.yellow { background: linear-gradient(90deg, #eab308, #ca8a04); }
    .card-header.purple { background: linear-gradient(90deg, #8b5cf6, #7c3aed); }
    .card-header.pink { background: linear-gradient(90deg, #ec4899, #db2777); }
    .card-header.orange { background: linear-gradient(90deg, #f97316, #ea580c); }

    .card-content {
        padding: 1.5rem;
    }

    .card-top {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 1rem;
    }

    .icon-wrapper {
        padding: 0.75rem;
        border-radius: 8px;
        transition: transform 0.3s ease;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .icon-wrapper.red-bg { background: linear-gradient(135deg, #f43f5e, #e11d48); }
    .icon-wrapper.blue-bg { background: linear-gradient(135deg, #3b82f6, #2563eb); }
    .icon-wrapper.green-bg { background: linear-gradient(135deg, #22c55e, #16a34a); }
    .icon-wrapper.yellow-bg { background: linear-gradient(135deg, #eab308, #ca8a04); }
    .icon-wrapper.purple-bg { background: linear-gradient(135deg, #8b5cf6, #7c3aed); }
    .icon-wrapper.pink-bg { background: linear-gradient(135deg, #ec4899, #db2777); }
    .icon-wrapper.orange-bg { background: linear-gradient(135deg, #f97316, #ea580c); }

    .service-card:hover .icon-wrapper {
        transform: scale(1.1);
    }

    .card-icon {
        font-size: 2rem;
        color: white;
    }

    .arrow-icon {
        width: 24px;
        height: 24px;
        transition: transform 0.3s ease;
    }

    .arrow-icon.red-arrow { fill: #f43f5e; }
    .arrow-icon.blue-arrow { fill: #3b82f6; }
    .arrow-icon.green-arrow { fill: #22c55e; }
    .arrow-icon.yellow-arrow { fill: #eab308; }
    .arrow-icon.purple-arrow { fill: #8b5cf6; }
    .arrow-icon.pink-arrow { fill: #ec4899; }
    .arrow-icon.orange-arrow { fill: #f97316; }

    .service-card:hover .arrow-icon {
        transform: translateX(4px);
    }

    .card-title {
        font-size: 1.125rem;
        font-weight: bold;
        color: #1f2937;
        margin-bottom: 0.5rem;
    }

    .card-description {
        color: #6b7280;
        line-height: 1.6;
        font-size: 0.875rem;
    }

    .learn-more {
        margin-top: 1rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        font-weight: 600;
        opacity: 0;
        transition: all 0.3s ease;
        font-size: 0.875rem;
    }

    .learn-more.red-text { color: #f43f5e; }
    .learn-more.blue-text { color: #3b82f6; }
    .learn-more.green-text { color: #22c55e; }
    .learn-more.yellow-text { color: #eab308; }
    .learn-more.purple-text { color: #8b5cf6; }
    .learn-more.pink-text { color: #ec4899; }
    .learn-more.orange-text { color: #f97316; }

    .service-card:hover .learn-more {
        opacity: 1;
    }

    .learn-more svg {
        width: 16px;
        height: 16px;
    }

    .card-footer {
        height: 4px;
        width: 0;
        transition: width 0.3s ease;
    }

    .card-footer.red-footer { background: linear-gradient(90deg, #f43f5e, #e11d48); }
    .card-footer.blue-footer { background: linear-gradient(90deg, #3b82f6, #2563eb); }
    .card-footer.green-footer { background: linear-gradient(90deg, #22c55e, #16a34a); }
    .card-footer.yellow-footer { background: linear-gradient(90deg, #eab308, #ca8a04); }
    .card-footer.purple-footer { background: linear-gradient(90deg, #8b5cf6, #7c3aed); }
    .card-footer.pink-footer { background: linear-gradient(90deg, #ec4899, #db2777); }
    .card-footer.orange-footer { background: linear-gradient(90deg, #f97316, #ea580c); }

    .service-card:hover .card-footer {
        width: 100%;
    }

    @media (max-width: 768px) {
        .admin-header h1 {
            font-size: 1.875rem;
        }
        .services-grid {
            grid-template-columns: 1fr;
        }
    }
</style>

<div class="admin-container">
    <div class="admin-header">
        <h1>Reports Menu</h1>
        <p>Access comprehensive reports and analytics for your law firm</p>
    </div>

    <div class="services-grid">
        @php
            $modules = [
                ['name' => 'Chart of Accounts', 'icon' => 'fas fa-list', 'route' => 'modules.reports.chart-of-accounts', 'description' => 'View complete account structure and classifications', 'color' => 'red'],
                ['name' => 'General Ledger', 'icon' => 'fas fa-book', 'route' => 'modules.reports.general-ledger', 'description' => 'Access all financial transactions and entries', 'color' => 'blue'],
                ['name' => 'Client Statement', 'icon' => 'fas fa-file-alt', 'route' => 'modules.reports.client-statement', 'description' => 'Generate client account statements and balances', 'color' => 'green'],
                ['name' => 'Case Status', 'icon' => 'fas fa-gavel', 'route' => 'modules.reports.case-status', 'description' => 'Review current status of all active cases', 'color' => 'yellow'],
                ['name' => 'Court Filings', 'icon' => 'fas fa-file-contract', 'route' => 'modules.reports.court-filings', 'description' => 'Track court document submissions and deadlines', 'color' => 'purple'],
                ['name' => 'Lawyer Statement', 'icon' => 'fas fa-user-tie', 'route' => 'modules.reports.lawyer-statement', 'description' => 'View lawyer performance and case assignments', 'color' => 'pink'],
                ['name' => 'Supplier Statement', 'icon' => 'fas fa-file-signature', 'route' => 'modules.reports.supplier-statement', 'description' => 'Monitor vendor accounts and payment status', 'color' => 'orange'],
                ['name' => 'Cash Book', 'icon' => 'fas fa-cash-register', 'route' => 'modules.reports.cash-book', 'description' => 'Review cash receipts and payment transactions', 'color' => 'red'],
                ['name' => 'Tax Reports', 'icon' => 'fas fa-file-invoice-dollar', 'route' => 'modules.reports.tax-reports', 'description' => 'Generate tax summaries and compliance reports', 'color' => 'blue'],
                ['name' => 'Fee Collection', 'icon' => 'fas fa-hand-holding-usd', 'route' => 'modules.reports.fee-collection', 'description' => 'Track collected fees and payment history', 'color' => 'green'],
                ['name' => 'Outstanding Fees', 'icon' => 'fas fa-exclamation-circle', 'route' => 'modules.reports.outstanding-fees', 'description' => 'View unpaid balances and pending invoices', 'color' => 'yellow'],
                ['name' => 'Total Fees', 'icon' => 'fas fa-calculator', 'route' => 'modules.reports.total-fees', 'description' => 'Calculate total fee revenue and statistics', 'color' => 'purple'],
                ['name' => 'Income Statements', 'icon' => 'fas fa-chart-line', 'route' => 'modules.reports.income-statements', 'description' => 'Analyze revenue, expenses, and profitability', 'color' => 'pink'],
                ['name' => 'Balance Sheet', 'icon' => 'fas fa-balance-scale', 'route' => 'modules.reports.balance-sheet', 'description' => 'Review assets, liabilities, and equity position', 'color' => 'orange'],
                ['name' => 'Trial Balance', 'icon' => 'fas fa-balance-scale-left', 'route' => 'modules.reports.trial-balance', 'description' => 'Verify accounting records and balances', 'color' => 'red'],
                ['name' => 'Journals', 'icon' => 'fas fa-journal-whills', 'route' => 'modules.reports.journals', 'description' => 'Access accounting journal entries and records', 'color' => 'blue'],
            ];
        @endphp

        @foreach ($modules as $module)
            <a href="{{ route($module['route']) }}" class="service-card" aria-label="{{ $module['name'] }} Report">
                <div class="card-header {{ $module['color'] }}"></div>
                <div class="card-content">
                    <div class="card-top">
                        <div class="icon-wrapper {{ $module['color'] }}-bg">
                            <i class="{{ $module['icon'] }} card-icon"></i>
                        </div>
                        <svg class="arrow-icon {{ $module['color'] }}-arrow" viewBox="0 0 24 24" fill="currentColor">
                            <path d="M9 6L15 12L9 18"></path>
                        </svg>
                    </div>
                    <h3 class="card-title">{{ $module['name'] }}</h3>
                    <p class="card-description">{{ $module['description'] }}</p>
                    <div class="learn-more {{ $module['color'] }}-text">
                        View Report
                        <svg viewBox="0 0 24 24" fill="currentColor">
                            <path d="M9 6L15 12L9 18"></path>
                        </svg>
                    </div>
                </div>
                <div class="card-footer {{ $module['color'] }}-footer"></div>
            </a>
        @endforeach
    </div>
</div>
@endsection