{{-- resources/views/modules/reports/case-status-pdf.blade.php --}}
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Case Status Report - {{ $selectedCase->case_id }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #000;
            padding-bottom: 20px;
        }
        .logo {
            max-width: 100px;
            margin-bottom: 10px;
        }
        .report-title {
            font-size: 18px;
            font-weight: bold;
            margin: 10px 0;
        }
        .report-info {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }
        .report-info div {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }
        .case-details {
            margin-top: 30px;
        }
        .case-details table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .case-details th,
        .case-details td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        .case-details th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="{{ asset('img/logo.png') }}" alt="Logo" class="logo">
        <div class="report-title">Case Status Report</div>
    </div>

    <div class="report-info">
        <div>
            <strong>Report Date:</strong> {{ date('F j, Y') }}<br>
            <strong>Case Number:</strong> {{ $selectedCase->case_id }}<br>
            <strong>Status:</strong> {{ $selectedCase->caseStatus->name ?? 'N/A' }}
        </div>
        <div style="text-align: right;">
            <strong>Generated On:</strong> {{ now()->format('F j, Y H:i') }}<br>
            <strong>Generated By:</strong> {{ auth()->user()->name ?? 'System' }}
        </div>
    </div>

    <div class="case-details">
        <h3>Case Details</h3>
        <table>
            <tr>
                <th width="30%">Field</th>
                <th width="70%">Value</th>
            </tr>
            <tr>
                <td><strong>Client Name:</strong></td>
                <td>{{ $selectedCase->client_name }}</td>
            </tr>
            <tr>
                <td><strong>Lawyer:</strong></td>
                <td>{{ $selectedCase->lawyer->name ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td><strong>Category:</strong></td>
                <td>{{ $selectedCase->caseCategory->name ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td><strong>Reason:</strong></td>
                <td>{{ $selectedCase->caseReason->name ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td><strong>Status:</strong></td>
                <td>{{ $selectedCase->caseStatus->name ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td><strong>Judgement:</strong></td>
                <td>{{ $selectedCase->judgement->name ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td><strong>Created Date:</strong></td>
                <td>{{ $selectedCase->created_at->format('F j, Y') }}</td>
            </tr>
            <tr>
                <td><strong>Last Updated:</strong></td>
                <td>{{ $selectedCase->updated_at->format('F j, Y H:i') }}</td>
            </tr>
            @if($selectedCase->description)
            <tr>
                <td><strong>Description:</strong></td>
                <td>{{ $selectedCase->description }}</td>
            </tr>
            @endif
        </table>
    </div>

    <div class="footer">
        <p>This report was generated automatically by the Legal Management System.</p>
        <p>Confidential - For internal use only.</p>
    </div>
</body>
</html>
