<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    @php use Illuminate\Support\Str; @endphp
    <title>Cashbook Daily Transactions</title>
    <style>
        @page {
            size: A4;
            margin: 15px 15px 30px 15px; /* Increased bottom margin for footer */
        }
        html, body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 9pt;
            margin: 0; padding: 0;
            color: #333;
            position: relative;
        }
        body {
            padding: 15px;
            box-sizing: border-box;
            padding-bottom: 40px; /* Space for footer */
        }

        .pdf-page {
            page-break-after: always;
            position: relative;
            min-height: 100%;
        }
        .pdf-page:last-child { page-break-after: auto; }

        .document-title {
            text-align: center;
            font-size: 15pt;
            font-weight: bold;
            color: #1a365d;
            margin-bottom: 15px;
            text-transform: uppercase;
        }

        .header-container {
            border-bottom: 1px solid #e2e8f0;
            padding-bottom: 15px;
            margin-bottom: 15px;
        }

        .info-row { width: 100%; border-collapse: collapse; }
        .info-row td { padding: 5px; vertical-align: top; }
        .info-left, .info-right { width: 50%; }
        .info-left { text-align: left; }
        .info-right { text-align: right; }
        .compact-info { font-size: 10pt; }

        .label, .value {
            display: inline-block;
            vertical-align: bottom;
            font-size: 9pt;
            font-family: 'DejaVu Sans', sans-serif;
        }

        .label {
            display: inline-block;
            vertical-align: bottom;
            font-family: 'DejaVu Sans', sans‑serif;
            font-size: 9pt;
            font-weight: normal;
            color: #1a365d;
        }

        .section-title {
            font-size: 10pt;
            font-weight: bold;
            color: #1a365d;
            text-transform: uppercase;
            margin-bottom: 5px;
            border-bottom: 1px solid #1a365d;
            padding-bottom: 2px;
            display: block;
        }

        .logo-full { text-align: left; margin-bottom: 1px; }
        .logo-full img { max-width: 100px; }

        .doc-info {
            display: flex;
            justify-content: space-between;
            font-size: 9pt;
            padding: 10px;
            background-color: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 4px;
            margin-bottom: 15px;
        }
        .doc-info div { line-height: 1.5; }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9pt;
            margin-bottom: 15px;
        }
        .items-table th {
            background-color: #1a365d;
            color: #fff;
            padding: 8px;
            text-align: center;
        }
        .items-table td {
            border: 1px solid #e2e8f0;
            padding: 8px;
            text-align: center;
        }
        .items-table tr:nth-child(even) { background-color: #f8fafc; }

        .total-row {
            border-top: 1px solid #333;
            font-weight: bold;
            background-color: #1a365d;
            color: #fff;
        }

        .negative { color: red; }
        .text-right { text-align: right; }

        /* Footer styles */
        .footer {
            position: absolute;
            bottom: -25px;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 8pt;
            color: #666;
            border-top: 1px solid #e2e8f0;
            padding-top: 5px;
        }
        .footer table {
            width: 100%;
        }
        .footer td {
            padding: 0;
        }
        .footer .text-right {
            text-align: right;
        }
    </style>
</head>
<body>
    <div class="pdf-page">
        <div class="document-title">
            Cashbook Daily Transactions
        </div>

        <div class="header-container">
            <table class="info-row compact-info">
                <tr>
                    <td class="info-left">
                        <span class="section-title">Company Information</span>
                        <div class="logo-full">
                            @if($company && $company->logo_path)
                                <img src="{{ asset($company->logo_path) }}" alt="Company Logo">
                            @endif
                        </div>
                        <div><span class="label">Name: </span><span class="value">{{ $company->name ?? 'Company Name' }}</span></div>
                        <div><span class="label">Address: </span><span class="value">{{ $company->address ?? 'Company Address' }}</span></div>
                        <div><span class="label">Phone: </span><span class="value">{{ $company->phone ?? 'Company Phone' }}</span></div>
                        <div><span class="label">Email: </span><span class="value">{{ $company->email ?? 'Company Email' }}</span></div>
                        @if($company && $company->vat_no)
                            <div><span class="label">VAT No: </span><span class="value">{{ $company->vat_no }}</span></div>
                        @endif
                        @if($company && $company->tin_no)
                            <div><span class="label">TIN No: </span><span class="value">{{ $company->tin_no }}</span></div>
                        @endif
                        <div><span class="label">Currency: </span><span class="value">{{ $currency->code }}</span></div>
                    </td>
                    <td class="info-right">
                        <span class="section-title">Cashbook Information</span>
                        <div><span class="label">Cashbook: </span><span class="value">{{ $cashbook->code }}</span></div>
                        <div><span class="label">Description: </span><span class="value">{{ $cashbook->description }}</span></div>
                        <div><span class="label">GL Account: </span><span class="value">{{ $cashbook->generalLedger->code }} - {{ $cashbook->generalLedger->account_name }}</span></div>
                    </td>
                </tr>
            </table>
        </div>

        <div class="doc-info">
            <div>
                <div><span class="label">Currency:</span> <strong>{{ $currency->code }}</strong></div>
                <div><span class="label">Period:</span> <strong>{{ $dateFrom }} to {{ $dateTo }}</strong></div>
            </div>
            <div>
                <div><span class="label">Report Date:</span> <strong>{{ date('d M Y') }}</strong></div>
            </div>
        </div>

        <table class="items-table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Description</th>
                    <th>Reference / GL Account</th>
                    <th>DR</th>
                    <th>CR</th>
                    <th>Balance</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $grandBalance = 0;
                @endphp

                @foreach($transactionData as $row)
                    @php
                        $grandBalance = $row['balance'];
                    @endphp
                    <tr>
                        <td>{{ $row['date'] }}</td>
                        <td>{{ $row['description'] }}</td>
                        <td>{{ $row['reference'] }}</td>
                        <td class="text-right">{{ number_format($row['dr'], 2) }}</td>
                        <td class="text-right">{{ number_format($row['cr'], 2) }}</td>
                        <td class="text-right @if($row['balance'] < 0) negative @endif">
                            @if($row['balance'] < 0)
                                ({{ number_format(abs($row['balance']), 2) }})
                            @else
                                {{ number_format($row['balance'], 2) }}
                            @endif
                        </td>
                    </tr>
                @endforeach

                <tr class="total-row">
                    <td colspan="5" class="text-right">Grand Balance:</td>
                    <td class="text-right @if($grandBalance < 0) negative @endif">
                        @if($grandBalance < 0)
                            ({{ number_format(abs($grandBalance), 2) }})
                        @else
                            {{ number_format($grandBalance, 2) }}
                        @endif
                    </td>
                </tr>
            </tbody>
        </table>

        <!-- Footer for each page -->
        <div class="footer">
            <table>
                <tr>
                    <td>&copy; {{ date('Y') }} Melsoft (Private) Limited. All rights reserved.</td>
                    <td class="text-right">Printed: {{ now()->setTimezone('Africa/Harare')->format('d M Y H:i') }}</td>
                </tr>
            </table>
        </div>
    </div>
</body>
</html>
