@extends('layouts.master')
@section('title', 'Cashbook Daily Transaction Report')
@section('content')

<div class="container-fluid py-3">
    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('modules.reports') }}" class="btn-back">
            <i class="fas fa-arrow-left me-2"></i> Back to Reports
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white py-3">
            <h5 class="mb-0"><i class="fas fa-book me-2"></i> Cashbook Report</h5>
        </div>

        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('cashbookDailyTransaction.generate') }}" method="POST" id="transactionForm">
                @csrf
                <div class="row mb-3">
                    <div class="col-md-3">
                        <label class="form-label"><strong>Cashbook Account</strong></label>
                        <select class="form-control select2" name="cashbook_account" id="cashbook_account" required>
                            <option value="" disabled selected>Select Cashbook</option>
                            @foreach($cashbooks as $cashbook)
                                <option value="{{ $cashbook->id }}" {{ (isset($cashbookId) && $cashbookId == $cashbook->id) ? 'selected' : '' }}>
                                    {{ $cashbook->code }} - {{ $cashbook->description }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label"><strong>Date From</strong></label>
                        <input type="date" class="form-control" name="date_from" id="date_from" value="{{ isset($dateFrom) ? $dateFrom : now()->format('Y-m-d') }}" required>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label"><strong>Date To</strong></label>
                        <input type="date" class="form-control" name="date_to" id="date_to" value="{{ isset($dateTo) ? $dateTo : now()->format('Y-m-d') }}" required>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label"><strong>Currency</strong></label>
                        <select class="form-control select2" name="currency" id="currency" required>
                            <option value="" disabled selected>Select Currency</option>
                            @foreach($currencies as $currency)
                                <option value="{{ $currency->code }}" {{ (isset($currencyCode) && $currencyCode == $currency->code) ? 'selected' : '' }}>
                                    {{ $currency->code }} - {{ $currency->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary me-2">Generate Report</button>
                    <button type="reset" class="btn btn-secondary" onclick="resetForm()">Refresh</button>
                </div>
            </form>
        </div>
    </div>

    @if(isset($transactionData) && count($transactionData) > 0)
        <div class="card shadow-sm mt-4">
            <div class="card-header bg-light py-3 d-flex justify-content-between align-items-center">
                <h6 class="mb-0"><i class="fas fa-list me-2"></i> Cashbook Daily Transactions - {{ $cashbook->code }} ({{ $cashbook->description }})</h6>
                <div>
                    <form action="{{ route('cashbookDailyTransaction.downloadPdf') }}" method="POST" class="d-inline">
                        @csrf
                        <input type="hidden" name="cashbook_account" value="{{ $cashbookId }}">
                        <input type="hidden" name="date_from" value="{{ $dateFrom }}">
                        <input type="hidden" name="date_to" value="{{ $dateTo }}">
                        <input type="hidden" name="currency" value="{{ $currencyCode }}">
                        <button type="submit" class="btn btn-process-all btn-sm">
                            <i class="fas fa-download me-1"></i> DOWNLOAD PDF
                        </button>
                    </form>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Date</th>
                                <th>Description</th>
                                <th>Reference / GL Account</th>
                                <th>DR</th>
                                <th>CR</th>
                                <th>Balance</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $grandBalance = 0;
                            @endphp
                            @foreach($transactionData as $row)
                                @php
                                    $grandBalance = $row['balance'];
                                @endphp
                                <tr>
                                    <td>{{ $row['date'] }}</td>
                                    <td>{{ $row['description'] }}</td>
                                    <td>{{ $row['reference'] }}</td>
                                    <td>{{ number_format($row['dr'], 2) }}</td>
                                    <td>{{ number_format($row['cr'], 2) }}</td>
                                    <td>{{ number_format($row['balance'], 2) }}</td>
                                </tr>
                            @endforeach
                            <!-- Grand Total Row -->
                            <tr class="table-active">
                                <td colspan="5" class="text-end"><strong>Grand Balance:</strong></td>
                                <td><strong>{{ number_format($grandBalance, 2) }}</strong></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="mt-4 text-center">
                    <p class="text-muted">Copyright © Melsoft (Private) Limited</p>
                </div>
            </div>
        </div>
    @elseif(isset($transactionData) && count($transactionData) == 0)
        <div class="card shadow-sm mt-4">
            <div class="card-body">
                <div class="alert alert-info mt-3">
                    No transactions found for the selected criteria.
                </div>
            </div>
        </div>
    @endif
</div>

@endsection

@section('styles')
<style>
.btn-back {
    text-decoration: none;
    color: #1AB9D9;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    padding: 5px 15px;
    border-radius: 4px;
    transition: all 0.3s;
}
.btn-back:hover {
    background-color: rgba(26, 185, 217, 0.1);
    text-decoration: none;
}
.card {
    border-radius: 8px;
    overflow: hidden;
    border: none;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}
.card-header {
    border-bottom: 1px solid rgba(0,0,0,0.1);
    padding: 12px 20px;
}
.table th {
    background-color: #f8f9fa;
}
.table-responsive {
    overflow-x: auto;
}
.table-active {
    background-color: rgba(0,0,0,.05) !important;
}
.btn-process-all {
    background-color: #ffffff !important;
    color: #1AB9D9 !important;
    border: 1px solid rgba(26,185,217,0.35) !important;
    font-weight: 600 !important;
    padding: 7px 14px !important;
    box-shadow: none !important;
    line-height: 1 !important;
}
.btn-process-all:hover {
    background-color: #f5fbfc !important;
    color: #1498b0 !important;
    border-color: rgba(20,152,176,0.45) !important;
}

@media print {
    .btn-back, .card-header .btn, form {
        display: none !important;
    }
    .card {
        box-shadow: none;
        border: 1px solid #ddd;
    }
    .table-responsive {
        overflow-x: visible;
    }
}
</style>
@endsection

@section('scripts')
<script>
    // Initialize Select2 for dropdowns
    $(document).ready(function() {
        $('.select2').select2({
            placeholder: "Select Option",
            allowClear: true
        });
    });

    function resetForm() {
        // Reset the select2 dropdowns
        $('#cashbook_account').val(null).trigger('change');
        $('#currency').val(null).trigger('change');
        $('#date_from').val('{{ now()->format('Y-m-d') }}');
        $('#date_to').val('{{ now()->format('Y-m-d') }}');
    }
</script>
@endsection
