@extends('layouts.master')

@section('title', 'Chart of Accounts - Prolex Law Firm')

@section('styles')
<style>
/* Custom styles for Chart of Accounts */
.table-responsive {
    display: block;
    width: 100%;
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
}

.table-bordered th,
.table-bordered td {
    padding: 8px 12px;
    vertical-align: middle;
    border: 1px solid #dee2e6;
}

.btn-circle {
    border-radius: 50%;
    width: 40px;
    height: 40px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
}

.card-header {
    background-color: #f8f9fa;
    border-bottom: 1px solid #dee2e6;
}

.form-control:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

.btn-user {
    padding: 0.75rem 1rem;
    border-radius: 0.35rem;
}

.invoice-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 2rem;
    border-radius: 10px;
    margin-bottom: 2rem;
}

.invoice-logo {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: white;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 1rem;
}

.report-table th {
    background-color: #007bff;
    color: white;
    border: none;
}

.report-table td {
    border: 1px solid #dee2e6;
}

.report-table tbody tr:nth-child(even) {
    background-color: #f8f9fa;
}

.report-table tbody tr:hover {
    background-color: #e9ecef;
}
</style>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Back Button -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <a href="{{ route('modules.reports') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i> Back to Reports
        </a>
        <button id="download-pdf" class="btn btn-primary">
            <i class="fas fa-print me-2"></i>Print Report
        </button>
    </div>

    <!-- Page Title -->
    <div class="invoice-header mb-4">
        <div class="d-flex align-items-center">
            <div class="invoice-logo">
                <i class="fas fa-chart-line fa-2x text-primary"></i>
            </div>
            <div>
                <h1 class="h2 mb-1">Chart of Accounts Report</h1>
                <p class="mb-0">Comprehensive view of all general ledger accounts</p>
            </div>
        </div>
    </div>

    <!-- Report Header -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-filter me-2"></i>Chart of Accounts Filters
            </h6>
        </div>
        <div class="card-body">
            <form action="{{ route('modules.reports.chart-of-accounts') }}" method="POST" id="accountTypeForm">
                @csrf
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="account" class="form-label fw-bold">Account Type</label>
                        <select class="form-control form-control-user" id="account" name="account" required>
                            <option value="All" disabled selected>Select Account Type</option>
                            <option value="32">Revenue</option>
                            <option value="33">Operating Expenses</option>
                            <option value="34">Sales</option>
                            <option value="35">Bank</option>
                            <option value="36">Fixed Asset</option>
                            <option value="37">Trade Receivable</option>
                            <option value="38">Trade Payable</option>
                            <option value="40">Suspense</option>
                            <option value="41">Current Liability</option>
                            <option value="42">Long-Term Liability</option>
                            <option value="43">Current Asset</option>
                            <option value="44">Share Capital</option>
                            <option value="47">Rent Receivable</option>
                            <option value="67">Petty Cash</option>
                        </select>
                    </div>
                </div>

                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-primary btn-user">
                        <i class="fas fa-eye me-2"></i>View Report
                    </button>
                    <button type="reset" class="btn btn-secondary btn-user" onclick="hideMessages()">
                        <i class="fas fa-refresh me-2"></i>Refresh
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Report Content -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex justify-content-between align-items-center">
            <h6 class="m-0 font-weight-bold text-primary">
                <i class="fas fa-table me-2"></i>All Accounts Report
            </h6>
            <div class="text-muted small">
                Generated on: {{ date('F j, Y \a\t g:i A') }}
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered report-table">
                    <thead>
                        <tr>
                            <th><i class="fas fa-hashtag me-1"></i>Code</th>
                            <th><i class="fas fa-tag me-1"></i>Description</th>
                            <th class="text-center"><i class="fas fa-money-bill-wave me-1"></i>Financial Category</th>
                            <th class="text-end"><i class="fas fa-layer-group me-1"></i>Account Type</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($accounts as $account)
                        <tr>
                            <td>{{ $account->code }}</td>
                            <td>{{ $account->name }}</td>
                            <td class="text-center">{{ $account->financial_category ?? 'N/A' }}</td>
                            <td class="text-end">{{ $account->accountType->name ?? 'Unknown' }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
function hideMessages() {
    // Hide any success/error messages if they exist
    const successMessage = document.getElementById('successMessage');
    const errorMessages = document.getElementById('errorMessages');

    if (successMessage) successMessage.style.display = 'none';
    if (errorMessages) errorMessages.style.display = 'none';
}

// Print functionality
document.getElementById('download-pdf').addEventListener('click', function() {
    window.print();
});
</script>
@endsection

