@extends('layouts.master')

@section('content')
<div class="container-fluid">
    <div class="mb-4">
        <a href="{{ route('modules.reports') }}" class="btn-back">
            <i class="fas fa-arrow-left me-2"></i> Back to Reports
        </a>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Client Statement</h3>
                </div>
                <div class="card-body">
                    <!-- Client Statement Filters -->
                    <form method="GET" action="{{ route('modules.reports.client-statement') }}" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="customer_account" class="form-label">Client Account</label>
                                <select name="customer_account" id="customer_account" class="form-control" required>
                                    <option value="" disabled selected>Select Client</option>
                                    <option value="all">All Clients</option>
                                    @foreach($clients as $client)
                                        <option value="{{ $client->id }}" {{ $selectedClient && $selectedClient->id == $client->id ? 'selected' : '' }}>
                                            {{ $client->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="date_from" class="form-label">Date From</label>
                                <input type="date" id="date_from" name="date_from" class="form-control" value="{{ date('Y-m-d', strtotime('first day of this month')) }}" required>
                            </div>
                            <div class="col-md-3">
                                <label for="date_to" class="form-label">Date To</label>
                                <input type="date" id="date_to" name="date_to" class="form-control" value="{{ date('Y-m-d') }}" required>
                            </div>
                            <div class="col-md-3">
                                <label for="currency" class="form-label">Currency</label>
                                <select name="currency" id="currency" class="form-control" required>
                                    <option value="" disabled selected>Select Currency</option>
                                    <option value="USD">USD - United States Dollar</option>
                                    <option value="ZAR">ZAR - RSA Rand</option>
                                    <option value="EUR">EUR - Euro</option>
                                    <option value="GBP">GBP - British Pound</option>
                                    <option value="ZMW">ZMW - Zambian Kwacha</option>
                                    <option value="BWP">BWP - Botswana Pula</option>
                                    <option value="ZWL">ZWL - Zimbabwe Dollar</option>
                                </select>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-12 text-end">
                                <button type="submit" class="btn btn-primary me-2">Generate Report</button>
                                <button type="reset" class="btn btn-secondary" onclick="resetForm()">Refresh</button>
                            </div>
                        </div>
                    </form>

                    @if($selectedClient)
                        <!-- Client Information -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h4>Client: {{ $selectedClient->name }}</h4>
                                <p><strong>Email:</strong> {{ $selectedClient->email ?? 'N/A' }}</p>
                                <p><strong>Phone:</strong> {{ $selectedClient->phone ?? 'N/A' }}</p>
                            </div>
                        </div>

                        <!-- Metrics Cards -->
                        <div class="row mb-4">
                            <div class="col-md-3">
                                <div class="card bg-primary text-white">
                                    <div class="card-body">
                                        <h5 class="card-title">Total Invoices</h5>
                                        <h3>${{ number_format($metrics['totalInvoices'], 2) }}</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card bg-success text-white">
                                    <div class="card-body">
                                        <h5 class="card-title">Total Receipts</h5>
                                        <h3>${{ number_format($metrics['totalReceipts'], 2) }}</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card bg-warning text-white">
                                    <div class="card-body">
                                        <h5 class="card-title">Balance</h5>
                                        <h3>${{ number_format($metrics['balance'], 2) }}</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="card bg-info text-white">
                                    <div class="card-body">
                                        <h5 class="card-title">Outstanding Invoices</h5>
                                        <h3>{{ $metrics['outstandingInvoices'] }}</h3>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Invoices Table -->
                        <div class="row">
                            <div class="col-12">
                                <h5>Invoices</h5>
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Invoice #</th>
                                            <th>Date</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                            <th>Description</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($invoices as $invoice)
                                            <tr>
                                                <td>{{ $invoice->invoice_number }}</td>
                                                <td>{{ $invoice->invoice_date ? $invoice->invoice_date->format('Y-m-d') : 'N/A' }}</td>
                                                <td>${{ number_format($invoice->total_amount, 2) }}</td>
                                                <td>
                                                    <span class="badge {{ $invoice->status == 'paid' ? 'badge-success' : 'badge-warning' }}">
                                                        {{ ucfirst($invoice->status) }}
                                                    </span>
                                                </td>
                                                <td>{{ $invoice->description ?? 'N/A' }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="5" class="text-center">No invoices found</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- Receipts Table -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <h5>Receipts</h5>
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Receipt #</th>
                                            <th>Date</th>
                                            <th>Amount</th>
                                            <th>Payment Method</th>
                                            <th>Description</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($receipts as $receipt)
                                            <tr>
                                                <td>{{ $receipt->receipt_number }}</td>
                                                <td>{{ $receipt->receipt_date ? $receipt->receipt_date->format('Y-m-d') : 'N/A' }}</td>
                                                <td>${{ number_format($receipt->total_amount, 2) }}</td>
                                                <td>{{ $receipt->payment_method ?? 'N/A' }}</td>
                                                <td>{{ $receipt->description ?? 'N/A' }}</td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="5" class="text-center">No receipts found</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    @else
                        <div class="alert alert-info">
                            Please select a client to view their statement.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function resetForm() {
    document.getElementById('customer_account').selectedIndex = 0;
    document.getElementById('date_from').value = '{{ date('Y-m-d', strtotime('first day of this month')) }}';
    document.getElementById('date_to').value = '{{ date('Y-m-d') }}';
    document.getElementById('currency').selectedIndex = 0;
}
</script>
@endsection

@section('styles')
<style>
.btn-back {
    text-decoration: none;
    color: #1AB9D9;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    padding: 5px 15px;
    border-radius: 4px;
    transition: all 0.3s;
}
.btn-back:hover {
    background-color: rgba(26, 185, 217, 0.1);
    text-decoration: none;
}
</style>
@endsection

