<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Court Filings Report - {{ \Carbon\Carbon::parse($pfrom)->format('M d, Y') }} to {{ \Carbon\Carbon::parse($pto)->format('M d, Y') }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            color: #333;
        }
        .header p {
            margin: 5px 0;
            font-size: 14px;
            color: #666;
        }
        .summary {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 5px;
        }
        .summary-item {
            text-align: center;
            flex: 1;
        }
        .summary-item h3 {
            margin: 0;
            font-size: 18px;
            color: #333;
        }
        .summary-item p {
            margin: 5px 0 0 0;
            font-size: 12px;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            vertical-align: top;
        }
        th {
            background-color: #f8f9fa;
            font-weight: bold;
            font-size: 11px;
        }
        td {
            font-size: 10px;
        }
        .text-center {
            text-align: center;
        }
        .badge {
            display: inline-block;
            padding: 3px 8px;
            font-size: 9px;
            font-weight: bold;
            border-radius: 3px;
            text-transform: uppercase;
        }
        .badge-success {
            background-color: #28a745;
            color: white;
        }
        .badge-warning {
            background-color: #ffc107;
            color: black;
        }
        .badge-danger {
            background-color: #dc3545;
            color: white;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
        .no-data {
            text-align: center;
            padding: 50px;
            font-size: 14px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Court Filings Report</h1>
        <p>Period: {{ \Carbon\Carbon::parse($pfrom)->format('M d, Y') }} to {{ \Carbon\Carbon::parse($pto)->format('M d, Y') }}</p>
        <p>Generated on: {{ now()->format('M d, Y H:i') }}</p>
    </div>

    @if($courtFilings->count() > 0)
        <div class="summary">
            <div class="summary-item">
                <h3>{{ $courtFilings->count() }}</h3>
                <p>Total Filings</p>
            </div>
            <div class="summary-item">
                <h3>{{ $courtFilings->where('status', 'approved')->count() }}</h3>
                <p>Approved</p>
            </div>
            <div class="summary-item">
                <h3>{{ $courtFilings->where('status', 'pending')->count() }}</h3>
                <p>Pending</p>
            </div>
            <div class="summary-item">
                <h3>{{ $courtFilings->where('status', 'rejected')->count() }}</h3>
                <p>Rejected</p>
            </div>
        </div>

        <table>
            <thead>
                <tr>
                    <th>Filing Date</th>
                    <th>Case ID</th>
                    <th>Lawyer</th>
                    <th>Court Area</th>
                    <th>Court Type</th>
                    <th>Judge</th>
                    <th>Filing Type</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($courtFilings as $filing)
                    <tr>
                        <td>{{ \Carbon\Carbon::parse($filing->filing_date)->format('M d, Y') }}</td>
                        <td>{{ $filing->case->case_id ?? 'N/A' }}</td>
                        <td>{{ $filing->lawyer->name ?? 'N/A' }}</td>
                        <td>{{ $filing->courtArea->name ?? 'N/A' }}</td>
                        <td>{{ $filing->courtType->name ?? 'N/A' }}</td>
                        <td>{{ $filing->judge->name ?? 'N/A' }}</td>
                        <td>{{ $filing->filing_type ?? 'N/A' }}</td>
                        <td class="text-center">
                            <span class="badge {{ $filing->status == 'approved' ? 'badge-success' : ($filing->status == 'pending' ? 'badge-warning' : 'badge-danger') }}">
                                {{ ucfirst($filing->status ?? 'N/A') }}
                            </span>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @else
        <div class="no-data">
            <p>No court filings found for the selected period.</p>
        </div>
    @endif

    <div class="footer">
        <p>Report generated by Prolex Law Firm Management System</p>
    </div>
</body>
</html>
