@extends('layouts.master')

@section('title', 'Court Filings Report - Prolex Law Firm')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-0 text-gray-800">
                        <i class="fas fa-gavel text-primary me-2"></i>Court Filings Report
                    </h1>
                    <p class="text-muted mb-0">View and filter court filing records</p>
                </div>
                <a href="{{ route('modules.reports') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Reports
                </a>
            </div>
        </div>
    </div>

    <!-- Filters Card -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-filter text-primary me-2"></i>Report Filters
                    </h6>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('courtFilings.generate') }}" class="row g-3">
                        @csrf
                        <div class="col-md-4">
                            <label for="pfrom" class="form-label fw-bold">From Date</label>
                            <input type="date" class="form-control form-control-lg" id="pfrom" name="pfrom" value="{{ request('pfrom', old('pfrom')) }}" required>
                        </div>
                        <div class="col-md-4">
                            <label for="pto" class="form-label fw-bold">To Date</label>
                            <input type="date" class="form-control form-control-lg" id="pto" name="pto" value="{{ request('pto', old('pto')) }}" required>
                        </div>
                        <div class="col-md-4 d-flex align-items-end">
                            <div class="d-grid gap-2 w-100">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="fas fa-search me-2"></i>Generate Report
                                </button>
                                @if(isset($courtFilings) && $courtFilings->count() > 0)
                                    <button type="submit" formaction="{{ route('courtFilings.downloadPdf') }}" class="btn btn-success btn-lg">
                                        <i class="fas fa-download me-2"></i>Download PDF
                                    </button>
                                @endif
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Report Data -->
    @if(isset($courtFilings))
        @if($courtFilings->count() > 0)
            <!-- Summary Stats -->
            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="card border-left-primary shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                        Total Filings
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $courtFilings->count() }}</div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-file-alt fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card border-left-success shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                        Period
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        {{ \Carbon\Carbon::parse($pfrom)->format('M d, Y') }} - {{ \Carbon\Carbon::parse($pto)->format('M d, Y') }}
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-calendar fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card border-left-info shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                        Status Summary
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        {{ $courtFilings->where('status', 'approved')->count() }} Approved
                                    </div>
                                    <div class="text-xs text-muted">
                                        {{ $courtFilings->where('status', 'pending')->count() }} Pending, {{ $courtFilings->where('status', 'rejected')->count() }} Rejected
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-info-circle fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Data Table -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-table text-primary me-2"></i>Court Filings
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover table-striped" id="courtFilingsTable">
                            <thead class="table-dark">
                                <tr>
                                    <th><i class="fas fa-calendar me-1"></i>Filing Date</th>
                                    <th><i class="fas fa-hashtag me-1"></i>Case ID</th>
                                    <th><i class="fas fa-user-tie me-1"></i>Lawyer</th>
                                    <th><i class="fas fa-building me-1"></i>Court Area</th>
                                    <th><i class="fas fa-gavel me-1"></i>Court Type</th>
                                    <th><i class="fas fa-balance-scale me-1"></i>Judge</th>
                                    <th><i class="fas fa-file-alt me-1"></i>Filing Type</th>
                                    <th><i class="fas fa-info-circle me-1"></i>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($courtFilings as $filing)
                                    <tr>
                                        <td>{{ \Carbon\Carbon::parse($filing->filing_date)->format('M d, Y') }}</td>
                                        <td><span class="badge bg-secondary">{{ $filing->case->case_id ?? 'N/A' }}</span></td>
                                        <td>{{ $filing->lawyer->name ?? 'N/A' }}</td>
                                        <td>{{ $filing->courtArea->name ?? 'N/A' }}</td>
                                        <td>{{ $filing->courtType->name ?? 'N/A' }}</td>
                                        <td>{{ $filing->judge->name ?? 'N/A' }}</td>
                                        <td><span class="badge bg-info">{{ $filing->filing_type ?? 'N/A' }}</span></td>
                                        <td>
                                            <span class="badge {{ $filing->status == 'approved' ? 'bg-success' : ($filing->status == 'pending' ? 'bg-warning' : 'bg-danger') }}">
                                                {{ ucfirst($filing->status ?? 'N/A') }}
                                            </span>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @else
            <!-- No Data -->
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center py-5">
                    <i class="fas fa-inbox fa-4x text-gray-300 mb-3"></i>
                    <h4 class="text-gray-500">No Court Filings Found</h4>
                    <p class="text-muted">No court filings match your selected criteria. Try adjusting your filters.</p>
                </div>
            </div>
        @endif
    @else
        <!-- Initial State -->
        <div class="card border-0 shadow-sm">
            <div class="card-body text-center py-5">
                <i class="fas fa-search fa-4x text-gray-300 mb-3"></i>
                <h4 class="text-gray-500">Ready to Generate Report</h4>
                <p class="text-muted">Please select date range to generate the court filings report.</p>
            </div>
        </div>
    @endif
</div>

@push('styles')
<style>
    .border-left-primary {
        border-left: 0.25rem solid #4e73df !important;
    }
    .border-left-success {
        border-left: 0.25rem solid #1cc88a !important;
    }
    .border-left-info {
        border-left: 0.25rem solid #36b9cc !important;
    }
    .table th {
        border-top: none;
        font-weight: 600;
        font-size: 0.875rem;
    }
    .badge {
        font-size: 0.75rem;
    }
</style>
@endpush

@push('scripts')
<script>
    $(document).ready(function() {
        $('#courtFilingsTable').DataTable({
            "pageLength": 25,
            "order": [[0, "desc"]],
            "responsive": true,
            "language": {
                "search": "Search filings:",
                "lengthMenu": "Show _MENU_ entries per page",
                "info": "Showing _START_ to _END_ of _TOTAL_ entries",
                "infoEmpty": "No filings available",
                "infoFiltered": "(filtered from _MAX_ total entries)"
            }
        });
    });
</script>
@endpush
@endsection

