 b  @extends('layouts.master')
@section('title', 'Fee Collection Report')

@section('styles')
<style>
/* Button back */
.btn-back {
    text-decoration: none;
    color: #1AB9D9;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    padding: 5px 15px;
    border-radius: 6px;
    transition: all 0.3s ease;
}
.btn-back:hover {
    background-color: rgba(26, 185, 217, 0.1);
}

/* Cards */
.card {
    border-radius: 1rem;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    transition: transform 0.3s, box-shadow 0.3s;
}
.card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.1);
}

/* Metric cards */
.metric-card {
    padding: 1.5rem;
    background: #fff;
    border-radius: 1rem;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    transition: transform 0.3s, box-shadow 0.3s;
}
.metric-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.1);
}
.metric-title {
    font-size: 0.9rem;
    font-weight: 600;
    color: #6b7280;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}
.metric-value {
    font-size: 1.75rem;
    font-weight: 700;
    color: #111827;
}

/* Table */
.table-container {
    overflow-x: auto;
    border-radius: 1rem;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    background: #fff;
    margin-top: 1.5rem;
}
table {
    width: 100%;
    border-collapse: collapse;
}
thead {
    background: #f9fafb;
}
th, td {
    padding: 0.75rem 1rem;
    text-align: left;
    font-size: 0.95rem;
}
tbody tr:hover {
    background-color: #f3f4f6;
}

/* Status badges */
.status-badge {
    padding: 0.25rem 0.75rem;
    border-radius: 9999px;
    font-size: 0.75rem;
    font-weight: 600;
    display: inline-block;
}
.status-paid { background-color: rgba(34,197,94,0.2); color: #22c55e; }
.status-partially_paid { background-color: rgba(250,202,21,0.2); color: #facc15; }
.status-unpaid { background-color: rgba(239,68,68,0.2); color: #ef4444; }

/* Animations */
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}
.animate-fade-in { animation: fadeIn 0.5s ease-in-out; }
</style>
@endsection

@section('content')
<div class="container-fluid py-3 animate-fade-in">

    <!-- Back -->
    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('modules.reports') }}" class="btn-back">
            <i class="fas fa-arrow-left me-2"></i> Back to Reports
        </a>
    </div>

    <!-- Metrics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="metric-card text-center">
                <div class="metric-title">Total Collected</div>
                <div class="metric-value">${{ number_format($metrics['totalCollected'], 2) }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="metric-card text-center">
                <div class="metric-title">Total Invoices</div>
                <div class="metric-value">{{ $metrics['totalInvoices'] }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="metric-card text-center">
                <div class="metric-title">Paid Invoices</div>
                <div class="metric-value">{{ $metrics['paidInvoices'] ?? 0 }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="metric-card text-center">
                <div class="metric-title">Outstanding Amount</div>
                <div class="metric-value">${{ number_format($metrics['outstandingAmount'] ?? 0, 2) }}</div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card mb-4 p-3">
        <div class="row g-3">
            <div class="col-md-3">
                <label class="form-label">Client</label>
                <select class="form-select">
                    <option value="all">All Clients</option>
                    @foreach($clients as $client)
                        <option value="{{ $client->id }}">{{ $client->full_name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">From Date</label>
                <input type="date" class="form-control" value="{{ date('Y-m-d', strtotime('first day of this month')) }}">
            </div>
            <div class="col-md-3">
                <label class="form-label">To Date</label>
                <input type="date" class="form-control" value="{{ date('Y-m-d') }}">
            </div>
            <div class="col-md-3 d-flex align-items-end">
                <button class="btn btn-primary w-100">Apply Filters</button>
            </div>
        </div>
    </div>

    <!-- Fee Collection Table -->
    <div class="table-container">
        <table class="table table-hover mb-0">
            <thead>
                <tr>
                    <th>Invoice #</th>
                    <th>Client</th>
                    <th>Invoice Date</th>
                    <th>Total Amount</th>
                    <th>Amount Collected</th>
                    <th>Balance</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($invoices as $invoice)
                @php
                    $collected = $invoice->receiptLines->sum('amount');
                    $balance = $invoice->total - $collected;
                    $status = $balance == 0 ? 'paid' : ($collected > 0 ? 'partially_paid' : 'unpaid');
                @endphp
                <tr>
                    <td>{{ $invoice->invoice_number }}</td>
                    <td>{{ $invoice->client->name ?? 'N/A' }}</td>
                    <td>{{ $invoice->invoice_date->format('Y-m-d') }}</td>
                    <td>${{ number_format($invoice->total, 2) }}</td>
                    <td>${{ number_format($collected, 2) }}</td>
                    <td>${{ number_format($balance, 2) }}</td>
                    <td>
                        <span class="status-badge status-{{ $status }}">{{ ucfirst(str_replace('_',' ',$status)) }}</span>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="7" class="text-center text-muted">No fee records found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection

