@extends('layouts.master')

@section('title', 'General Journal Report - Prolex Law Firm')

@section('content')
<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-0 text-gray-800">
                        <i class="fas fa-book-open text-primary me-2"></i>General Journal Report
                    </h1>
                    <p class="text-muted mb-0">View and filter general ledger transactions</p>
                </div>
                <a href="{{ route('modules.reports.journals') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Journals
                </a>
            </div>
        </div>
    </div>

    <!-- Filters Card -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-filter text-primary me-2"></i>Report Filters
                    </h6>
                </div>
                <div class="card-body">
                    <form method="GET" action="{{ route('modules.reports.journals.general') }}" class="row g-3">
                        <div class="col-md-3">
                            <label for="pfrom" class="form-label fw-bold">From Date</label>
                            <input type="date" class="form-control form-control-lg" id="pfrom" name="pfrom" value="{{ request('pfrom') }}">
                        </div>
                        <div class="col-md-3">
                            <label for="pto" class="form-label fw-bold">To Date</label>
                            <input type="date" class="form-control form-control-lg" id="pto" name="pto" value="{{ request('pto') }}">
                        </div>
                        <div class="col-md-3">
                            <label for="curr" class="form-label fw-bold">Currency</label>
                            <select class="form-select form-select-lg" id="curr" name="curr">
                                <option value="">All Currencies</option>
                                @foreach($currencies ?? [] as $currency)
                                    <option value="{{ $currency->id }}" {{ request('curr') == $currency->id ? 'selected' : '' }}>
                                        {{ $currency->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="fas fa-search me-2"></i>Generate Report
                                </button>
                                @if(isset($journalEntries) && $journalEntries->count() > 0)
                                    <a href="{{ route('modules.reports.journals.general', request()->query()) }}&download=pdf" class="btn btn-success btn-lg">
                                        <i class="fas fa-download me-2"></i>Download PDF
                                    </a>
                                @endif
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Report Data -->
    @if(isset($journalEntries))
        @if($journalEntries->count() > 0)
            <!-- Summary Stats -->
            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="card border-left-primary shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                        Total Entries
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $journalEntries->count() }}</div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-list fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card border-left-success shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                        Total Debit
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        ${{ number_format($journalEntries->where('tr_code', 'DR')->sum('amount'), 2) }}
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-plus fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card border-left-info shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                        Total Credit
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        ${{ number_format($journalEntries->where('tr_code', 'CR')->sum('amount'), 2) }}
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-minus fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Data Table -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-table text-primary me-2"></i>Journal Entries
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover table-striped" id="journalTable">
                            <thead class="table-dark">
                                <tr>
                                    <th><i class="fas fa-calendar me-1"></i>Date</th>
                                    <th><i class="fas fa-hashtag me-1"></i>Account Code</th>
                                    <th><i class="fas fa-tag me-1"></i>Account Name</th>
                                    <th><i class="fas fa-comment me-1"></i>Description</th>
                                    <th class="text-end"><i class="fas fa-plus-circle me-1"></i>Debit</th>
                                    <th class="text-end"><i class="fas fa-minus-circle me-1"></i>Credit</th>
                                    <th><i class="fas fa-money-bill me-1"></i>Currency</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($journalEntries as $entry)
                                    <tr>
                                        <td>{{ \Carbon\Carbon::parse($entry->date)->format('M d, Y') }}</td>
                                        <td><span class="badge bg-secondary">{{ $entry->account->code ?? 'N/A' }}</span></td>
                                        <td>{{ $entry->account->name ?? 'N/A' }}</td>
                                        <td>{{ $entry->narration }}</td>
                                        <td class="text-end fw-bold text-success">
                                            {{ $entry->tr_code == 'DR' ? '$' . number_format($entry->amount, 2) : '-' }}
                                        </td>
                                        <td class="text-end fw-bold text-danger">
                                            {{ $entry->tr_code == 'CR' ? '$' . number_format($entry->amount, 2) : '-' }}
                                        </td>
                                        <td><span class="badge bg-info">{{ $entry->currency->name ?? 'N/A' }}</span></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @else
            <!-- No Data -->
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center py-5">
                    <i class="fas fa-inbox fa-4x text-gray-300 mb-3"></i>
                    <h4 class="text-gray-500">No Journal Entries Found</h4>
                    <p class="text-muted">No journal entries match your selected criteria. Try adjusting your filters.</p>
                </div>
            </div>
        @endif
    @else
        <!-- Initial State -->
        <div class="card border-0 shadow-sm">
            <div class="card-body text-center py-5">
                <i class="fas fa-search fa-4x text-gray-300 mb-3"></i>
                <h4 class="text-gray-500">Ready to Generate Report</h4>
                <p class="text-muted">Please select date range and currency to generate the journal report.</p>
            </div>
        </div>
    @endif
</div>

@push('styles')
<style>
    .border-left-primary {
        border-left: 0.25rem solid #4e73df !important;
    }
    .border-left-success {
        border-left: 0.25rem solid #1cc88a !important;
    }
    .border-left-info {
        border-left: 0.25rem solid #36b9cc !important;
    }
    .table th {
        border-top: none;
        font-weight: 600;
        font-size: 0.875rem;
    }
    .badge {
        font-size: 0.75rem;
    }
</style>
@endpush

@push('scripts')
<script>
    $(document).ready(function() {
        $('#journalTable').DataTable({
            "pageLength": 25,
            "order": [[0, "desc"]],
            "responsive": true,
            "language": {
                "search": "Search entries:",
                "lengthMenu": "Show _MENU_ entries per page",
                "info": "Showing _START_ to _END_ of _TOTAL_ entries",
                "infoEmpty": "No entries available",
                "infoFiltered": "(filtered from _MAX_ total entries)"
            }
        });
    });
</script>
@endpush
@endsection

