<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>General Ledger Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            color: #333;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .account-type {
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 10px;
            font-weight: bold;
        }
        .asset { background-color: #d4edda; color: #155724; }
        .liability { background-color: #f8d7da; color: #721c24; }
        .equity { background-color: #cce5ff; color: #004085; }
        .income { background-color: #e2e3e5; color: #383d41; }
        .expense { background-color: #fff3cd; color: #856404; }
        .summary {
            margin-top: 30px;
            page-break-inside: avoid;
        }
        .summary table {
            width: auto;
            margin: 0 auto;
        }
        .summary th, .summary td {
            padding: 10px;
        }
        @media print {
            body { margin: 0; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>General Ledger Report</h1>
        <p>Generated on: {{ date('F j, Y \a\t g:i A') }}</p>
        <p>Prolex Law Firm</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>GL Code</th>
                <th>GL Name / Description</th>
                <th>Account Type</th>
                <th class="text-right">Debit</th>
                <th class="text-right">Credit</th>
                <th class="text-right">Balance</th>
                <th>Currency</th>
                <th>Last Transaction Date</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($glAccounts as $account)
            <tr>
                <td>{{ $account['glcode'] }}</td>
                <td>{{ $account['name'] }}</td>
                <td>
                    <span class="account-type {{ strtolower($account['accounttype']) }}">
                        {{ $account['accounttype'] }}
                    </span>
                </td>
                <td class="text-right">${{ number_format($account['debit'], 2) }}</td>
                <td class="text-right">${{ number_format($account['credit'], 2) }}</td>
                <td class="text-right ${{ $account['balance'] < 0 ? 'text-red-600' : 'text-green-600' }}">
                    ${{ number_format($account['balance'], 2) }}
                </td>
                <td>{{ $account['currency'] }}</td>
                <td>{{ $account['last_transaction_date'] ? \Carbon\Carbon::parse($account['last_transaction_date'])->format('M d, Y') : 'N/A' }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="summary">
        <h3 style="text-align: center; margin-bottom: 15px;">Summary</h3>
        <table>
            <thead>
                <tr>
                    <th>Total Accounts</th>
                    <th>Total Debit</th>
                    <th>Total Credit</th>
                    <th>Net Balance</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="text-center">{{ count($glAccounts) }}</td>
                    <td class="text-right">${{ number_format(collect($glAccounts)->sum('debit'), 2) }}</td>
                    <td class="text-right">${{ number_format(collect($glAccounts)->sum('credit'), 2) }}</td>
                    <td class="text-right">${{ number_format(collect($glAccounts)->sum('balance'), 2) }}</td>
                </tr>
            </tbody>
        </table>
    </div>
</body>
</html>
