@extends('layouts.master')

@section('title', 'General Ledger - Prolex Law Firm')

@section('styles')
<style>
/* Base styles for a clean, modern look with blue accents */
body {
    font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
    background-color: #f9fafb;
    color: #333;
}

/* Container */
.container {
    max-width: 1280px;
    margin: 0 auto;
    padding: 2rem;
}

/* Buttons */
.btn {
    display: inline-flex;
    align-items: center;
    padding: 0.75rem 1.5rem;
    font-weight: 600;
    border-radius: 8px;
    transition: background-color 0.3s, transform 0.2s;
    cursor: pointer;
}
.btn-primary {
    background-color: #3b82f6; /* Blue-500 */
    color: #fff;
}
.btn-primary:hover {
    background-color: #2563eb; /* Blue-600 */
    transform: translateY(-2px);
}
.btn-secondary {
    background-color: #6b7280; /* Gray-500 */
    color: #fff;
}
.btn-secondary:hover {
    background-color: #4b5563; /* Gray-700 */
    transform: translateY(-2px);
}
.btn-success {
    background-color: #10b981; /* Green-500 */
    color: #fff;
}
.btn-success:hover {
    background-color: #059669; /* Green-600 */
}
.btn-red {
    background-color: #ef4444; /* Red-500 */
    color: #fff;
}
.btn-red:hover {
    background-color: #dc2626; /* Red-600 */
}

/* Cards */
.card {
    background-color: #fff;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    padding: 1.5rem;
    transition: box-shadow 0.3s;
}
.card:hover {
    box-shadow: 0 8px 24px rgba(0,0,0,0.1);
}

/* Tables */
.table {
    width: 100%;
    border-collapse: collapse;
    border-radius: 8px;
    overflow: hidden;
}
.table th, .table td {
    padding: 1rem;
    text-align: left;
}
.table th {
    background-color: #f3f4f6;
    cursor: pointer;
}
.table th:hover {
    background-color: #e5e7eb;
}
.table tbody tr:nth-child(even) {
    background-color: #fafafa;
}
.table tbody tr:hover {
    background-color: #f3f4f6;
}
.sort-icon {
    margin-left: 0.5rem;
    font-size: 0.75rem;
}

/* Responsive Inputs & Selects */
input[type="date"], input[type="text"], select {
    width: 100%;
    padding: 0.75rem 1rem;
    border-radius: 8px;
    border: 1px solid #d1d5db;
    transition: border-color 0.3s, box-shadow 0.3s;
}
input[type="date"]:focus, input[type="text"]:focus, select:focus {
    outline: none;
    border-color: #3b82f6;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.2);
}

/* Pagination */
.pagination {
    display: flex;
    gap: 0.5rem;
}
.pagination button {
    padding: 0.5rem 0.75rem;
    border-radius: 6px;
    border: none;
    background-color: #f9fafb;
    cursor: pointer;
    transition: background-color 0.3s, transform 0.2s;
}
.pagination button:hover {
    background-color: #e5e7eb;
    transform: translateY(-1px);
}
.pagination .active {
    background-color: #3b82f6;
    color: #fff;
}

/* Misc */
@media(max-width: 768px) {
    .grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
}
</style>
@endsection

@section('content')
<div class="container">
    <!-- Back Button -->
    <a href="{{ route('modules.reports') }}" class="btn btn-secondary mb-4 transition hover:bg-gray-600">
        <i class="fas fa-arrow-left me-2"></i> Back to Reports
    </a>

    <!-- Title -->
    <h1 class="text-4xl font-bold mb-8 text-center text-gray-800">General Ledger</h1>

    <!-- Filters Panel -->
    <div class="card mb-8">
        <h2 class="text-xl font-semibold text-blue-600 mb-4 border-b pb-2">Filters</h2>
        <div class="grid md:grid-cols-4 gap-6 mb-4">
            <!-- From Date -->
            <div>
                <label class="block mb-2 text-sm font-medium text-gray-700">From Date</label>
                <input type="date" id="from_date" class="w-full" value="{{ date('Y-m-d', strtotime('first day of this month')) }}" />
            </div>
            <!-- To Date -->
            <div>
                <label class="block mb-2 text-sm font-medium text-gray-700">To Date</label>
                <input type="date" id="to_date" class="w-full" value="{{ date('Y-m-d') }}" />
            </div>
            <!-- Account Type -->
            <div>
                <label class="block mb-2 text-sm font-medium text-gray-700">Account Type</label>
                <select id="account_type" class="w-full">
                    <option value="">All Types</option>
                    <option value="Asset">Asset</option>
                    <option value="Liability">Liability</option>
                    <option value="Equity">Equity</option>
                    <option value="Income">Income</option>
                    <option value="Expense">Expense</option>
                </select>
            </div>
            <!-- Currency -->
            <div>
                <label class="block mb-2 text-sm font-medium text-gray-700">Currency</label>
                <select id="currency" class="w-full">
                    <option value="">All Currencies</option>
                    <option value="USD">USD</option>
                    <option value="EUR">EUR</option>
                    <option value="GBP">GBP</option>
                    <option value="ZAR">ZAR</option>
                </select>
            </div>
        </div>
        <!-- Search & Buttons -->
        <div class="flex flex-col md:flex-row items-center justify-between gap-4">
            <input type="text" id="search" placeholder="Search GL accounts..." class="flex-1" />
            <div class="flex gap-3 flex-wrap">
                <button id="apply_filters" class="btn btn-primary">Apply Filters</button>
                <button id="clear_filters" class="btn btn-secondary">Clear</button>
                <button id="export_excel" class="btn btn-success">Export Excel</button>
                <a href="{{ route('modules.reports.general-ledger.download-pdf') }}" class="btn btn-red">Download PDF</a>
            </div>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="grid md:grid-cols-4 gap-6 mb-8">
        <div class="card p-4">
            <h3 class="text-sm font-semibold text-gray-600 mb-2">Grand Total</h3>
            <p class="text-2xl font-bold text-blue-600" id="grand_total">${{ number_format(collect($glAccounts)->sum('balance'), 2) }}</p>
        </div>
        <div class="card p-4">
            <h3 class="text-sm font-semibold text-gray-600 mb-2">Total Debit</h3>
            <p class="text-2xl font-bold text-green-600" id="total_debit">${{ number_format(collect($glAccounts)->sum('debit'), 2) }}</p>
        </div>
        <div class="card p-4">
            <h3 class="text-sm font-semibold text-gray-600 mb-2">Total Credit</h3>
            <p class="text-2xl font-bold text-red-600" id="total_credit">${{ number_format(collect($glAccounts)->sum('credit'), 2) }}</p>
        </div>
        <div class="card p-4">
            <h3 class="text-sm font-semibold text-gray-600 mb-2">Net Balance</h3>
            <p class="text-2xl font-bold text-purple-600" id="net_balance">${{ number_format(collect($glAccounts)->sum('balance'), 2) }}</p>
        </div>
    </div>

    <!-- Data Table -->
    <div class="card overflow-x-auto">
        <div class="flex justify-between items-center mb-4 border-b pb-2">
            <h2 class="text-xl font-semibold text-gray-700">GL Accounts</h2>
            <div class="text-sm text-gray-500">
                Showing <span id="showing_count">{{ count($glAccounts) }}</span> of <span id="total_count">{{ count($glAccounts) }}</span> accounts
            </div>
        </div>
        <table class="table" id="gl-table">
            <thead>
                <tr>
                    <th class="cursor-pointer" data-sort="glcode">GL Code <span class="sort-icon">↕</span></th>
                    <th class="cursor-pointer" data-sort="name">GL Name / Description <span class="sort-icon">↕</span></th>
                    <th class="cursor-pointer" data-sort="reference">Reference <span class="sort-icon">↕</span></th>
                    <th class="cursor-pointer" data-sort="accounttype">Account Type <span class="sort-icon">↕</span></th>
                    <th class="cursor-pointer text-right" data-sort="debit">Debit <span class="sort-icon">↕</span></th>
                    <th class="cursor-pointer text-right" data-sort="credit">Credit <span class="sort-icon">↕</span></th>
                    <th class="cursor-pointer text-right" data-sort="balance">Balance <span class="sort-icon">↕</span></th>
                    <th class="">Currency</th>
                    <th class="cursor-pointer" data-sort="last_transaction_date">Last Transaction Date <span class="sort-icon">↕</span></th>
                    <th class="text-center">Account Totals</th>
                    <th class="text-center">Account Type Totals</th>
                    <th class="text-center">Grand Totals</th>
                    <th class="text-center">Action / Drill-down</th>
                </tr>
            </thead>
            <tbody id="gl-table-body" class="divide-y divide-gray-200">
                <!-- Account data rows will be populated here -->
            </tbody>
        </table>
        <!-- Pagination -->
        <div class="mt-4 flex justify-between items-center">
            <select id="page_size" class="border border-gray-300 rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500 transition w-40">
                <option value="10">10 per page</option>
                <option value="25" selected>25 per page</option>
                <option value="50">50 per page</option>
                <option value="100">100 per page</option>
            </select>
            <div class="pagination" id="pagination"></div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script>
    // Your existing JavaScript logic here...
    // Keep consistent with the new UI styling.
</script>
@endsection

