@extends('layouts.master')

@section('title', 'GL Account Detail - Prolex Law Firm')

@section('content')
<div class="p-10 max-w-7xl mx-auto">
    <h1 class="text-4xl font-bold mb-8 text-center text-gray-800">GL Account Detail - {{ $glcode }}</h1>

    <div class="bg-white p-6 rounded-lg shadow-md overflow-x-auto">
        <table class="w-full table-auto border-collapse border border-gray-300">
            <thead class="bg-gray-100">
                <tr>
                    <th class="border border-gray-300 px-4 py-2 text-left">Transaction Date</th>
                    <th class="border border-gray-300 px-4 py-2 text-left">Reference / Receipt / Invoice Number</th>
                    <th class="border border-gray-300 px-4 py-2 text-left">Description / Notes</th>
                    <th class="border border-gray-300 px-4 py-2 text-center">TR Code (DR/CR)</th>
                    <th class="border border-gray-300 px-4 py-2 text-right">Amount in Transaction Currency</th>
                    <th class="border border-gray-300 px-4 py-2 text-right">Converted Amount in Home Currency</th>
                    <th class="border border-gray-300 px-4 py-2 text-right">Balance After Transaction</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($transactions as $transaction)
                <tr class="hover:bg-gray-50">
                    <td class="border border-gray-300 px-4 py-2">{{ $transaction['date'] }}</td>
                    <td class="border border-gray-300 px-4 py-2">{{ $transaction['reference'] }}</td>
                    <td class="border border-gray-300 px-4 py-2">{{ $transaction['description'] }}</td>
                    <td class="border border-gray-300 px-4 py-2 text-center">{{ $transaction['trcode'] }}</td>
                    <td class="border border-gray-300 px-4 py-2 text-right">{{ number_format($transaction['amount'], 2) }}</td>
                    <td class="border border-gray-300 px-4 py-2 text-right">{{ number_format($transaction['converted_amount'], 2) }}</td>
                    <td class="border border-gray-300 px-4 py-2 text-right {{ $transaction['balance_after'] < 0 ? 'text-red-600' : 'text-green-600' }}">{{ number_format($transaction['balance_after'], 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="mt-6 text-center">
        <a href="{{ route('modules.reports.general-ledger') }}" class="bg-gray-600 text-white px-6 py-3 rounded hover:bg-gray-700 transition">Back to General Ledger</a>
    </div>
</div>
@endsection

