@extends('layouts.master')

@section('title', 'Journals - Prolex Law Firm')

@section('content')
<style>
    .journal-card {
        transition: all 0.3s ease;
        border: none;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }
    .journal-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
    }
    .journal-icon {
        font-size: 2.5rem;
        margin-bottom: 1rem;
    }
    .bg-gradient-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }
    .bg-gradient-success {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    }
    .bg-gradient-info {
        background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    }
</style>

<div class="container-fluid py-4">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-0 text-gray-800">
                        <i class="fas fa-journal-whills text-primary me-2"></i>Journals
                    </h1>
                    <p class="text-muted mb-0">Select a journal type to view detailed reports</p>
                </div>
                <a href="{{ route('modules.reports') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back to Reports
                </a>
            </div>
        </div>
    </div>

    <!-- Journal Cards -->
    <div class="row g-4">
        <!-- General Journal -->
        <div class="col-lg-4 col-md-6">
            <div class="card journal-card h-100">
                <div class="card-body text-center p-4">
                    <div class="bg-gradient-primary rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="fas fa-book-open text-white journal-icon"></i>
                    </div>
                    <h5 class="card-title mb-3">General Journal</h5>
                    <p class="card-text text-muted mb-4">View all general ledger transactions and entries</p>
                    <a href="{{ route('modules.reports.journals.general') }}" class="btn btn-primary btn-lg w-100">
                        <i class="fas fa-eye me-2"></i>View Report
                    </a>
                </div>
            </div>
        </div>

        <!-- Customer Journal -->
        <div class="col-lg-4 col-md-6">
            <div class="card journal-card h-100">
                <div class="card-body text-center p-4">
                    <div class="bg-gradient-success rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="fas fa-users text-white journal-icon"></i>
                    </div>
                    <h5 class="card-title mb-3">Customer Journal</h5>
                    <p class="card-text text-muted mb-4">Track customer-related transactions and payments</p>
                    <a href="{{ route('modules.reports.journals.customer') }}" class="btn btn-success btn-lg w-100">
                        <i class="fas fa-eye me-2"></i>View Report
                    </a>
                </div>
            </div>
        </div>

        <!-- Supplier Journal -->
        <div class="col-lg-4 col-md-6">
            <div class="card journal-card h-100">
                <div class="card-body text-center p-4">
                    <div class="bg-gradient-info rounded-circle d-inline-flex align-items-center justify-content-center mb-3" style="width: 80px; height: 80px;">
                        <i class="fas fa-truck text-white journal-icon"></i>
                    </div>
                    <h5 class="card-title mb-3">Supplier Journal</h5>
                    <p class="card-text text-muted mb-4">Monitor supplier transactions and invoices</p>
                    <a href="{{ route('modules.reports.journals.supplier') }}" class="btn btn-info btn-lg w-100">
                        <i class="fas fa-eye me-2"></i>View Report
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="row mt-5">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <h6 class="card-title mb-3">
                        <i class="fas fa-chart-line text-primary me-2"></i>Quick Overview
                    </h6>
                    <div class="row text-center">
                        <div class="col-md-4">
                            <div class="p-3">
                                <h4 class="text-primary mb-1">{{ \App\Models\GeneralJournal::count() }}</h4>
                                <small class="text-muted">Total General Entries</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="p-3">
                                <h4 class="text-success mb-1">{{ \App\Models\ClientJournal::count() }}</h4>
                                <small class="text-muted">Total Client Entries</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="p-3">
                                <h4 class="text-info mb-1">{{ \App\Models\GeneralJournal::count() }}</h4>
                                <small class="text-muted">Total Supplier Entries</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

