@extends('layouts.master')
@section('title', 'Outstanding Fees Report')

@section('styles')
<style>
/* Back button */
.btn-back {
    text-decoration: none;
    color: #1AB9D9;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    padding: 6px 16px;
    border-radius: 6px;
    transition: all 0.3s ease;
}
.btn-back:hover {
    background-color: rgba(26, 185, 217, 0.1);
}

/* Cards */
.card, .metric-card {
    border-radius: 1rem;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    transition: transform 0.3s, box-shadow 0.3s;
}
.card:hover, .metric-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.1);
}

/* Metrics */
.metric-title { 
    font-size: 0.9rem; 
    font-weight: 600; 
    color: #6b7280; 
    text-transform: uppercase; 
    letter-spacing: 0.05em; 
}
.metric-value { 
    font-size: 1.75rem; 
    font-weight: 700; 
    color: #111827; 
}

/* Table */
.table-container {
    overflow-x: auto;
    border-radius: 1rem;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    background: #fff;
    margin-top: 1.5rem;
}
table {
    width: 100%;
    border-collapse: collapse;
}
thead {
    background: #f9fafb;
}
th, td {
    padding: 0.75rem 1rem;
    text-align: left;
    font-size: 0.95rem;
}
tbody tr:hover {
    background-color: #f3f4f6;
}

/* Status badges */
.status-badge {
    padding: 0.25rem 0.75rem;
    border-radius: 9999px;
    font-size: 0.75rem;
    font-weight: 600;
    display: inline-block;
}
.status-paid { background-color: rgba(34,197,94,0.2); color: #22c55e; }
.status-partially_paid { background-color: rgba(250,202,21,0.2); color: #facc15; }
.status-unpaid, .status-overdue { background-color: rgba(239,68,68,0.2); color: #ef4444; }

/* Animations */
@keyframes fadeIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
.animate-fade-in { animation: fadeIn 0.5s ease-in-out; }
</style>
@endsection

@section('content')
<div class="container-fluid py-3 animate-fade-in">

    <!-- Back -->
    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('modules.reports') }}" class="btn-back">
            <i class="fas fa-arrow-left me-2"></i> Back to Reports
        </a>
    </div>

    <!-- Header -->
    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-4">
        <div>
            <h1 class="text-4xl font-bold bg-gradient-to-r from-primary to-accent bg-clip-text text-transparent">
                Outstanding Fees Report
            </h1>
            <p class="text-muted-foreground mt-1">Track and manage unpaid invoices</p>
        </div>
        <div class="flex flex-wrap gap-3">
            <button class="gap-2 bg-blue-500 hover:bg-blue-600 text-white rounded-lg px-4 py-2 flex items-center transition-colors">
                <i class="fas fa-file-excel me-1"></i> Export Excel
            </button>
            <button class="gap-2 bg-red-500 hover:bg-red-600 text-white rounded-lg px-4 py-2 flex items-center transition-colors">
                <i class="fas fa-file-pdf me-1"></i> Download PDF
            </button>
        </div>
    </div>

    <!-- Filters -->
    <div class="card p-4 mb-4">
        <div class="row g-3">
            <div class="col-md-3">
                <label class="form-label">Client</label>
                <select class="form-select">
                    <option value="all">All Clients</option>
                    @foreach($clients as $client)
                        <option value="{{ $client->id }}">{{ $client->full_name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">From Date</label>
                <input type="date" class="form-control" value="{{ date('Y-m-d', strtotime('first day of this month')) }}">
            </div>
            <div class="col-md-3">
                <label class="form-label">To Date</label>
                <input type="date" class="form-control" value="{{ date('Y-m-d') }}">
            </div>
            <div class="col-md-3 d-flex align-items-end">
                <button class="btn btn-primary w-100">Apply Filters</button>
            </div>
        </div>
    </div>

    <!-- Metrics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="metric-card text-center">
                <div class="metric-title">Total Outstanding</div>
                <div class="metric-value">${{ number_format($metrics['totalOutstanding'], 2) }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="metric-card text-center">
                <div class="metric-title">Overdue Amount</div>
                <div class="metric-value text-danger">${{ number_format($metrics['overdueAmount'], 2) }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="metric-card text-center">
                <div class="metric-title">Total Invoices</div>
                <div class="metric-value">{{ $metrics['totalInvoices'] }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="metric-card text-center">
                <div class="metric-title">Avg Days Overdue</div>
                <div class="metric-value text-warning">{{ $metrics['avgDaysOverdue'] }}</div>
            </div>
        </div>
    </div>

    <!-- Table -->
    <div class="table-container">
        <table class="table table-hover mb-0">
            <thead>
                <tr>
                    <th>Client Name</th>
                    <th>Invoice #</th>
                    <th>Invoice Date</th>
                    <th>Due Date</th>
                    <th>Total Amount</th>
                    <th>Paid Amount</th>
                    <th>Balance Due</th>
                    <th>Status</th>
                    <th>Days Overdue</th>
                    <th>Currency</th>
                </tr>
            </thead>
            <tbody>
                @forelse($invoices as $invoice)
                @php
                    $collected = $invoice->receiptLines->sum('amount');
                    $balance = $invoice->total - $collected;
                    $status = $balance == 0 ? 'paid' : ($collected > 0 ? 'partially_paid' : ($invoice->due_date < now() ? 'overdue' : 'unpaid'));
                @endphp
                <tr>
                    <td>{{ $invoice->client->full_name ?? 'N/A' }}</td>
                    <td>{{ $invoice->invoice_number }}</td>
                    <td>{{ $invoice->invoice_date->format('M j, Y') }}</td>
                    <td>{{ $invoice->due_date->format('M j, Y') }}</td>
                    <td>${{ number_format($invoice->total, 2) }}</td>
                    <td>${{ number_format($collected, 2) }}</td>
                    <td class="{{ $balance > 0 ? 'text-danger font-bold' : 'text-success font-bold' }}">${{ number_format($balance, 2) }}</td>
                    <td><span class="status-badge status-{{ $status }}">{{ ucfirst(str_replace('_',' ',$status)) }}</span></td>
                    <td class="{{ $invoice->due_date < now() ? 'text-danger' : 'text-success' }}">
                        {{ $invoice->due_date < now() ? now()->diffInDays($invoice->due_date) . ' days' : 'Not overdue' }}
                    </td>
                    <td>{{ $invoice->currency->code ?? 'N/A' }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="10" class="text-center text-muted">No outstanding fees found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection

