<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Outstanding Sales Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
            color: #333;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        .summary {
            display: table;
            width: 100%;
            margin-bottom: 30px;
            border-collapse: collapse;
        }
        .summary-row {
            display: table-row;
        }
        .summary-cell {
            display: table-cell;
            padding: 10px;
            border: 1px solid #ddd;
            text-align: center;
            width: 25%;
        }
        .summary-label {
            font-weight: bold;
            background-color: #f5f5f5;
        }
        .summary-value {
            font-size: 18px;
            font-weight: bold;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .status-badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: bold;
        }
        .status-paid {
            background-color: #d4edda;
            color: #155724;
        }
        .status-partially_paid {
            background-color: #fff3cd;
            color: #856404;
        }
        .status-unpaid {
            background-color: #f8d7da;
            color: #721c24;
        }
        .balance-due {
            font-weight: bold;
        }
        .overdue {
            color: #dc3545;
        }
        .not-overdue {
            color: #28a745;
        }
        .page-break {
            page-break-before: always;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Outstanding Sales Report</h1>
        <p>Generated on {{ \Carbon\Carbon::now()->format('M d, Y H:i') }}</p>
    </div>

    <!-- Summary Cards -->
    <div class="summary">
        <div class="summary-row">
            <div class="summary-cell summary-label">Total Outstanding</div>
            <div class="summary-cell summary-label">Overdue Amount</div>
            <div class="summary-cell summary-label">Total Invoices</div>
            <div class="summary-cell summary-label">Average Days Overdue</div>
        </div>
        <div class="summary-row">
            <div class="summary-cell summary-value">${{ number_format($outstandingInvoices->sum('balance_due'), 2) }}</div>
            <div class="summary-cell summary-value">${{ number_format($outstandingInvoices->where('days_overdue', '>', 0)->sum('balance_due'), 2) }}</div>
            <div class="summary-cell summary-value">{{ $outstandingInvoices->count() }}</div>
            <div class="summary-cell summary-value">{{ $outstandingInvoices->where('days_overdue', '>', 0)->avg('days_overdue') ? round($outstandingInvoices->where('days_overdue', '>', 0)->avg('days_overdue')) : 0 }}</div>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>Client Name</th>
                <th>Invoice #</th>
                <th>Invoice Date</th>
                <th>Due Date</th>
                <th class="text-right">Total Amount</th>
                <th class="text-right">Paid Amount</th>
                <th class="text-right">Balance Due</th>
                <th>Status</th>
                <th>Days Overdue</th>
                <th>Currency</th>
            </tr>
        </thead>
        <tbody>
            @foreach($outstandingInvoices as $invoice)
            <tr>
                <td>{{ $invoice['client_name'] }}</td>
                <td>{{ $invoice['invoice_number'] }}</td>
                <td>{{ \Carbon\Carbon::parse($invoice['invoice_date'])->format('M d, Y') }}</td>
                <td>{{ $invoice['due_date'] ? \Carbon\Carbon::parse($invoice['due_date'])->format('M d, Y') : 'N/A' }}</td>
                <td class="text-right">${{ number_format($invoice['total_amount'], 2) }}</td>
                <td class="text-right">${{ number_format($invoice['paid_amount'], 2) }}</td>
                <td class="text-right balance-due">${{ number_format($invoice['balance_due'], 2) }}</td>
                <td>
                    <span class="status-badge status-{{ $invoice['status'] }}">
                        {{ ucfirst(str_replace('_', ' ', $invoice['status'])) }}
                    </span>
                </td>
                <td>
                    @if($invoice['days_overdue'] > 0)
                        <span class="overdue">{{ $invoice['days_overdue'] }} days</span>
                    @else
                        <span class="not-overdue">Not overdue</span>
                    @endif
                </td>
                <td>{{ $invoice['currency'] }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    @if($outstandingInvoices->isEmpty())
    <div style="text-align: center; padding: 50px; color: #666;">
        <p>No outstanding sales found.</p>
    </div>
    @endif
</body>
</html>
