{{-- resources/views/modules/reports/supplier-statement.blade.php --}}
@extends('layouts.master')
@section('title', 'Supplier Statement Report')
@section('content')

<div class="container-fluid py-3">
    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('modules.reports') }}" class="btn-back">
            <i class="fas fa-arrow-left me-2"></i> Back to Reports
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white py-3">
            <h5 class="mb-0"><i class="fas fa-file-invoice-dollar me-2"></i> Supplier Statement Report</h5>
        </div>

        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('supplierStatement.generate') }}" method="POST" id="statementForm">
                @csrf
                <div class="row mb-3">
                    <div class="col-md-3">
                        <label class="form-label"><strong>Supplier Account</strong></label>
                        <select class="form-control" name="supplier_account" id="supplier_account" required>
                            <option value="" disabled selected>Select Supplier</option>
                            <option value="all" {{ (isset($supplierId) && $supplierId == 'all') ? 'selected' : '' }}>All Suppliers</option>
                            @foreach($suppliers as $supplier)
                                <option value="{{ $supplier->id }}" {{ (isset($supplierId) && $supplierId == $supplier->id) ? 'selected' : '' }}>
                                    {{ $supplier->supplier_code }} - {{ $supplier->supplier_account }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label"><strong>Date From</strong></label>
                        <input type="date" class="form-control" name="date_from" id="date_from" value="{{ isset($dateFrom) ? $dateFrom : date('Y-m-d') }}" required>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label"><strong>Date To</strong></label>
                        <input type="date" class="form-control" name="date_to" id="date_to" value="{{ isset($dateTo) ? $dateTo : date('Y-m-d') }}" required>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label"><strong>Currency</strong></label>
                        <select class="form-control" name="currency" id="currency" required>
                            <option value="" disabled selected>Select Currency</option>
                            @foreach($currencies as $currency)
                                <option value="{{ $currency->code }}" {{ (isset($currencyCode) && $currencyCode == $currency->code) ? 'selected' : '' }}>
                                    {{ $currency->code }} - {{ $currency->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary me-2">Generate Report</button>
                    <button type="reset" class="btn btn-secondary" onclick="resetForm()">Refresh</button>
                </div>
            </form>

            <hr>

            @if(isset($allStatements) && count($allStatements) > 0)
                <div class="d-flex justify-content-end mb-3">
                    <form action="{{ route('supplierStatement.downloadPdf') }}" method="POST">
                        @csrf
                        <input type="hidden" name="supplier_account" value="{{ $supplierId }}">
                        <input type="hidden" name="date_from" value="{{ $dateFrom }}">
                        <input type="hidden" name="date_to" value="{{ $dateTo }}">
                        <input type="hidden" name="currency" value="{{ $currencyCode }}">
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-download me-2"></i> Download PDF for All Suppliers
                        </button>
                    </form>
                </div>

                @foreach($allStatements as $supplierStatement)
                <div class="card mb-4">
                    <div class="card-header">
                        <h6 class="mb-0">{{ $supplierStatement['supplier']->supplier_account }} ({{ $supplierStatement['supplier']->supplier_code }})</h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="table-light">
                                    <tr>
                                        <th>Date</th>
                                        <th>Description</th>
                                        <th>Reference</th>
                                        <th class="text-end">DR</th>
                                        <th class="text-end">CR</th>
                                        <th class="text-end">Balance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $balance = $supplierStatement['openingBalance'];
                                        $grandBalance = $balance;
                                    @endphp
                                    <tr>
                                        <td>{{ $dateFrom }}</td>
                                        <td>Opening Balance</td>
                                        <td></td>
                                        <td class="text-end">{{ number_format($balance > 0 ? $balance : 0, 2) }}</td>
                                        <td class="text-end">{{ number_format($balance < 0 ? abs($balance) : 0, 2) }}</td>
                                        <td class="text-end">{{ number_format($balance, 2) }}</td>
                                    </tr>
                                    @foreach($supplierStatement['statementData'] as $row)
                                        @php
                                            $balance += ($row['dr'] - $row['cr']);
                                            $grandBalance = $balance;
                                        @endphp
                                        <tr>
                                            <td>{{ $row['date'] }}</td>
                                            <td>{{ $row['description'] }}</td>
                                            <td>{{ $row['reference'] }}</td>
                                            <td class="text-end">{{ number_format($row['dr'], 2) }}</td>
                                            <td class="text-end">{{ number_format($row['cr'], 2) }}</td>
                                            <td class="text-end">{{ number_format($balance, 2) }}</td>
                                        </tr>
                                    @endforeach
                                    <tr class="table-secondary">
                                        <td colspan="5" class="text-end"><strong>Grand Total :</strong></td>
                                        <td class="text-end"><strong>{{ number_format($grandBalance, 2) }}</strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                @endforeach

                <div class="text-center mt-4">
                    <p class="text-muted">Copyright © Melsoft (Private) Limited</p>
                </div>

            @elseif(isset($statementData) && count($statementData) > 0)
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h6 class="mb-0">Supplier Statement</h6>
                        <form action="{{ route('supplierStatement.downloadPdf') }}" method="POST">
                            @csrf
                            <input type="hidden" name="supplier_account" value="{{ $supplierId }}">
                            <input type="hidden" name="date_from" value="{{ $dateFrom }}">
                            <input type="hidden" name="date_to" value="{{ $dateTo }}">
                            <input type="hidden" name="currency" value="{{ $currencyCode }}">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-download me-2"></i> Download PDF
                            </button>
                        </form>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="table-light">
                                    <tr>
                                        <th>Date</th>
                                        <th>Description</th>
                                        <th>Reference</th>
                                        <th class="text-end">DR</th>
                                        <th class="text-end">CR</th>
                                        <th class="text-end">Balance</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $grandBalance = 0;
                                    @endphp
                                    @foreach($statementData as $row)
                                        @php
                                            $grandBalance += $row['balance'];
                                        @endphp
                                        <tr>
                                            <td>{{ $row['date'] }}</td>
                                            <td>{{ $row['description'] }}</td>
                                            <td>{{ $row['reference'] }}</td>
                                            <td class="text-end">{{ number_format($row['dr'], 2) }}</td>
                                            <td class="text-end">{{ number_format($row['cr'], 2) }}</td>
                                            <td class="text-end">{{ number_format($row['balance'], 2) }}</td>
                                        </tr>
                                    @endforeach
                                    <tr class="table-secondary">
                                        <td colspan="5" class="text-end"><strong>Grand Total :</strong></td>
                                        <td class="text-end"><strong>{{ number_format($grandBalance, 2) }}</strong></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center mt-4">
                            <p class="text-muted">Copyright © Melsoft (Private) Limited</p>
                        </div>
                    </div>
                </div>

            @elseif(isset($statementData) && count($statementData) == 0)
                <div class="alert alert-info">
                    No transactions found for the selected criteria.
                </div>
            @endif
        </div>
    </div>
</div>

@endsection

@section('styles')
<style>
.btn-back {
    text-decoration: none;
    color: #1AB9D9;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    padding: 5px 15px;
    border-radius: 4px;
    transition: all 0.3s;
}
.btn-back:hover {
    background-color: rgba(26, 185, 217, 0.1);
    text-decoration: none;
}
.card {
    border-radius: 8px;
    overflow: hidden;
    border: none;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}
.card-header {
    border-bottom: 1px solid rgba(0,0,0,0.1);
    padding: 12px 20px;
}
.table th {
    background-color: #f8f9fa;
}
</style>
@endsection

@push('scripts')
<script>
function resetForm() {
    $('#supplier_account').val(null).trigger('change');
    $('#currency').val(null).trigger('change');
    const today = new Date().toISOString().split('T')[0];
    $('#date_from').val(today);
    $('#date_to').val(today);
}
</script>
@endpush
