<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Trial Balance Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h2 {
            margin: 0;
            font-size: 18px;
        }
        .info {
            margin-bottom: 20px;
        }
        .info p {
            margin: 5px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .text-right {
            text-align: right;
        }
        .total-row {
            font-weight: bold;
            background-color: #e9ecef;
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>Trial Balance Report</h2>
    </div>

    <div class="info">
        <p><strong>Date:</strong> {{ date('F j, Y') }}</p>
        <p><strong>Currency:</strong> {{ $currnames }}</p>
        <p><strong>From:</strong> {{ $pfrom }} <strong>To:</strong> {{ $pto }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Account Code</th>
                <th>Account Name</th>
                <th>Debit</th>
                <th>Credit</th>
                <th>Balance</th>
            </tr>
        </thead>
        <tbody>
            @forelse($glAccounts as $account)
                <tr>
                    <td>{{ $account['code'] }}</td>
                    <td>{{ $account['name'] }}</td>
                    <td class="text-right">{{ number_format($account['debit'], 2) }}</td>
                    <td class="text-right">{{ number_format($account['credit'], 2) }}</td>
                    <td class="text-right">{{ number_format($account['balance'], 2) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" style="text-align: center;">No accounts found</td>
                </tr>
            @endforelse
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="2" style="text-align: right;"><strong>Total</strong></td>
                <td class="text-right"><strong>{{ number_format($totalDebit, 2) }}</strong></td>
                <td class="text-right"><strong>{{ number_format($totalCredit, 2) }}</strong></td>
                <td class="text-right"><strong>{{ number_format($totalBalance, 2) }}</strong></td>
            </tr>
        </tfoot>
    </table>
</body>
</html>
