s@extends('layouts.master')
@section('title', 'Trial Balance Report')
@section('content')

<div class="container-fluid py-3">
    <div class="d-flex justify-content-end mb-3">
        <a href="{{ route('modules.reports') }}" class="text-decoration-none">
            <i class="fas fa-arrow-left me-2"></i> Back to Reports
        </a>
    </div>

    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white py-3">
            <h5 class="mb-0"><i class="fas fa-balance-scale me-2"></i> Trial Balance Report</h5>
        </div>

        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('modules.reports.trial-balance') }}" method="POST">
                @csrf
                <div class="row mb-3">
                    <div class="col-md-4">
                        <label class="form-label"><strong>From Period</strong></label>
                        <input type="date" class="form-control" name="pfrom" value="{{ old('pfrom', date('Y-m-d')) }}" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label"><strong>To Period</strong></label>
                        <input type="date" class="form-control" name="pto" value="{{ old('pto', date('Y-m-d')) }}" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label"><strong>Select Currency</strong></label>
                        <select class="form-control" name="curr" required>
                            <option value="" disabled selected>Select Currency</option>
                            @foreach($currencies as $currency)
                                <option value="{{ $currency->id }}" {{ old('curr') == $currency->id ? 'selected' : '' }}>
                                    {{ $currency->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-primary me-2">View Report</button>
                    <button type="reset" class="btn btn-secondary">Refresh</button>
                </div>
            </form>

            <hr>

            @if(isset($trialBalanceData))
                <div class="d-flex justify-content-end mb-3">
                    <form action="{{ route('modules.reports.trial-balance.download-pdf') }}" method="POST">
                        @csrf
                        <input type="hidden" name="pfrom" value="{{ $pfrom }}">
                        <input type="hidden" name="pto" value="{{ $pto }}">
                        <input type="hidden" name="currencyId" value="{{ $currencyId }}">
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-download me-2"></i> Download PDF
                        </button>
                    </form>
                </div>

                <div class="report-container">
                    <div class="report-header mb-4">
                        <div class="d-flex align-items-center mb-3">
                            <img src="{{ asset('img/logo.png') }}" alt="Logo" style="height: 60px;" class="me-3">
                            <h4 class="mb-0">Trial Balance Statement</h4>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Date:</strong> {{ date('F j, Y') }}</p>
                            </div>
                            <div class="col-md-6 text-md-end">
                                <p class="mb-1"><strong>Currency:</strong> {{ $currnames }}</p>
                                <p class="mb-1"><strong>From:</strong> {{ $pfrom }} <strong>To:</strong> {{ $pto }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive mb-4">
                        <table class="table table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th>Account Code</th>
                                    <th>Account Name</th>
                                    <th>Debit</th>
                                    <th>Credit</th>
                                    <th>Balance</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($trialBalanceData as $account)
                                    <tr>
                                        <td>{{ $account['code'] }}</td>
                                        <td>{{ $account['name'] }}</td>
                                        <td>{{ number_format($account['debit'], 2) }}</td>
                                        <td>{{ number_format($account['credit'], 2) }}</td>
                                        <td>{{ number_format($account['balance'], 2) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center">No accounts found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                            <tfoot class="table-secondary">
                                <tr>
                                    <td colspan="2" class="text-end"><strong>Total</strong></td>
                                    <td><strong>{{ number_format($totalDebit, 2) }}</strong></td>
                                    <td><strong>{{ number_format($totalCredit, 2) }}</strong></td>
                                    <td><strong>{{ number_format($totalBalance, 2) }}</strong></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>

@endsection

@section('styles')
<style>
.btn-back {
    text-decoration: none;
    color: #1AB9D9;
    font-weight: 500;
    display: inline-flex;
    align-items: center;
    padding: 5px 15px;
    border-radius: 4px;
    transition: all 0.3s;
}
.btn-back:hover {
    background-color: rgba(26, 185, 217, 0.1);
    text-decoration: none;
}
.card {
    border-radius: 8px;
    overflow: hidden;
    border: none;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
}
.card-header {
    border-bottom: 1px solid rgba(0,0,0,0.1);
    padding: 12px 20px;
}
.table th {
    background-color: #f8f9fa;
}
.report-header {
    border-bottom: 2px solid #dee2e6;
    padding-bottom: 20px;
}
</style>
@endsection
