<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacy Policy - Prolex Legal System</title>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --primary-color: #87CEEB;
            --secondary-color: #2c3e50;
            --accent-color: #e74c3c;
            --success-color: #27ae60;
            --light-bg: #f8f9fa;
            --dark-text: #2c3e50;
            --light-text: #7f8c8d;
            --border-color: #e0e6ed;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--light-bg);
            color: var(--dark-text);
            line-height: 1.6;
        }

        .legal-document-container {
            min-height: 100vh;
        }

        .legal-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, #b0c4de 100%);
            padding: 3rem 0;
            color: #1a1a1a;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }

        .container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 0 2rem;
        }

        .back-link {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            color: #1a1a1a;
            text-decoration: none;
            font-weight: 500;
            margin-bottom: 1.5rem;
            transition: all 0.3s ease;
        }

        .back-link:hover {
            transform: translateX(-5px);
            color: #000;
        }

        .legal-title {
            font-family: 'Cinzel', serif;
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            text-shadow: 2px 2px 4px rgba(255,255,255,0.3);
        }

        .legal-subtitle {
            font-size: 1.1rem;
            opacity: 0.8;
        }

        .legal-content {
            padding: 4rem 0;
        }

        .legal-card {
            background: white;
            border-radius: 16px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.08);
            padding: 3rem;
            margin-bottom: 2rem;
        }

        .legal-section {
            margin-bottom: 3rem;
        }

        .legal-section:last-child {
            margin-bottom: 0;
        }

        .legal-section h2 {
            font-size: 1.8rem;
            color: var(--secondary-color);
            margin-bottom: 1.5rem;
            padding-bottom: 0.75rem;
            border-bottom: 2px solid var(--primary-color);
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .legal-section h2 i {
            color: var(--primary-color);
        }

        .legal-section h3 {
            font-size: 1.3rem;
            color: var(--secondary-color);
            margin: 1.5rem 0 1rem 0;
        }

        .legal-section p {
            margin-bottom: 1rem;
            font-size: 1rem;
            line-height: 1.8;
        }

        .legal-section ul {
            margin: 1rem 0 1.5rem 1.5rem;
            list-style-type: none;
        }

        .legal-section ul li {
            margin-bottom: 0.75rem;
            padding-left: 1.5rem;
            position: relative;
            line-height: 1.7;
        }

        .legal-section ul li::before {
            content: "▸";
            position: absolute;
            left: 0;
            color: var(--primary-color);
            font-weight: bold;
        }

        .legal-section ul li strong {
            color: var(--secondary-color);
        }

        .contact-info {
            background: var(--light-bg);
            padding: 1.5rem;
            border-radius: 10px;
            border-left: 4px solid var(--primary-color);
            margin-top: 1rem;
        }

        .contact-info p {
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .contact-info i {
            color: var(--primary-color);
            width: 20px;
        }

        .acknowledgment {
            background: linear-gradient(135deg, #fff3cd, #ffeaa7);
            padding: 1.5rem;
            border-radius: 10px;
            border-left: 4px solid #f39c12;
            margin-top: 2rem;
        }

        .acknowledgment p {
            margin: 0;
            color: var(--secondary-color);
        }

        @media (max-width: 768px) {
            .legal-title {
                font-size: 2rem;
            }

            .legal-card {
                padding: 2rem 1.5rem;
            }

            .legal-section h2 {
                font-size: 1.5rem;
            }

            .container {
                padding: 0 1rem;
            }
        }
    </style>
</head>
<body>
    <div class="legal-document-container">
        <div class="legal-header">
            <div class="container">
                <a href="#" class="back-link" onclick="window.history.back(); return false;">
                    <i class="fas fa-arrow-left"></i> Back to Login
                </a>
                <h1 class="legal-title">Privacy Policy</h1>
                <p class="legal-subtitle">Last Updated: December 31, 2025</p>
            </div>
        </div>

        <div class="legal-content">
            <div class="container">
                <div class="legal-card">
                    <section class="legal-section">
                        <h2><i class="fas fa-shield-alt"></i> Introduction</h2>
                        <p>Welcome to Prolex Legal System ("we," "us," or "our"). We are committed to protecting your privacy and ensuring the security of your personal information. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you use our law firm management platform.</p>
                        <p>This policy applies to all users of Prolex Legal System, including lawyers, legal professionals, and administrative staff. By using our services, you agree to the collection and use of information in accordance with this policy.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-info-circle"></i> Information We Collect</h2>

                        <h3>Personal Information</h3>
                        <p>We collect personal information that you provide directly to us, including:</p>
                        <ul>
                            <li>Name, email address, and contact information</li>
                            <li>Professional credentials and licensing information</li>
                            <li>Law firm affiliation and role</li>
                            <li>Account login credentials</li>
                            <li>Payment information for subscription services</li>
                        </ul>

                        <h3>Client and Case Data</h3>
                        <p>As a legal management platform, you may upload and store sensitive client information, including:</p>
                        <ul>
                            <li>Client names, contact details, and personal information</li>
                            <li>Case details, court filings, and legal documents</li>
                            <li>Financial information and billing records</li>
                            <li>Communication records and case notes</li>
                        </ul>

                        <h3>Usage Data</h3>
                        <p>We automatically collect certain information about your use of our platform:</p>
                        <ul>
                            <li>IP address and location information</li>
                            <li>Browser type and version</li>
                            <li>Pages visited and time spent on our platform</li>
                            <li>Device information and operating system</li>
                            <li>Login times and session duration</li>
                        </ul>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-question-circle"></i> How We Use Your Information</h2>
                        <p>We use the information we collect for the following purposes:</p>
                        <ul>
                            <li>To provide and maintain our legal management services</li>
                            <li>To process payments and manage subscriptions</li>
                            <li>To communicate with you about our services</li>
                            <li>To provide customer support and technical assistance</li>
                            <li>To improve our platform and develop new features</li>
                            <li>To ensure security and prevent unauthorized access</li>
                            <li>To comply with legal obligations and professional standards</li>
                            <li>To send important updates and notifications</li>
                        </ul>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-share-alt"></i> Information Sharing and Disclosure</h2>

                        <h3>Service Providers</h3>
                        <p>We may share your information with third-party service providers who assist us in operating our platform, including:</p>
                        <ul>
                            <li>Cloud hosting and data storage providers</li>
                            <li>Payment processing services</li>
                            <li>Customer support and communication tools</li>
                            <li>Analytics and performance monitoring services</li>
                        </ul>

                        <h3>Legal Requirements</h3>
                        <p>We may disclose your information when required by law or to protect our rights, including:</p>
                        <ul>
                            <li>In response to legal subpoenas or court orders</li>
                            <li>To comply with professional regulatory requirements</li>
                            <li>To protect against fraud or security threats</li>
                            <li>To enforce our Terms of Service</li>
                        </ul>

                        <h3>Business Transfers</h3>
                        <p>In the event of a merger, acquisition, or sale of assets, your information may be transferred to the new entity. We will notify you of any such change in ownership or control.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-lock"></i> Data Security</h2>
                        <p>We implement comprehensive security measures to protect your information:</p>
                        <ul>
                            <li>Encryption of data in transit and at rest</li>
                            <li>Regular security audits and vulnerability assessments</li>
                            <li>Access controls and user authentication</li>
                            <li>Regular backups and disaster recovery procedures</li>
                            <li>Employee training on data protection</li>
                            <li>Multi-factor authentication options</li>
                        </ul>
                        <p>However, no method of transmission over the internet is 100% secure. While we strive to protect your information, we cannot guarantee absolute security.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-user-shield"></i> Attorney-Client Privilege</h2>
                        <p>As a legal management platform, we recognize the importance of attorney-client privilege:</p>
                        <ul>
                            <li>We do not access or review the content of your client communications</li>
                            <li>Your client data remains confidential and protected</li>
                            <li>We maintain strict access controls to prevent unauthorized viewing</li>
                            <li>You remain solely responsible for maintaining privilege in your practice</li>
                            <li>We comply with legal professional privilege requirements</li>
                        </ul>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-database"></i> Data Retention</h2>
                        <p>We retain your information for as long as necessary to provide our services and comply with legal obligations:</p>
                        <ul>
                            <li>Account information is retained while your account is active</li>
                            <li>Client data is retained according to your retention policies</li>
                            <li>Usage data may be retained for analytics and security purposes</li>
                            <li>Deleted data may be retained in backups for a limited time</li>
                            <li>Legal holds may extend retention periods</li>
                        </ul>
                        <p>You may request deletion of your account and associated data at any time.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-globe"></i> International Data Transfers</h2>
                        <p>Our services may involve the transfer of data across international borders. We ensure that such transfers comply with applicable data protection laws and implement appropriate safeguards, including:</p>
                        <ul>
                            <li>Standard contractual clauses approved by regulatory authorities</li>
                            <li>Adequacy decisions where applicable</li>
                            <li>Certification schemes and codes of conduct</li>
                            <li>Binding corporate rules for intra-group transfers</li>
                        </ul>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-cookie-bite"></i> Cookies and Tracking</h2>
                        <p>We use cookies and similar technologies to enhance your experience:</p>
                        <ul>
                            <li>Essential cookies for platform functionality</li>
                            <li>Analytics cookies to understand usage patterns</li>
                            <li>Preference cookies to remember your settings</li>
                            <li>Security cookies to protect against threats</li>
                        </ul>
                        <p>You can control cookie settings through your browser preferences.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-user-edit"></i> Your Rights and Choices</h2>
                        <p>You have certain rights regarding your personal information:</p>
                        <ul>
                            <li><strong>Access:</strong> Request a copy of your personal information</li>
                            <li><strong>Correction:</strong> Update or correct inaccurate information</li>
                            <li><strong>Deletion:</strong> Request deletion of your personal information</li>
                            <li><strong>Portability:</strong> Request transfer of your data</li>
                            <li><strong>Restriction:</strong> Limit processing of your information</li>
                            <li><strong>Objection:</strong> Object to certain processing activities</li>
                        </ul>
                        <p>To exercise these rights, please contact us using the information provided below.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-envelope"></i> Contact Information</h2>
                        <p>For questions about this Privacy Policy or our data practices, please contact us:</p>
                        <div class="contact-info">
                            <p><i class="fas fa-building"></i> <strong>Melsoft Pvt Limited</strong></p>
                            <p><i class="fas fa-map-marker-alt"></i> 25 George Silundika, Regal Star House, 10th Floor</p>
                            <p><i class="fas fa-phone"></i> +263 71 496 6574</p>
                            <p><i class="fas fa-envelope"></i> info@melsoftzim.co.zw</p>
                            <p><i class="fas fa-envelope"></i> Data Protection Officer: dpo@melsoftzim.co.zw</p>
                            <p><i class="fas fa-globe"></i> www.melsoftzim.co.zw</p>
                        </div>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-history"></i> Changes to This Policy</h2>
                        <p>We may update this Privacy Policy from time to time. We will notify you of any material changes through:</p>
                        <ul>
                            <li>Email notification to your registered address</li>
                            <li>Platform notifications within the application</li>
                            <li>Updated effective date on this page</li>
                        </ul>
                        <p>Continued use of our services after changes constitutes acceptance of the updated policy.</p>
                    </section>

                    <div class="acknowledgment">
                        <p><strong><i class="fas fa-info-circle"></i> Acknowledgment:</strong> By using Prolex Legal System, you acknowledge that you have read and understood this Privacy Policy and consent to the collection, use, and sharing of your information as described herein.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>