@extends('layouts.master')

@section('title', 'Lawyer Profile')

@section('page-title', 'Profile')

@section('content')
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background: linear-gradient(135deg, #f0f8ff 0%, #e6f3ff 100%);
        min-height: 100vh;
        padding: 20px;
    }

    .container {
        max-width: 1200px;
        margin: 0 auto;
        background: white;
        border-radius: 12px;
        box-shadow: 0 10px 40px rgba(0,0,0,0.2);
        overflow: hidden;
    }

    .header {
        background: linear-gradient(135deg, #4a90e2 0%, #87ceeb 100%);
        color: white;
        padding: 30px;
        display: flex;
        align-items: center;
        gap: 30px;
        border-bottom: 3px solid #ffffff;
    }

    .profile-picture {
        width: 150px;
        height: 150px;
        border-radius: 50%;
        border: 5px solid #fff;
        object-fit: cover;
        background: #ddd;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 48px;
        color: #666;
    }

    .header-info h1 {
        font-size: 32px;
        margin-bottom: 10px;
    }

    .header-info .title {
        font-size: 18px;
        color: #ffffff;
        margin-bottom: 5px;
    }

    .header-info .bar-number {
        font-size: 14px;
        color: #ffffff;
        opacity: 0.9;
    }

    .status-badge {
        display: inline-block;
        padding: 5px 15px;
        background: #ffffff;
        color: #4a90e2;
        font-weight: 600;
        border-radius: 20px;
        font-size: 14px;
        margin-top: 10px;
        border: 2px solid #ffffff;
    }

    .content {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 30px;
        padding: 30px;
    }

    .section {
        background: #ffffff;
        padding: 25px;
        border-radius: 8px;
        border-left: 4px solid #4a90e2;
        box-shadow: 0 2px 8px rgba(74, 144, 226, 0.1);
    }

    .section.full-width {
        grid-column: 1 / -1;
    }

    .section h2 {
        color: #4a90e2;
        margin-bottom: 20px;
        font-size: 20px;
        display: flex;
        align-items: center;
        gap: 10px;
        border-bottom: 2px solid #e6f3ff;
        padding-bottom: 10px;
    }

    .info-row {
        display: flex;
        justify-content: space-between;
        padding: 12px 0;
        border-bottom: 1px solid #f0f8ff;
    }

    .info-row:last-child {
        border-bottom: none;
    }

    .info-label {
        font-weight: 600;
        color: #495057;
    }

    .info-value {
        color: #212529;
        text-align: right;
    }

    .stats-grid {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 15px;
        margin-top: 15px;
    }

    .stat-card {
        background: #ffffff;
        color: #4a90e2;
        padding: 20px;
        border-radius: 8px;
        text-align: center;
        box-shadow: 0 2px 8px rgba(74, 144, 226, 0.15);
        border: 2px solid #e6f3ff;
    }

    .stat-number {
        font-size: 32px;
        font-weight: bold;
        color: #4a90e2;
        display: block;
    }

    .stat-label {
        font-size: 14px;
        color: #6c757d;
        margin-top: 5px;
    }

    .specialization-tags {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin-top: 15px;
    }

    .tag {
        background: #ffffff;
        color: #4a90e2;
        padding: 8px 16px;
        border-radius: 20px;
        font-size: 14px;
        border: 2px solid #4a90e2;
    }

    .case-item {
        background: #ffffff;
        padding: 15px;
        border-radius: 6px;
        margin-bottom: 10px;
        border-left: 3px solid #4a90e2;
        box-shadow: 0 1px 3px rgba(74, 144, 226, 0.1);
    }

    .case-title {
        font-weight: 600;
        color: #212529;
        margin-bottom: 5px;
    }

    .case-meta {
        font-size: 14px;
        color: #6c757d;
    }

    .btn {
        background: #4a90e2;
        color: white;
        padding: 12px 24px;
        border: 2px solid #4a90e2;
        border-radius: 6px;
        cursor: pointer;
        font-size: 16px;
        margin-right: 10px;
        margin-top: 10px;
        transition: all 0.3s ease;
    }

    .btn:hover {
        background: #ffffff;
        color: #4a90e2;
    }

    .btn-secondary {
        background: #ffffff;
        color: #4a90e2;
        border: 2px solid #4a90e2;
    }

    .btn-secondary:hover {
        background: #4a90e2;
        color: #ffffff;
    }

    .education-item, .certification-item {
        background: #ffffff;
        padding: 15px;
        border-radius: 6px;
        margin-bottom: 10px;
        border-left: 2px solid #4a90e2;
        box-shadow: 0 1px 3px rgba(74, 144, 226, 0.1);
    }

    .education-degree {
        font-weight: 600;
        color: #212529;
    }

    .education-institution {
        color: #4a90e2;
        font-size: 14px;
        font-weight: 500;
    }

    .education-year {
        color: #6c757d;
        font-size: 14px;
    }

    @media (max-width: 768px) {
        .content {
            grid-template-columns: 1fr;
        }

        .header {
            flex-direction: column;
            text-align: center;
        }

        .stats-grid {
            grid-template-columns: repeat(2, 1fr);
        }
    }
</style>

<div class="container">
    <div class="header">
        <div class="profile-picture">
            @if($user->profile_picture)
                <img src="{{ asset('storage/' . $user->profile_picture) }}" alt="Profile Picture" style="width: 100%; height: 100%; border-radius: 50%; object-fit: cover;">
            @else
                👨‍⚖️
            @endif
        </div>
        <div class="header-info">
            <h1>{{ $user->name }}</h1>
            <div class="title">{{ $userRole }} | {{ $userGroup }}</div>
            <div class="bar-number">Employee ID: {{ $user->id ?? 'N/A' }} | Joined: {{ $user->created_at ? $user->created_at->format('M d, Y') : 'N/A' }}</div>
            <span class="status-badge">Active</span>
        </div>
    </div>

    <div class="content">
        <div class="section full-width">
            <h2>📊 Performance Statistics</h2>
            <div class="stats-grid">
                <div class="stat-card">
                    <span class="stat-number">--</span>
                    <div class="stat-label">Total Cases</div>
                </div>
                <div class="stat-card">
                    <span class="stat-number">--</span>
                    <div class="stat-label">Cases Won</div>
                </div>
                <div class="stat-card">
                    <span class="stat-number">--</span>
                    <div class="stat-label">Active Cases</div>
                </div>
                <div class="stat-card">
                    <span class="stat-number">--%</span>
                    <div class="stat-label">Client Satisfaction</div>
                </div>
            </div>
        </div>

        <div class="section">
            <h2>👤 Personal Information</h2>
            <div class="info-row">
                <span class="info-label">Employee ID:</span>
                <span class="info-value">{{ $user->id ?? 'N/A' }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Email:</span>
                <span class="info-value">{{ $user->email }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Phone:</span>
                <span class="info-value">{{ $userPhones->isNotEmpty() ? $userPhones->first()->phone_number : 'N/A' }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Role:</span>
                <span class="info-value">{{ $userRole }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Group:</span>
                <span class="info-value">{{ $userGroup }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Tier:</span>
                <span class="info-value">{{ $userTier }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Location:</span>
                <span class="info-value">{{ $user->location ?? 'N/A' }}</span>
            </div>
        </div>

        <div class="section">
            <h2>⚖️ Professional Details</h2>
            <div class="info-row">
                <span class="info-label">Department:</span>
                <span class="info-value">{{ $userGroup }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Joined Firm:</span>
                <span class="info-value">{{ $user->created_at ? $user->created_at->format('M d, Y') : 'N/A' }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">Office:</span>
                <span class="info-value">Suite --, --th Floor</span>
            </div>
        </div>

        <div class="section full-width">
            <h2>🎯 Practice Areas & Specializations</h2>
            <div class="specialization-tags">
                <span class="tag">General Law</span>
                <span class="tag">{{ $userGroup }}</span>
            </div>
        </div>

        <div class="section">
            <h2>🎓 Education</h2>
            <div class="education-item">
                <div class="education-degree">Degree in Law</div>
                <div class="education-institution">University</div>
                <div class="education-year">Year - Year</div>
            </div>
        </div>

        <div class="section">
            <h2>📜 Certifications & Honors</h2>
            <div class="certification-item">
                <div class="education-degree">Certified {{ $userRole }}</div>
                <div class="education-year">Year</div>
            </div>
        </div>

        <div class="section full-width">
            <h2>📁 Recent Cases</h2>
            <div class="case-item">
                <div class="case-title">Case #--</div>
                <div class="case-meta">Type: {{ $userGroup }} | Status: Active | Client: N/A</div>
            </div>
        </div>

        <div class="section">
            <h2>💼 Billable Hours</h2>
            <div class="info-row">
                <span class="info-label">This Month:</span>
                <span class="info-value">-- hours</span>
            </div>
            <div class="info-row">
                <span class="info-label">This Year:</span>
                <span class="info-value">-- hours</span>
            </div>
            <div class="info-row">
                <span class="info-label">Annual Target:</span>
                <span class="info-value">-- hours</span>
            </div>
            <div class="info-row">
                <span class="info-label">Hourly Rate:</span>
                <span class="info-value">$--/hour</span>
            </div>
        </div>

        <div class="section">
            <h2>📞 Availability</h2>
            <div class="info-row">
                <span class="info-label">Office Hours:</span>
                <span class="info-value">Mon-Fri 9AM-6PM</span>
            </div>
            <div class="info-row">
                <span class="info-label">Next Available:</span>
                <span class="info-value">Tomorrow at --:-- PM</span>
            </div>
        </div>

        <div class="section full-width">
            <h2>🔐 Security Settings</h2>
            <div class="info-row">
                <span class="info-label">Two-Factor Authentication:</span>
                <span class="info-value">Enabled</span>
            </div>
            <div class="info-row">
                <span class="info-label">SMS Verification:</span>
                <span class="info-value">Enabled</span>
            </div>
            <button class="btn" onclick="setup2FA()">Setup 2FA</button>
            <button class="btn btn-secondary" onclick="disable2FA()">Disable 2FA</button>
            <button class="btn btn-secondary" onclick="disableSMS()">Disable SMS</button>
        </div>

        <div class="section full-width">
            <h2>🔑 Change Password</h2>
            <form id="passwordForm" onsubmit="return changePassword()">
                <div style="margin-bottom: 10px;">
                    <label>Current Password:</label><br>
                    <input type="password" id="currentPass" required style="width: 100%; padding:8px; border: 1px solid #ccc; border-radius: 4px;"/>
                </div>
                <div style="margin-bottom: 10px;">
                    <label>New Password:</label><br>
                    <input type="password" id="newPass" required style="width: 100%; padding:8px; border: 1px solid #ccc; border-radius: 4px;"/>
                </div>
                <div style="margin-bottom: 10px;">
                    <label>Confirm New Password:</label><br>
                    <input type="password" id="confirmPass" required style="width: 100%; padding:8px; border: 1px solid #ccc; border-radius: 4px;"/>
                </div>
                <button class="btn" type="submit">Change Password</button>
            </form>
        </div>

        <div class="section full-width">
            <h2>⚙️ Actions</h2>
            <button class="btn" onclick="editProfile()">Edit Profile</button>
            <button class="btn" onclick="alert('View all cases')">View All Cases</button>
            <button class="btn" onclick="alert('Schedule meeting')">Schedule Meeting</button>
            <button class="btn btn-secondary" onclick="alert('Generate report')">Generate Report</button>
            <button class="btn btn-secondary" onclick="alert('View calendar')">View Calendar</button>
        </div>
    </div>
</div>

<script>
    function editProfile() {
        alert('Edit profile clicked. Implement editing functionality.');
    }

    function setup2FA() {
        alert('Setup Two-Factor Authentication.');
    }

    function disable2FA() {
        alert('Two-Factor Authentication disabled.');
    }

    function disableSMS() {
        alert('SMS Verification disabled.');
    }

    function changePassword() {
        const current = document.getElementById('currentPass').value;
        const newP = document.getElementById('newPass').value;
        const confirm = document.getElementById('confirmPass').value;

        if(newP !== confirm){
            alert('New passwords do not match!');
            return false;
        }
        alert('Password changed successfully!');
        // Reset form
        document.getElementById('passwordForm').reset();
        return false; // prevent actual form submission
    }

    // Add interactivity
    document.querySelectorAll('.case-item').forEach(item => {
        item.addEventListener('click', function() {
            this.style.backgroundColor = '#e3f2fd';
            setTimeout(() => {
                this.style.backgroundColor = 'white';
            }, 300);
        });
    });

    // Simulate real-time updates
    function updateOnlineStatus() {
        const badge = document.querySelector('.status-badge');
        const statuses = ['Active', 'In Meeting', 'Available'];
        let currentIndex = 0;

        setInterval(() => {
            currentIndex = (currentIndex + 1) % statuses.length;
            badge.textContent = statuses[currentIndex];
        }, 5000);
    }

    updateOnlineStatus();
</script>
@endsection

