<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Tax Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
        }
        .header p {
            margin: 5px 0;
        }
        .section-title {
            font-size: 14px;
            font-weight: bold;
            margin: 20px 0 10px 0;
            background-color: #f0f0f0;
            padding: 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            border: 1px solid #000;
            padding: 5px;
            text-align: left;
        }
        th {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        .text-right {
            text-align: right;
        }
        .total-row {
            font-weight: bold;
            background-color: #e0e0e0;
        }
        .net-row {
            font-weight: bold;
            background-color: #d0d0d0;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Tax Statement</h1>
        <p>Date: {{ date('F j, Y') }}</p>
        <p>Currency: {{ $currnames }}</p>
        <p>Period: {{ $from }} to {{ $to }}</p>
    </div>

    <!-- Output Tax Section -->
    <div class="section-title">Output Tax [Tenants]</div>
    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Name</th>
                <th>Inv No</th>
                <th>Inv Amount({{ $currnames }})</th>
                <th>Tax%</th>
                <th>Tax Amount({{ $currnames }})</th>
                <th>Total(incl)</th>
            </tr>
        </thead>
        <tbody>
            @forelse($outputTransactions as $transaction)
                @foreach($transaction->lines as $line)
                    @php
                        $invoiceAmount = $line->price * $line->quantity;
                        $taxAmount = $invoiceAmount * ($line->tax_rate / 100);
                        $amountIncl = $invoiceAmount + $taxAmount;
                    @endphp
                    <tr>
                        <td>{{ $transaction->document_date }}</td>
                        <td>{{ $transaction->customer->customer_account ?? 'N/A' }}</td>
                        <td>{{ $transaction->document_number }}</td>
                        <td class="text-right">{{ number_format($invoiceAmount, 2) }}</td>
                        <td class="text-right">{{ $line->tax_rate }}</td>
                        <td class="text-right">{{ number_format($taxAmount, 2) }}</td>
                        <td class="text-right">{{ number_format($amountIncl, 2) }}</td>
                    </tr>
                @endforeach
            @empty
                <tr>
                    <td colspan="7" style="text-align: center;">No output tax transactions found</td>
                </tr>
            @endforelse
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="3">Total Output Tax</td>
                <td class="text-right">{{ number_format($outputTotals['invoice'], 2) }}</td>
                <td></td>
                <td class="text-right">{{ number_format($outputTotals['tax'], 2) }}</td>
                <td class="text-right">{{ number_format($outputTotals['incl'], 2) }}</td>
            </tr>
        </tfoot>
    </table>

    <!-- Input Tax Section -->
    <div class="section-title">Input Tax [Suppliers]</div>
    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Name</th>
                <th>Inv No</th>
                <th>Inv Amount({{ $currnames }})</th>
                <th>Tax%</th>
                <th>Tax Amount({{ $currnames }})</th>
                <th>Total(incl)</th>
            </tr>
        </thead>
        <tbody>
            @forelse($inputTransactions as $transaction)
                @foreach($transaction->lines as $line)
                    @php
                        $invoiceAmount = $line->price * $line->quantity;
                        $taxAmount = $invoiceAmount * ($line->tax_rate / 100);
                        $amountIncl = $invoiceAmount + $taxAmount;
                    @endphp
                    <tr>
                        <td>{{ $transaction->document_date }}</td>
                        <td>{{ $transaction->supplier->supplier_account ?? 'N/A' }}</td>
                        <td>{{ $transaction->document_number }}</td>
                        <td class="text-right">{{ number_format($invoiceAmount, 2) }}</td>
                        <td class="text-right">{{ $line->tax_rate }}</td>
                        <td class="text-right">{{ number_format($taxAmount, 2) }}</td>
                        <td class="text-right">{{ number_format($amountIncl, 2) }}</td>
                    </tr>
                @endforeach
            @empty
                <tr>
                    <td colspan="7" style="text-align: center;">No input tax transactions found</td>
                </tr>
            @endforelse
        </tbody>
        <tfoot>
            <tr class="total-row">
                <td colspan="3">Total Input Tax</td>
                <td class="text-right">{{ number_format($inputTotals['invoice'], 2) }}</td>
                <td></td>
                <td class="text-right">{{ number_format($inputTotals['tax'], 2) }}</td>
                <td class="text-right">{{ number_format($inputTotals['incl'], 2) }}</td>
            </tr>
            <tr class="net-row">
                <td colspan="3">Net Tax</td>
                <td class="text-right">{{ number_format($outputTotals['invoice'] - $inputTotals['invoice'], 2) }}</td>
                <td></td>
                <td class="text-right">{{ number_format($outputTotals['tax'] - $inputTotals['tax'], 2) }}</td>
                <td class="text-right">{{ number_format($outputTotals['incl'] - $inputTotals['incl'], 2) }}</td>
            </tr>
        </tfoot>
    </table>
</body>
</html>
