<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Terms and Conditions - Prolex Legal System</title>
    <link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --primary-color: #87CEEB;
            --secondary-color: #2c3e50;
            --accent-color: #e74c3c;
            --success-color: #27ae60;
            --light-bg: #f8f9fa;
            --dark-text: #2c3e50;
            --light-text: #7f8c8d;
            --border-color: #e0e6ed;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--light-bg);
            color: var(--dark-text);
            line-height: 1.6;
        }

        .legal-document-container {
            min-height: 100vh;
        }

        .legal-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, #b0c4de 100%);
            padding: 3rem 0;
            color: #1a1a1a;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }

        .container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 0 2rem;
        }

        .back-link {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            color: #1a1a1a;
            text-decoration: none;
            font-weight: 500;
            margin-bottom: 1.5rem;
            transition: all 0.3s ease;
        }

        .back-link:hover {
            transform: translateX(-5px);
            color: #000;
        }

        .legal-title {
            font-family: 'Cinzel', serif;
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            text-shadow: 2px 2px 4px rgba(255,255,255,0.3);
        }

        .legal-subtitle {
            font-size: 1.1rem;
            opacity: 0.8;
        }

        .legal-content {
            padding: 4rem 0;
        }

        .legal-card {
            background: white;
            border-radius: 16px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.08);
            padding: 3rem;
            margin-bottom: 2rem;
        }

        .legal-section {
            margin-bottom: 3rem;
        }

        .legal-section:last-child {
            margin-bottom: 0;
        }

        .legal-section h2 {
            font-size: 1.8rem;
            color: var(--secondary-color);
            margin-bottom: 1.5rem;
            padding-bottom: 0.75rem;
            border-bottom: 2px solid var(--primary-color);
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .legal-section h2 i {
            color: var(--primary-color);
        }

        .legal-section h3 {
            font-size: 1.3rem;
            color: var(--secondary-color);
            margin: 1.5rem 0 1rem 0;
        }

        .legal-section p {
            margin-bottom: 1rem;
            font-size: 1rem;
            line-height: 1.8;
        }

        .legal-section ul {
            margin: 1rem 0 1.5rem 1.5rem;
            list-style-type: none;
        }

        .legal-section ul li {
            margin-bottom: 0.75rem;
            padding-left: 1.5rem;
            position: relative;
            line-height: 1.7;
        }

        .legal-section ul li::before {
            content: "▸";
            position: absolute;
            left: 0;
            color: var(--primary-color);
            font-weight: bold;
        }

        .legal-section ul li strong {
            color: var(--secondary-color);
        }

        .contact-info {
            background: var(--light-bg);
            padding: 1.5rem;
            border-radius: 10px;
            border-left: 4px solid var(--primary-color);
            margin-top: 1rem;
        }

        .contact-info p {
            margin-bottom: 0.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .contact-info i {
            color: var(--primary-color);
            width: 20px;
        }

        .acknowledgment {
            background: linear-gradient(135deg, #fff3cd, #ffeaa7);
            padding: 1.5rem;
            border-radius: 10px;
            border-left: 4px solid #f39c12;
            margin-top: 2rem;
        }

        .acknowledgment p {
            margin: 0;
            color: var(--secondary-color);
        }

        @media (max-width: 768px) {
            .legal-title {
                font-size: 2rem;
            }

            .legal-card {
                padding: 2rem 1.5rem;
            }

            .legal-section h2 {
                font-size: 1.5rem;
            }

            .container {
                padding: 0 1rem;
            }
        }
    </style>
</head>
<body>
    <div class="legal-document-container">
        <div class="legal-header">
            <div class="container">
                <a href="#" class="back-link" onclick="window.history.back(); return false;">
                    <i class="fas fa-arrow-left"></i> Back to Login
                </a>
                <h1 class="legal-title">Terms and Conditions</h1>
                <p class="legal-subtitle">Last Updated: December 31, 2025</p>
            </div>
        </div>

        <div class="legal-content">
            <div class="container">
                <div class="legal-card">
                    <section class="legal-section">
                        <h2><i class="fas fa-file-contract"></i> Agreement to Terms</h2>
                        <p>Welcome to Prolex Legal System. These Terms and Conditions ("Terms") constitute a legally binding agreement between you ("User," "you," or "your") and Prolex Legal System ("Company," "we," "us," or "our") regarding your access to and use of our law firm management platform.</p>
                        <p>By accessing or using Prolex Legal System, you acknowledge that you have read, understood, and agree to be bound by these Terms. If you do not agree to these Terms, you must not access or use our services.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-user-circle"></i> Eligibility and Account Registration</h2>

                        <h3>Eligibility Requirements</h3>
                        <p>To use Prolex Legal System, you must:</p>
                        <ul>
                            <li>Be at least 18 years of age</li>
                            <li>Be a licensed legal professional or authorized employee of a law firm</li>
                            <li>Have the legal capacity to enter into binding contracts</li>
                            <li>Not be prohibited from using our services under applicable laws</li>
                        </ul>

                        <h3>Account Creation</h3>
                        <p>When creating an account, you agree to:</p>
                        <ul>
                            <li>Provide accurate, current, and complete information</li>
                            <li>Maintain and promptly update your account information</li>
                            <li>Maintain the security and confidentiality of your login credentials</li>
                            <li>Accept responsibility for all activities under your account</li>
                            <li>Notify us immediately of any unauthorized access or security breach</li>
                        </ul>

                        <h3>Account Responsibility</h3>
                        <p>You are solely responsible for all activities that occur under your account. You agree not to share your account credentials with any third party. We reserve the right to suspend or terminate accounts that violate these Terms.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-check-circle"></i> Acceptable Use Policy</h2>
                        <p>You agree to use Prolex Legal System only for lawful purposes and in accordance with these Terms. You agree NOT to:</p>
                        <ul>
                            <li>Violate any applicable laws, regulations, or professional conduct rules</li>
                            <li>Infringe upon the intellectual property rights of others</li>
                            <li>Upload or transmit viruses, malware, or other malicious code</li>
                            <li>Attempt to gain unauthorized access to our systems or other users' accounts</li>
                            <li>Interfere with or disrupt the operation of our services</li>
                            <li>Use automated systems (bots, scrapers) without authorization</li>
                            <li>Engage in any fraudulent, abusive, or harassing behavior</li>
                            <li>Reverse engineer, decompile, or disassemble our software</li>
                            <li>Remove or modify any proprietary notices or labels</li>
                            <li>Use the platform to store or distribute illegal content</li>
                            <li>Resell or sublicense access to our services without permission</li>
                        </ul>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-shield-alt"></i> Professional Responsibility</h2>
                        <p>As a legal management platform, you acknowledge that:</p>
                        <ul>
                            <li>You remain solely responsible for maintaining attorney-client privilege and confidentiality</li>
                            <li>You must comply with all professional ethics rules and regulations governing your practice</li>
                            <li>You are responsible for the accuracy and legality of all content you upload or create</li>
                            <li>We do not provide legal advice and are not responsible for your professional conduct</li>
                            <li>You must obtain proper consent and authorization before entering client information</li>
                            <li>You are responsible for meeting all legal deadlines and obligations</li>
                        </ul>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-copyright"></i> Intellectual Property Rights</h2>

                        <h3>Our Intellectual Property</h3>
                        <p>Prolex Legal System, including all software, features, content, trademarks, and logos, is owned by us and protected by intellectual property laws. You are granted a limited, non-exclusive, non-transferable license to use our services in accordance with these Terms.</p>

                        <h3>Your Content</h3>
                        <p>You retain all ownership rights to the content you upload to Prolex Legal System. By uploading content, you grant us a limited license to:</p>
                        <ul>
                            <li>Store, process, and display your content to provide our services</li>
                            <li>Create backups and ensure data redundancy</li>
                            <li>Perform technical operations necessary for service delivery</li>
                        </ul>
                        <p>We do not claim ownership of your content and will not use it for purposes beyond providing our services.</p>

                        <h3>Feedback</h3>
                        <p>If you provide feedback, suggestions, or ideas about our services, you grant us a perpetual, worldwide, royalty-free license to use and incorporate such feedback without compensation or attribution.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-dollar-sign"></i> Payment and Subscription Terms</h2>

                        <h3>Subscription Plans</h3>
                        <p>Prolex Legal System offers various subscription plans with different features and pricing. You agree to pay all fees associated with your chosen plan.</p>

                        <h3>Billing</h3>
                        <ul>
                            <li>Subscription fees are billed in advance on a recurring basis (monthly or annually)</li>
                            <li>You authorize us to charge your payment method on each billing cycle</li>
                            <li>All fees are non-refundable unless otherwise stated or required by law</li>
                            <li>We reserve the right to change our pricing with 30 days' notice</li>
                            <li>Failure to pay may result in suspension or termination of your account</li>
                        </ul>

                        <h3>Cancellation</h3>
                        <p>You may cancel your subscription at any time through your account settings. Cancellation will take effect at the end of your current billing period. You will retain access to paid features until that date.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-lock"></i> Data Security and Privacy</h2>
                        <p>We take data security seriously and implement industry-standard measures to protect your information. However, you acknowledge that:</p>
                        <ul>
                            <li>No system is completely secure, and we cannot guarantee absolute security</li>
                            <li>You are responsible for maintaining the confidentiality of your login credentials</li>
                            <li>You should review our Privacy Policy for detailed information about data handling</li>
                            <li>You must comply with all applicable data protection laws when using our services</li>
                            <li>You are responsible for backing up your critical data</li>
                        </ul>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-exclamation-triangle"></i> Disclaimers and Limitations of Liability</h2>

                        <h3>Service Availability</h3>
                        <p>We strive to provide reliable service but do not guarantee uninterrupted or error-free operation. We reserve the right to modify, suspend, or discontinue any aspect of our services at any time.</p>

                        <h3>Disclaimer of Warranties</h3>
                        <p>PROLEX LEGAL SYSTEM IS PROVIDED "AS IS" AND "AS AVAILABLE" WITHOUT WARRANTIES OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.</p>

                        <h3>Limitation of Liability</h3>
                        <p>TO THE MAXIMUM EXTENT PERMITTED BY LAW, PROLEX LEGAL SYSTEM SHALL NOT BE LIABLE FOR ANY INDIRECT, INCIDENTAL, SPECIAL, CONSEQUENTIAL, OR PUNITIVE DAMAGES, OR ANY LOSS OF PROFITS, REVENUE, DATA, OR USE, ARISING FROM YOUR USE OF OUR SERVICES.</p>
                        <p>OUR TOTAL LIABILITY SHALL NOT EXCEED THE AMOUNT YOU PAID US IN THE 12 MONTHS PRECEDING THE CLAIM.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-user-shield"></i> Indemnification</h2>
                        <p>You agree to indemnify, defend, and hold harmless Prolex Legal System, its affiliates, officers, directors, employees, and agents from any claims, liabilities, damages, losses, costs, or expenses (including reasonable attorneys' fees) arising from:</p>
                        <ul>
                            <li>Your violation of these Terms</li>
                            <li>Your violation of any law or regulation</li>
                            <li>Your violation of any third-party rights</li>
                            <li>Your use or misuse of our services</li>
                            <li>Content you upload or create using our platform</li>
                        </ul>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-ban"></i> Termination</h2>

                        <h3>Termination by You</h3>
                        <p>You may terminate your account at any time by following the cancellation process in your account settings or by contacting our support team.</p>

                        <h3>Termination by Us</h3>
                        <p>We reserve the right to suspend or terminate your access to Prolex Legal System at any time, with or without notice, for:</p>
                        <ul>
                            <li>Violation of these Terms</li>
                            <li>Fraudulent or illegal activity</li>
                            <li>Non-payment of fees</li>
                            <li>Conduct that may harm our reputation or other users</li>
                            <li>Any reason at our sole discretion</li>
                        </ul>

                        <h3>Effect of Termination</h3>
                        <p>Upon termination, your right to use our services will immediately cease. You will have 30 days to export your data before it is permanently deleted. We are not liable for any loss of data following termination.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-balance-scale"></i> Dispute Resolution</h2>

                        <h3>Governing Law</h3>
                        <p>These Terms shall be governed by and construed in accordance with the laws of [Your Jurisdiction], without regard to its conflict of law provisions.</p>

                        <h3>Arbitration</h3>
                        <p>Any disputes arising from these Terms or your use of our services shall be resolved through binding arbitration in accordance with the rules of [Arbitration Association]. You waive your right to participate in class action lawsuits.</p>

                        <h3>Exceptions</h3>
                        <p>Either party may seek injunctive relief in court for intellectual property infringement or confidentiality violations.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-edit"></i> Changes to Terms</h2>
                        <p>We reserve the right to modify these Terms at any time. We will notify you of material changes by:</p>
                        <ul>
                            <li>Posting the updated Terms on our website</li>
                            <li>Sending an email to your registered email address</li>
                            <li>Displaying a prominent notice in the application</li>
                        </ul>
                        <p>Your continued use of Prolex Legal System after changes take effect constitutes acceptance of the modified Terms. If you do not agree to the changes, you must stop using our services.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-file-alt"></i> General Provisions</h2>

                        <h3>Entire Agreement</h3>
                        <p>These Terms, together with our Privacy Policy, constitute the entire agreement between you and Prolex Legal System regarding your use of our services.</p>

                        <h3>Severability</h3>
                        <p>If any provision of these Terms is found to be unenforceable, the remaining provisions will remain in full force and effect.</p>

                        <h3>Waiver</h3>
                        <p>Our failure to enforce any right or provision of these Terms shall not constitute a waiver of such right or provision.</p>

                        <h3>Assignment</h3>
                        <p>You may not assign or transfer these Terms without our written consent. We may assign our rights and obligations without restriction.</p>

                        <h3>Force Majeure</h3>
                        <p>We shall not be liable for any failure or delay in performance due to circumstances beyond our reasonable control.</p>
                    </section>

                    <section class="legal-section">
                        <h2><i class="fas fa-envelope"></i> Contact Information</h2>
                        <p>If you have any questions, concerns, or complaints regarding these Terms, please contact us:</p>
                        
                        <div class="contact-info">
                            <p><i class="fas fa-building"></i> <strong>Melsoft Pvt Limited</strong></p>
                            <p><i class="fas fa-map-marker-alt"></i> 25 George Silundika, Regal Star House, 10th Floor</p>
                            <p><i class="fas fa-phone"></i> +263 71 496 6574</p>
                            <p><i class="fas fa-envelope"></i> info@melsoftzim.co.zw</p>
                            <p><i class="fas fa-globe"></i> www.melsoftzim.co.zw</p>
                            <p><i class="fas fa-clock"></i> Business Hours: Monday - Friday, 8:00 AM - 5:00 PM CAT</p>
                        </div>
                    </section>

                    <div class="acknowledgment">
                        <p><strong><i class="fas fa-info-circle"></i> Acknowledgment:</strong> By using Prolex Legal System, you acknowledge that you have read these Terms and Conditions, understand them, and agree to be bound by them. These Terms constitute a legal agreement between you and Prolex Legal System.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>