<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ModuleController;

// Task Management Routes
Route::prefix('modules/processing')->group(function () {
    // Diary Routes
    Route::get('/diary/list', [ModuleController::class, 'diaryList'])->name('modules.processing.diary.list');
    Route::get('/diary/add', [ModuleController::class, 'diaryAdd'])->name('modules.processing.diary.add');
    Route::post('/diary/store', [ModuleController::class, 'diaryStore'])->name('modules.processing.diary.store');
    Route::get('/diary/{id}', [ModuleController::class, 'diaryShow'])->name('modules.processing.diary.show');
    Route::get('/diary/{id}/edit', [ModuleController::class, 'diaryEdit'])->name('modules.processing.diary.edit');
    Route::put('/diary/{id}', [ModuleController::class, 'diaryUpdate'])->name('modules.processing.diary.update');
    Route::delete('/diary/{id}', [ModuleController::class, 'diaryDelete'])->name('modules.processing.diary.delete');
    Route::get('/diary/calendar', [ModuleController::class, 'diaryCalendar'])->name('modules.processing.diary.calendar');

    // Assignment Routes
    Route::get('/assignment/list', [ModuleController::class, 'assignmentList'])->name('modules.processing.assignment.list');
    Route::get('/assignment/add', [ModuleController::class, 'assignmentAdd'])->name('modules.processing.assignment.add');
    Route::post('/assignment/store', [ModuleController::class, 'assignmentStore'])->name('modules.processing.assignment.store');
    Route::get('/assignment/{id}', [ModuleController::class, 'assignmentShow'])->name('modules.processing.assignment.show');
    Route::get('/assignment/{id}/edit', [ModuleController::class, 'assignmentEdit'])->name('modules.processing.assignment.edit');
    Route::put('/assignment/{id}', [ModuleController::class, 'assignmentUpdate'])->name('modules.processing.assignment.update');
    Route::delete('/assignment/{id}', [ModuleController::class, 'assignmentDelete'])->name('modules.processing.assignment.delete');
    Route::post('/assignment/{id}/reassign', [ModuleController::class, 'reassignAssignment'])->name('modules.processing.assignment.reassign');
    Route::get('/assignment/collaboration', [ModuleController::class, 'assignmentCollaboration'])->name('modules.processing.assignment.collaboration');
    Route::get('/assignment-reports', [ModuleController::class, 'assignmentReports'])->name('modules.processing.assignment.reports');
    Route::get('/assignment-reports/export/{format}', [ModuleController::class, 'exportAssignmentReports'])->name('modules.processing.assignment.reports.export');
});
