                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      <?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LedgerController;
use App\Http\Controllers\AccountTypeController;
use App\Http\Controllers\DepartmentController;

use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ModuleController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ClientController;

use App\Http\Controllers\AgeingAnalysisController;
use App\Http\Controllers\LawyerController;
use App\Http\Controllers\CaseController;
use App\Http\Controllers\TaxController;
use App\Http\Controllers\CaseTypeController;
use App\Http\Controllers\CaseReasonController;
use App\Http\Controllers\CaseCategoryController;
use App\Http\Controllers\CaseOutcomeController;
use App\Http\Controllers\CasePriorityController;
use App\Http\Controllers\CaseRoleController;

use App\Http\Controllers\AdministrationController;
use App\Http\Controllers\LawyerStatementController;
use App\Http\Controllers\OutstandingFeesController;
use App\Http\Controllers\TotalFeesController;
use App\Http\Controllers\FeeCollectionController;
use App\Http\Controllers\ClientStatementController;
use App\Http\Controllers\HelpController;


// Dashboard

Route::middleware('web')->group(function () {
    // Guest routes - only accessible to unauthenticated users
    Route::middleware('guest')->group(function () {
        Route::get('/', [AuthController::class, 'showLogin'])->name('home');
        Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
        Route::post('/login', [AuthController::class, 'login']);

        // Password Reset Routes
        Route::get('/forgot-password', [App\Http\Controllers\Auth\ForgotPasswordController::class, 'showForgotPasswordForm'])->name('password.request');
        Route::post('/forgot-password', [App\Http\Controllers\Auth\ForgotPasswordController::class, 'sendOtp'])->name('password.email');
        Route::get('/verify-otp', [App\Http\Controllers\Auth\ForgotPasswordController::class, 'showVerifyOtpForm'])->name('password.verify');
        Route::post('/verify-otp', [App\Http\Controllers\Auth\ForgotPasswordController::class, 'verifyOtp'])->name('password.verify.post');
        Route::get('/reset-password', [App\Http\Controllers\Auth\ForgotPasswordController::class, 'showResetPasswordForm'])->name('password.reset');
        Route::post('/reset-password', [App\Http\Controllers\Auth\ForgotPasswordController::class, 'resetPassword'])->name('password.update');

        // Privacy Policy Route
        Route::get('/privacy', function () {
            return view('privacypolicy');
        })->name('privacy');

        // Terms and Conditions Route
        Route::get('/terms', function () {
            return view('terms');
        })->name('terms');
    });

    // Authentication routes - accessible to all
    Route::get('/logout', [AuthController::class, 'logout'])->name('logout');
    Route::post('/logout-all-devices', [AuthController::class, 'logoutAllDevices'])->name('logout.all');

    // Protected routes - require authentication
    Route::middleware('auth')->group(function () {
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

        // Debug route for session testing
        Route::get('/_dev/session-test', function () {
            session(['foo' => 'bar']);
            return session('foo');
        });

        // Chat routes
    Route::get('/chat/passcode', [App\Http\Controllers\PasscodeController::class, 'show'])->name('chat.passcode');
    Route::post('/chat/passcode', [App\Http\Controllers\PasscodeController::class, 'verify'])->name('chat.passcode.verify');
    Route::get('/chat/loading', [App\Http\Controllers\ChatController::class, 'loading'])->name('chat.loading');
    Route::get('/chat/room', [App\Http\Controllers\ChatController::class, 'room'])->name('chat.room');
    Route::get('/chat/options', [App\Http\Controllers\ChatController::class, 'options'])->name('chat.options');

    // Proly routes
    Route::get('/proly', [App\Http\Controllers\ProlyController::class, 'index'])->name('proly.index');
    Route::post('/proly/chat', [App\Http\Controllers\ProlyController::class, 'chat'])->name('proly.chat');

    Route::get('/profile', [DashboardController::class, 'profile'])->name('profile');
    Route::get('/help', [HelpController::class, 'index'])->name('help');

    // Module routes
    Route::prefix('modules')->group(function () {
    Route::get('/edit', [ModuleController::class, 'edit'])->name('modules.edit');
    Route::get('/edit/general-ledger', [ModuleController::class, 'chartOfAccounts'])->name('modules.edit.general-ledger');
    Route::get('/edit/chart-of-accounts', [ModuleController::class, 'chartOfAccountsOptions'])->name('modules.edit.chart-of-accounts');
    Route::get('/edit/chart-of-accounts/general-ledger', [ModuleController::class, 'chartOfAccounts'])->name('modules.edit.chart-of-accounts.general-ledger');
    Route::get('/edit/chart-of-accounts/account-types', [ModuleController::class, 'accountTypes'])->name('modules.edit.chart-of-accounts.account-types');
    Route::get('/edit/chart-of-accounts/departments', [DepartmentController::class, 'index'])->name('modules.edit.chart-of-accounts.departments');
    Route::get('/edit/chart-of-accounts/cashbooks', [ModuleController::class, 'cashbooks'])->name('modules.edit.chart-of-accounts.cashbooks');
    Route::post('/edit/chart-of-accounts/cashbooks', [ModuleController::class, 'storeCashbook'])->name('cashbook.entry.store');
    Route::get('/edit/chart-of-accounts/cashbooks/{id}/edit', [ModuleController::class, 'editCashbook'])->name('cashbook.edit');
    Route::put('/edit/chart-of-accounts/cashbooks/{id}', [ModuleController::class, 'updateCashbook'])->name('cashbook.update');
    Route::delete('/edit/chart-of-accounts/cashbooks/{id}', [ModuleController::class, 'destroyCashbook'])->name('cashbook.destroy');
    Route::get('/edit/account-types', [ModuleController::class, 'accountTypes'])->name('modules.edit.account-types');
    Route::get('/edit/multi-currency', [ModuleController::class, 'multiCurrency'])->name('modules.edit.multi-currency');
    Route::get('/edit/multi-currency/add-currency', [ModuleController::class, 'multiCurrency'])->name('modules.edit.multi-currency.add-currency');
    Route::get('/edit/multi-currency/home-currency', [ModuleController::class, 'multiCurrency'])->name('modules.edit.multi-currency.home-currency');
    Route::get('/edit/multi-currency/daily-rates', [ModuleController::class, 'multiCurrency'])->name('modules.edit.multi-currency.daily-rates');

    Route::post('/currency/store', [ModuleController::class, 'storeCurrency'])->name('currency.store');
    Route::put('/currency/update', [ModuleController::class, 'updateCurrency'])->name('currency.update');
    Route::delete('/currency/delete/{id}', [ModuleController::class, 'deleteCurrency'])->name('currency.delete');
    Route::post('/home-currency/store', [ModuleController::class, 'storeHomeCurrency'])->name('home.currency.store');
    Route::put('/home-currency/update', [ModuleController::class, 'updateHomeCurrency'])->name('home.currency.update');
    Route::delete('/home-currency/delete/{id}', [ModuleController::class, 'deleteHomeCurrency'])->name('home.currency.delete');
    Route::post('/rate/store', [ModuleController::class, 'storeRate'])->name('rate.store');
    Route::put('/rate/update', [ModuleController::class, 'updateRate'])->name('rate.update');
    Route::delete('/rate/delete/{id}', [ModuleController::class, 'deleteRate'])->name('rate.delete');

    Route::get('/edit/taxes', [TaxController::class, 'index'])->name('taxes.index');
    Route::get('/edit/taxes/create', [TaxController::class, 'create'])->name('taxes.create');
    Route::get('/edit/suppliers', [ModuleController::class, 'suppliers'])->name('modules.edit.suppliers');
    Route::get('/edit/suppliers/accounts', [ModuleController::class, 'supplierAccounts'])->name('modules.edit.suppliers.accounts');
    Route::get('/edit/suppliers/accounts/create', [ModuleController::class, 'createSupplierAccount'])->name('modules.edit.suppliers.accounts.create');
    Route::post('/edit/suppliers/accounts/store', [ModuleController::class, 'storeSupplierAccount'])->name('modules.edit.suppliers.accounts.store');
    Route::get('/edit/suppliers/accounts/{id}', [ModuleController::class, 'showSupplierAccount'])->name('modules.edit.suppliers.accounts.show');
    Route::get('/edit/suppliers/accounts/{id}/edit', [ModuleController::class, 'editSupplierAccount'])->name('modules.edit.suppliers.accounts.edit');
    Route::put('/edit/suppliers/accounts/{id}', [ModuleController::class, 'updateSupplierAccount'])->name('modules.edit.suppliers.accounts.update');
    Route::delete('/edit/suppliers/accounts/{id}', [ModuleController::class, 'destroySupplierAccount'])->name('modules.edit.suppliers.accounts.destroy');
    Route::get('/edit/suppliers/age-analysis', [ModuleController::class, 'supplierAgeAnalysis'])->name('modules.edit.suppliers.age-analysis');
    Route::get('/edit/suppliers/area', [ModuleController::class, 'supplierArea'])->name('modules.edit.suppliers.area');
    Route::get('/edit/suppliers/area/create', [ModuleController::class, 'createSupplierArea'])->name('modules.edit.suppliers.area.create');
    Route::post('/edit/suppliers/area/store', [ModuleController::class, 'storeSupplierArea'])->name('modules.edit.suppliers.area.store');
    Route::get('/edit/suppliers/area/{id}', [ModuleController::class, 'showSupplierArea'])->name('modules.edit.suppliers.area.show');
    Route::get('/edit/suppliers/area/{id}/edit', [ModuleController::class, 'editSupplierArea'])->name('modules.edit.suppliers.area.edit');
    Route::put('/edit/suppliers/area/{id}', [ModuleController::class, 'updateSupplierArea'])->name('modules.edit.suppliers.area.update');
    Route::delete('/edit/suppliers/area/{id}', [ModuleController::class, 'destroySupplierArea'])->name('modules.edit.suppliers.area.destroy');
    Route::get('/edit/suppliers/categories', [ModuleController::class, 'supplierCategories'])->name('modules.edit.suppliers.categories');
    Route::get('/edit/clients', [ClientController::class, 'index'])->name('modules.edit.clients');
    Route::get('/edit/client', [ClientController::class, 'index'])->name('modules.edit.client');
    Route::get('/edit/add-clients', [ClientController::class, 'create'])->name('modules.edit.add-clients');
    Route::post('/edit/clients', [ClientController::class, 'store'])->name('clients.store');
    Route::get('/edit/clients/{id}', [ClientController::class, 'show'])->name('clients.show');
    Route::get('/edit/clients/{id}/edit', [ClientController::class, 'edit'])->name('clients.edit');
    Route::put('/edit/clients/{id}', [ClientController::class, 'update'])->name('clients.update');
    Route::delete('/edit/clients/{id}', [ClientController::class, 'destroy'])->name('clients.destroy');
    Route::get('/edit/lawyers', [LawyerController::class, 'index'])->name('modules.edit.lawyers');
    Route::get('/edit/lawyer', [LawyerController::class, 'index'])->name('modules.edit.lawyer');
    Route::get('/edit/lawyer-management', [LawyerController::class, 'management'])->name('modules.edit.lawyer-management');
    Route::get('/edit/lawyer-roles', [ModuleController::class, 'lawyerRoles'])->name('modules.edit.lawyer-roles');
    Route::get('/edit/lawyer-roles/add', [ModuleController::class, 'createLawyerRole'])->name('modules.edit.lawyer-roles.add');
    Route::post('/edit/lawyer-roles/store', [ModuleController::class, 'storeLawyerRole'])->name('modules.edit.lawyer-roles.store');
    Route::get('/edit/lawyer-roles/view', [ModuleController::class, 'viewLawyerRoles'])->name('modules.edit.lawyer-roles.view');
    Route::get('/edit/lawyer-roles/{lawyer_role_id}/edit', [ModuleController::class, 'editLawyerRole'])->name('modules.edit.lawyer-roles.edit');
    Route::put('/edit/lawyer-roles/{lawyer_role_id}', [ModuleController::class, 'updateLawyerRole'])->name('modules.edit.lawyer-roles.update');
    Route::delete('/edit/lawyer-roles/{lawyer_role_id}', [ModuleController::class, 'destroyLawyerRole'])->name('modules.edit.lawyer-roles.destroy');
    Route::get('/edit/add-lawyer', [LawyerController::class, 'create'])->name('modules.edit.add-lawyer');
    Route::post('/edit/lawyer', [LawyerController::class, 'store'])->name('modules.edit.lawyer.store');
    Route::get('/edit/lawyer/{id}', [LawyerController::class, 'show'])->name('modules.edit.lawyer.show');
    Route::get('/edit/lawyer/{id}/edit', [LawyerController::class, 'edit'])->name('modules.edit.lawyer.edit');
    Route::put('/edit/lawyer/{id}', [LawyerController::class, 'update'])->name('modules.edit.lawyer.update');
    Route::delete('/edit/lawyer/{id}', [LawyerController::class, 'destroy'])->name('modules.edit.lawyer.destroy');
    Route::get('/edit/client-categories', [\App\Http\Controllers\ClientCategoryController::class, 'index'])->name('modules.edit.client-categories');
    Route::post('/edit/client-categories', [\App\Http\Controllers\ClientCategoryController::class, 'store'])->name('client-categories.store');
    Route::get('/edit/client-categories/{id}/edit', [\App\Http\Controllers\ClientCategoryController::class, 'edit'])->name('client-categories.edit');
    Route::put('/edit/client-categories/{id}', [\App\Http\Controllers\ClientCategoryController::class, 'update'])->name('client-categories.update');
    Route::delete('/edit/client-categories/{id}', [\App\Http\Controllers\ClientCategoryController::class, 'destroy'])->name('client-categories.destroy');
    Route::get('/edit/add-age-analysis', [ClientController::class, 'addAgeAnalysis'])->name('modules.edit.add-age-analysis');
    Route::post('/age-analysis/store', [AgeingAnalysisController::class, 'store'])->name('age-analysis.store');
    Route::get('/age-analysis/edit/{id}', [AgeingAnalysisController::class, 'edit'])->name('ageing.edit');
    Route::put('/age-analysis/update/{id}', [AgeingAnalysisController::class, 'update'])->name('ageing.update');
    Route::delete('/age-analysis/delete/{id}', [AgeingAnalysisController::class, 'destroy'])->name('ageing.delete');
    Route::get('/edit/add-age-analysis-new', [AgeingAnalysisController::class, 'index'])->name('modules.edit.add-age-analysis-new');

    Route::get('/edit/case', [ModuleController::class, 'case'])->name('modules.edit.case');
    Route::get('/edit/cases-options', [ModuleController::class, 'casesOptions'])->name('modules.edit.cases-options');
    Route::get('/edit/case-parties', [ModuleController::class, 'caseParties'])->name('modules.edit.case-parties');
    Route::get('/edit/case-parties/add', [ModuleController::class, 'addCaseParties'])->name('modules.edit.add-parties');
    Route::post('/edit/case-parties/store', [ModuleController::class, 'storeCaseParties'])->name('modules.edit.case-parties.store');
    Route::get('/edit/case-parties/list', [ModuleController::class, 'listCaseParties'])->name('modules.edit.view-parties');
    Route::get('/edit/case-parties/{id}/edit', [ModuleController::class, 'editCaseParties'])->name('modules.edit.edit-parties');
    Route::put('/edit/case-parties/{id}', [ModuleController::class, 'updateCaseParties'])->name('modules.edit.case-parties.update');
    Route::delete('/edit/case-parties/{id}', [ModuleController::class, 'destroyCaseParties'])->name('modules.edit.case-parties.destroy');
    Route::get('/edit/case-roles', [ModuleController::class, 'caseRoles'])->name('modules.edit.case-roles');
    Route::get('/edit/case-priorities', [ModuleController::class, 'casePriorities'])->name('modules.edit.case-priorities');
    Route::get('/edit/case-priorities/add', [ModuleController::class, 'casePrioritiesAdd'])->name('modules.edit.case-priorities.add');
    Route::get('/edit/cases', [CaseController::class, 'index'])->name('modules.edit.cases');
    Route::get('/edit/add-case', [CaseController::class, 'create'])->name('modules.edit.add-case');
    Route::post('/edit/case', [CaseController::class, 'store'])->name('case.store');
    Route::get('/edit/case/{id}', [CaseController::class, 'show'])->name('case.show');
    Route::get('/edit/case/{id}/edit', [CaseController::class, 'edit'])->name('case.edit');
    Route::put('/edit/case/{id}', [CaseController::class, 'update'])->name('case.update');
    Route::delete('/edit/case/{id}', [CaseController::class, 'destroy'])->name('case.destroy');



    // Routes to mark case as won or lost
    Route::post('/edit/case/{id}/mark-won', [CaseController::class, 'markWon'])->name('case.markWon');
    Route::post('/edit/case/{id}/mark-lost', [CaseController::class, 'markLost'])->name('case.markLost');
    Route::get ('/edit/tariff', [ModuleController::class, 'tariff'])->name('modules.edit.tariff');
    Route::resource('tariffs', \App\Http\Controllers\TariffController::class);

    Route::post('/edit/taxes', [TaxController::class, 'store'])->name('taxes.store');
    Route::get('/edit/taxes/{tax_id}/edit', [TaxController::class, 'edit'])->name('taxes.edit');
    Route::put('/edit/taxes/{tax_id}', [TaxController::class, 'update'])->name('taxes.update');
    Route::delete('/edit/taxes/{tax_id}', [TaxController::class, 'destroy'])->name('taxes.destroy');
    Route::get('/processing', [ModuleController::class, 'processing'])->name('modules.processing');
    Route::get('/processing/task-management', [ModuleController::class, 'taskManagement'])->name('modules.processing.task-management');
    Route::get('/processing/task-dashboard', [\App\Http\Controllers\DiaryController::class, 'dashboard'])->name('modules.processing.task-dashboard');
    Route::get('/processing/loading', function() {
        return view('modules.processing.loading');
    })->name('modules.processing.loading');
    Route::get('/processing/diary', [ModuleController::class, 'diary'])->name('modules.processing.diary');
    Route::get('/processing/assignment-collaboration', [ModuleController::class, 'assignmentCollaboration'])->name('modules.processing.assignment-collaboration');
    Route::get('/processing/court-filings', [ModuleController::class, 'courtFilings'])->name('modules.processing.court-filings');
    Route::resource('court-filings', \App\Http\Controllers\CourtFilingController::class);
    Route::get('/processing/options', [ModuleController::class, 'options'])->name('modules.processing.options');
    Route::get('/processing/client', [ModuleController::class, 'client'])->name('modules.processing.client');
    Route::get('/processing/client-quotation', [ModuleController::class, 'clientQuotation'])->name('modules.processing.client-quotation');
    Route::post('/processing/client-quotation/store', [ModuleController::class, 'storeClientQuotation'])->name('modules.processing.client-quotation.store');
    Route::get('/processing/client-quotation/edit/{id}', [ModuleController::class, 'editClientQuotation'])->name('modules.processing.client-quotation.edit');
    Route::put('/processing/client-quotation/update/{id}', [ModuleController::class, 'updateClientQuotation'])->name('modules.processing.client-quotation.update');
    Route::delete('/processing/client-quotation/destroy/{id}', [ModuleController::class, 'destroyClientQuotation'])->name('modules.processing.client-quotation.destroy');
    Route::post('/processing/client-quotation/process/{quotation?}', [ModuleController::class, 'processClientQuotation'])->name('modules.processing.client-quotation.process');
    Route::get('/processing/client-invoice', [ModuleController::class, 'clientInvoice'])->name('modules.processing.client-invoice');
    Route::post('/processing/client-invoice/store', [ModuleController::class, 'storeClientInvoice'])->name('modules.processing.client-invoice.store');
    Route::put('/processing/client-invoice/update/{id}', [ModuleController::class, 'updateClientInvoice'])->name('modules.processing.client-invoice.update');
    Route::delete('/processing/client-invoice/destroy/{id}', [ModuleController::class, 'destroyClientInvoice'])->name('modules.processing.client-invoice.destroy');
    Route::get('/processing/client-invoice/process/{invoice?}', [ModuleController::class, 'processClientInvoice'])->name('modules.processing.client-invoice.process');
    Route::get('/processing/client-invoice/pdf/{id}', [ModuleController::class, 'generateClientInvoicePDF'])->name('modules.processing.client-invoice.pdf');
Route::get('/processing/client-receipt', [ModuleController::class, 'clientReceipt'])->name('modules.processing.client-receipt');
Route::get('/processing/client-receipt/{id}/edit', [ModuleController::class, 'editClientReceipt'])->name('modules.processing.client-receipt.edit');
Route::post('/processing/client-receipt/store', [ModuleController::class, 'storeClientReceipt'])->name('modules.processing.client-receipt.store');
Route::put('/processing/client-receipt/update/{id}', [ModuleController::class, 'updateClientReceipt'])->name('modules.processing.client-receipt.update');
Route::delete('/processing/client-receipt/destroy/{id}', [ModuleController::class, 'destroyClientReceipt'])->name('modules.processing.client-receipt.destroy');
Route::get('/processing/client-receipt/process/{receipt?}', [ModuleController::class, 'processClientReceipt'])->name('modules.processing.client-receipt.process');
Route::get('/processing/client-receipt/pdf/{id}', [ModuleController::class, 'generateClientReceiptPDF'])->name('modules.processing.client-receipt.pdf');
    Route::get('/api/customers/{id}/invoices', [ModuleController::class, 'getCustomerInvoices'])->name('api.customers.invoices');
    Route::get('/api/lawyers/search', [LawyerController::class, 'search'])->name('api.lawyers.search');
    Route::get('/processing/supplier-invoice', [ModuleController::class, 'supplierInvoice'])->name('modules.processing.supplier-invoice');
    Route::post('/processing/supplier-invoice/store', [ModuleController::class, 'storeSupplierInvoice'])->name('modules.processing.supplier-invoice.store');
    Route::put('/processing/supplier-invoice/update/{id}', [ModuleController::class, 'updateSupplierInvoice'])->name('modules.processing.supplier-invoice.update');
    Route::delete('/processing/supplier-invoice/destroy/{id}', [ModuleController::class, 'destroySupplierInvoice'])->name('modules.processing.supplier-invoice.destroy');
    Route::get('/processing/supplier-invoice/process/{invoice?}', [ModuleController::class, 'processSupplierInvoice'])->name('modules.processing.supplier-invoice.process');
    Route::get('/processing/suppliers', [\App\Http\Controllers\SupplierController::class, 'suppliers'])->name('modules.processing.suppliers');
    Route::get('/processing/suppliers/add', [\App\Http\Controllers\SupplierController::class, 'addSupplier'])->name('modules.processing.suppliers.add');
    Route::post('/processing/suppliers', [\App\Http\Controllers\SupplierController::class, 'storeSupplier'])->name('modules.processing.suppliers.store');
    Route::get('/processing/suppliers/{id}', [\App\Http\Controllers\SupplierController::class, 'showSupplier'])->name('modules.processing.suppliers.show');
    Route::get('/processing/suppliers/{id}/edit', [\App\Http\Controllers\SupplierController::class, 'editSupplier'])->name('modules.processing.suppliers.edit');
    Route::put('/processing/suppliers/{id}', [\App\Http\Controllers\SupplierController::class, 'updateSupplier'])->name('modules.processing.suppliers.update');
    Route::delete('/processing/suppliers/{id}', [\App\Http\Controllers\SupplierController::class, 'destroySupplier'])->name('modules.processing.suppliers.destroy');
    Route::delete('/processing/suppliers/bulk-destroy', [\App\Http\Controllers\SupplierController::class, 'bulkDestroy'])->name('suppliers.bulk-destroy');
    Route::get('/processing/cash-book', [ModuleController::class, 'cashBook'])->name('modules.processing.cash-book');
    Route::post('/processing/cash-book/store', [ModuleController::class, 'storeCashbookEntry'])->name('cashbook.entry.transaction.store');
    Route::get('/processing/cash-book/{id}/edit', [ModuleController::class, 'editCashbookEntry'])->name('cashbook.entry.edit');
    Route::put('/processing/cash-book/{id}', [ModuleController::class, 'updateCashbookEntry'])->name('cashbook.update');
    Route::delete('/processing/cash-book/{id}', [ModuleController::class, 'deleteCashbookEntry'])->name('cashbook.delete');
    Route::get('/processing/journal', [ModuleController::class, 'journal'])->name('modules.processing.journal');
    Route::get('/processing/journals/client', [ModuleController::class, 'clientJournal'])->name('modules.processing.journals.client');
    Route::get('/processing/journals/general', [ModuleController::class, 'generalJournal'])->name('modules.processing.journals.general');
    Route::get('/processing/journals/supplier', [ModuleController::class, 'supplierJournal'])->name('modules.processing.journals.supplier');
    Route::get('/reports', [ModuleController::class, 'reports'])->name('modules.reports');
    Route::get('/reports/general-ledger', [ReportController::class, 'generalLedger'])->name('modules.reports.general-ledger');
    Route::get('/reports/general-ledger/{glcode}', [ReportController::class, 'glAccountDetail'])->name('modules.reports.gl-account-detail');
    Route::get('/reports/general-ledger/download-pdf', [ReportController::class, 'downloadGeneralLedgerPdf'])->name('modules.reports.general-ledger.download-pdf');
Route::get('/reports/client-statement', [ClientStatementController::class, 'index'])->name('modules.reports.client-statement');
    Route::get('/reports/case-status', [ReportController::class, 'caseStatus'])->name('modules.reports.case-status');
    Route::post('/reports/case-status/generate', [ReportController::class, 'generateCaseStatus'])->name('caseStatus.generate');
    Route::post('/reports/case-status/download-pdf', [ReportController::class, 'downloadCaseStatusPdf'])->name('caseStatus.downloadPdf');
    Route::get('/reports/court-filings', [ReportController::class, 'courtFilings'])->name('modules.reports.court-filings');
    Route::post('/reports/court-filings/generate', [ReportController::class, 'generateCourtFilings'])->name('courtFilings.generate');
    Route::post('/reports/court-filings/download-pdf', [ReportController::class, 'downloadCourtFilingsPdf'])->name('courtFilings.downloadPdf');
    Route::get('/reports/lawyer-statement', [LawyerStatementController::class, 'index'])->name('modules.reports.lawyer-statement');
    Route::post('/reports/lawyer-statement/generate', [LawyerStatementController::class, 'generate'])->name('modules.reports.lawyer-statement.generate');
    Route::get('/reports/outstanding-fees', [OutstandingFeesController::class, 'index'])->name('modules.reports.outstanding-fees');
    Route::get('/reports/total-fees', [TotalFeesController::class, 'index'])->name('modules.reports.total-fees');
    Route::get('/reports/fee-collection', [FeeCollectionController::class, 'index'])->name('modules.reports.fee-collection');
    Route::get('/reports/supplier-statement', [ReportController::class, 'supplierStatement'])->name('modules.reports.supplier-statement');
    Route::post('/reports/supplier-statement/generate', [ReportController::class, 'generateSupplierStatement'])->name('supplierStatement.generate');
    Route::post('/reports/supplier-statement/download-pdf', [ReportController::class, 'downloadSupplierStatementPdf'])->name('supplierStatement.downloadPdf');
    Route::get('/reports/cash-book', [ReportController::class, 'cashBook'])->name('modules.reports.cash-book');
    Route::get('/reports/tax-reports', [ReportController::class, 'taxReports'])->name('modules.reports.tax-reports');
    Route::post('/reports/tax-reports/generate', [ReportController::class, 'generateTaxReport'])->name('taxReport.generate');
    Route::post('/reports/tax-reports/download-pdf', [ReportController::class, 'downloadTaxReportPdf'])->name('taxReport.downloadPdf');
    Route::post('/reports/cash-book/generate', [ReportController::class, 'generateCashbookReport'])->name('cashbookDailyTransaction.generate');
    Route::post('/reports/cash-book/download-pdf', [ReportController::class, 'downloadCashbookPdf'])->name('cashbookDailyTransaction.downloadPdf');

    Route::get('/reports/income-statements', [ReportController::class, 'incomeStatements'])->name('modules.reports.income-statements');
    Route::post('/reports/income-statements/generate', [ReportController::class, 'generateIncomeStatements'])->name('incomeStatements.generate');
    Route::post('/reports/income-statements/download-pdf', [ReportController::class, 'downloadIncomeStatementsPdf'])->name('incomeStatements.downloadPdf');
    Route::get('/reports/balance-sheet', [ReportController::class, 'balanceSheet'])->name('modules.reports.balance-sheet');
    Route::post('/reports/balance-sheet/generate', [ReportController::class, 'generateBalanceSheet'])->name('balanceSheet.generate');
    Route::post('/reports/balance-sheet/download-pdf', [ReportController::class, 'downloadBalanceSheetPdf'])->name('balanceSheet.downloadPdf');
    Route::get('/reports/trial-balance', [ReportController::class, 'trialBalance'])->name('modules.reports.trial-balance');
    Route::get('/reports/chart-of-accounts', [ReportController::class, 'chartOfAccounts'])->name('modules.reports.chart-of-accounts');

    Route::get('/reports/journals', [ReportController::class, 'journals'])->name('modules.reports.journals');
    Route::get('/reports/journals/general', [ReportController::class, 'generalJournalReport'])->name('modules.reports.journals.general');
    Route::get('/reports/journals/customer', [ReportController::class, 'customerJournalReport'])->name('modules.reports.journals.customer');
    Route::get('/reports/journals/supplier', [ReportController::class, 'supplierJournalReport'])->name('modules.reports.journals.supplier');

    Route::get('/ledger/create', [LedgerController::class, 'create'])->name('ledger.create');
    Route::post('/ledger/store', [LedgerController::class, 'store'])->name('ledger.store');
    Route::post('/ledger/edit', [LedgerController::class, 'edit'])->name('editMainAccount');
    Route::delete('/ledger/delete/{id}', [LedgerController::class, 'destroy'])->name('deleteMainAccount');
    Route::get('/ledger/subacc/add/{id}', [LedgerController::class, 'addSubAccount'])->name('subacc.add');
    Route::post('/ledger/subacc/store', [LedgerController::class, 'storeSubAccount'])->name('subacc.store');
    Route::post('/ledger/subacc/edit', [LedgerController::class, 'editSubAccount'])->name('subacc.edit');
    Route::delete('/ledger/subacc/delete/{id}', [LedgerController::class, 'deleteSubAccount'])->name('subacc.delete');

    Route::get('/account-types', [AccountTypeController::class, 'index'])->name('account_types.index');
    Route::post('/account-types/store', [AccountTypeController::class, 'store'])->name('account_types.store');
    Route::post('/account-types/edit', [AccountTypeController::class, 'edit'])->name('account_types.edit');
    Route::get('/account-types/delete/{id}', [AccountTypeController::class, 'destroy'])->name('account_types.delete');

    Route::get('/departments', [DepartmentController::class, 'index'])->name('departments.index');
    Route::post('/departments/store', [DepartmentController::class, 'store'])->name('departments.store');
    Route::post('/departments/edit', [DepartmentController::class, 'edit'])->name('departments.edit');
    Route::get('/departments/delete/{id}', [DepartmentController::class, 'destroy'])->name('departments.delete');

#case category
    Route::get('/edit/case-categories', [CaseCategoryController::class, 'caseCategory'])->name('modules.edit.case-categories');
    Route::get('/edit/case/case-categories', [CaseCategoryController::class, 'caseCategory'])->name('modules.edit.case-categories.index');
    Route::get('/edit/case/case-categories/list', [CaseCategoryController::class, 'index'])->name('modules.edit.case-categories.list');
    Route::get('/edit/case/case-categories/create', [CaseCategoryController::class, 'create'])->name('modules.edit.case-categories.create');
    Route::post('/edit/case/case-categories', [CaseCategoryController::class, 'store'])->name('modules.edit.case-categories.store');
    Route::get('/edit/case/case-categories/{category_code}', [CaseCategoryController::class, 'show'])->name('modules.edit.case-categories.show');
    Route::get('/edit/case/case-categories/{category_code}/edit', [CaseCategoryController::class, 'edit'])->name('modules.edit.case-categories.edit');
    Route::put('/edit/case/case-categories/{category_code}', [CaseCategoryController::class, 'update'])->name('modules.edit.case-categories.update');
    Route::delete('/edit/case/case-categories/{category_code}', [CaseCategoryController::class, 'destroy'])->name('modules.edit.case-categories.destroy');

// Case Types routes
Route::get('/edit/case-types', [CaseTypeController::class, 'index'])->name('modules.edit.case-types');
Route::get('/edit/case-types/list', [CaseTypeController::class, 'caseTypeList'])->name('modules.edit.case-types.list');
Route::get('/edit/case-types/add', [CaseTypeController::class, 'caseTypeAdd'])->name('modules.edit.case-types.add');
Route::post('/edit/case-types', [CaseTypeController::class, 'store'])->name('case-types.store');
Route::get('/edit/case-types/{id}', [CaseTypeController::class, 'show'])->name('modules.edit.case-types.show');
Route::get('/edit/case-types/{id}/edit', [CaseTypeController::class, 'edit'])->name('modules.edit.case-types.edit');
Route::put('/edit/case-types/{id}', [CaseTypeController::class, 'update'])->name('case-types.update');
Route::delete('/edit/case-types/{id}', [CaseTypeController::class, 'destroy'])->name('case-types.destroy');

// Case Priorities routes
Route::get('/edit/case-priorities', [CasePriorityController::class, 'casePriority'])->name('modules.edit.case-priorities');
Route::match(['GET', 'POST'], '/edit/case-priorities/list', [CasePriorityController::class, 'casePriorityList'])->name('modules.edit.case-priorities.list');
Route::get('/edit/case-priorities/add', [CasePriorityController::class, 'casePriorityAdd'])->name('modules.edit.case-priorities.add');
Route::post('/edit/case-priorities', [CasePriorityController::class, 'store'])->name('case-priorities.store');
Route::get('/edit/case-priorities/{priority_id}', [CasePriorityController::class, 'show'])->name('modules.edit.case-priorities.show');
Route::get('/edit/case-priorities/{priority_id}/edit', [CasePriorityController::class, 'edit'])->name('modules.edit.case-priorities.edit');
Route::put('/edit/case-priorities/{priority_id}', [CasePriorityController::class, 'update'])->name('case-priorities.update');
Route::delete('/edit/case-priorities/{priority_id}', [CasePriorityController::class, 'destroy'])->name('case-priorities.destroy');

// Case Roles routes
Route::get('/edit/case-roles', [CaseRoleController::class, 'caseRole'])->name('modules.edit.case-roles');
Route::get('/edit/case-roles/list', [CaseRoleController::class, 'caseRoleList'])->name('modules.edit.case-roles.list');
Route::get('/edit/case-roles/add', [CaseRoleController::class, 'caseRoleAdd'])->name('modules.edit.case-roles.add');
Route::post('/edit/case-roles', [CaseRoleController::class, 'store'])->name('case-roles.store');
Route::get('/edit/case-roles/{role_id}', [CaseRoleController::class, 'show'])->name('modules.edit.case-roles.show');
Route::get('/edit/case-roles/{role_id}/edit', [CaseRoleController::class, 'edit'])->name('modules.edit.case-roles.edit');
Route::put('/edit/case-roles/{role_id}', [CaseRoleController::class, 'update'])->name('case-roles.update');
Route::delete('/edit/case-roles/{role_id}', [CaseRoleController::class, 'destroy'])->name('case-roles.destroy');

    // Supplier Categories routes
    Route::get('/edit/suppliers/categories', [ModuleController::class, 'supplierCategories'])->name('modules.edit.suppliers.categories');
    Route::get('/edit/suppliers/categories/create', [ModuleController::class, 'createSupplierCategory'])->name('modules.edit.suppliers.categories.create');
    Route::post('/edit/suppliers/categories', [ModuleController::class, 'storeSupplierCategory'])->name('modules.edit.suppliers.categories.store');
    Route::get('/edit/suppliers/categories/{category_code}', [ModuleController::class, 'showSupplierCategory'])->name('modules.edit.suppliers.categories.show');
    Route::get('/edit/suppliers/categories/{category_code}/edit', [ModuleController::class, 'editSupplierCategory'])->name('modules.edit.suppliers.categories.edit');
    Route::put('/edit/suppliers/categories/{category_code}', [ModuleController::class, 'updateSupplierCategory'])->name('modules.edit.suppliers.categories.update');
    Route::delete('/edit/suppliers/categories/{category_code}', [ModuleController::class, 'destroySupplierCategory'])->name('modules.edit.suppliers.categories.destroy');

    });

    // Administration routes
    Route::prefix('administration')->group(function () {
        Route::get('/', [AdministrationController::class, 'adminIndex'])->name('administration');
        Route::get('/general-settings', [AdministrationController::class, 'generalSettings'])->name('administration.general-settings');
        Route::get('/user-settings', [AdministrationController::class, 'userSettings'])->name('administration.user-settings');
        Route::get('/user-management', [AdministrationController::class, 'userManagement'])->name('administration.user-management');
        Route::get('/user-management/add', [AdministrationController::class, 'createUser'])->name('administration.create-user');
        Route::post('/user-management', [AdministrationController::class, 'storeUser'])->name('administration.store-user');
        Route::get('/user-management/{id}/edit', [AdministrationController::class, 'editUser'])->name('administration.edit-user');
        Route::put('/user-management/{id}', [AdministrationController::class, 'updateUser'])->name('administration.update-user');
        Route::delete('/user-management/{id}', [AdministrationController::class, 'destroyUser'])->name('administration.destroy-user');
        Route::get('/user-management/{id}/permissions', [AdministrationController::class, 'userPermissions'])->name('administration.user-permissions');
        Route::put('/user-management/{id}/permissions', [AdministrationController::class, 'updateUserPermissions'])->name('administration.update-user-permissions');
        // Roles routes
        Route::get('/roles', [AdministrationController::class, 'rolesIndex'])->name('administration.roles.index');
        Route::get('/roles/create', [AdministrationController::class, 'rolesCreate'])->name('administration.roles.create');
        Route::post('/roles', [AdministrationController::class, 'rolesStore'])->name('administration.roles.store');
        Route::get('/roles/{id}', [AdministrationController::class, 'rolesShow'])->name('administration.roles.show');
        Route::get('/roles/{id}/edit', [AdministrationController::class, 'rolesEdit'])->name('administration.roles.edit');
        Route::put('/roles/{id}', [AdministrationController::class, 'rolesUpdate'])->name('administration.roles.update');
        Route::delete('/roles/{id}', [AdministrationController::class, 'rolesDestroy'])->name('administration.roles.destroy');
        // Groups routes
        Route::get('/groups', [AdministrationController::class, 'groupsIndex'])->name('administration.groups.index');
        Route::get('/groups/create', [AdministrationController::class, 'groupsCreate'])->name('administration.groups.create');
        Route::post('/groups', [AdministrationController::class, 'groupsStore'])->name('administration.groups.store');
        Route::get('/groups/{id}', [AdministrationController::class, 'groupsShow'])->name('administration.groups.show');
        Route::get('/groups/{id}/edit', [AdministrationController::class, 'groupsEdit'])->name('administration.groups.edit');
        Route::put('/groups/{id}', [AdministrationController::class, 'groupsUpdate'])->name('administration.groups.update');
        Route::delete('/groups/{id}', [AdministrationController::class, 'groupsDestroy'])->name('administration.groups.destroy');
        Route::get('/company-info', [AdministrationController::class, 'companyInfo'])->name('administration.company-info');
        Route::get('/system-settings', [AdministrationController::class, 'systemSettings'])->name('system.settings');
        Route::get('/api/company-info', [AdministrationController::class, 'getCompanyInfoApi'])->name('administration.api.company-info');
        Route::post('/api/company-info', [AdministrationController::class, 'updateCompanyInfoApi'])->name('administration.api.company-info.update');
        Route::get('/api/system-settings', [AdministrationController::class, 'getSystemSettingsApi'])->name('administration.api.system-settings');
        Route::post('/api/system-settings', [AdministrationController::class, 'updateSystemSettingsApi'])->name('administration.api.system-settings.update');
        Route::get('/approvals', [AdministrationController::class, 'approvals'])->name('administration.approvals');
    });

    // Case Reasons routes - FIXED: Now using CaseReasonController
    Route::get('/edit/case/case-reasons', [CaseReasonController::class, 'index'])->name('modules.edit.case-reasons');
    Route::get('/edit/case/case-reasons/list', [CaseReasonController::class, 'index'])->name('modules.edit.case-reasons.list');
    Route::get('/edit/case/case-reasons/add', [CaseReasonController::class, 'create'])->name('modules.edit.case-reasons.add');
    Route::post('/edit/case/case-reasons', [CaseReasonController::class, 'store'])->name('case-reasons.store');
    Route::get('/edit/case/case-reasons/{id}', [CaseReasonController::class, 'show'])->name('modules.edit.case-reasons.show');
    Route::get('/edit/case/case-reasons/{id}/edit', [CaseReasonController::class, 'edit'])->name('modules.edit.case-reasons.edit');
    Route::put('/edit/case/case-reasons/{id}', [CaseReasonController::class, 'update'])->name('case-reasons.update');
    Route::delete('/edit/case/case-reasons/{id}', [CaseReasonController::class, 'destroy'])->name('case-reasons.destroy');

    // Add the missing case-reasons.index route that the controller redirects to
    Route::get('/case-reasons', [CaseReasonController::class, 'index'])->name('case-reasons.index');

    // Case Outcomes routes
    Route::get('/edit/case/case-outcomes', [CaseOutcomeController::class, 'index'])->name('modules.edit.case-outcomes');
    Route::get('/edit/case/case-outcomes/list', [CaseOutcomeController::class, 'index'])->name('modules.edit.case-outcomes.list');
    Route::get('/edit/case/case-outcomes/add', [CaseOutcomeController::class, 'create'])->name('modules.edit.case-outcomes.add');
    Route::post('/edit/case/case-outcomes', [CaseOutcomeController::class, 'store'])->name('case-outcomes.store');
    Route::get('/edit/case/case-outcomes/{id}', [CaseOutcomeController::class, 'show'])->name('modules.edit.case-outcomes.show');
    Route::get('/edit/case/case-outcomes/{id}/edit', [CaseOutcomeController::class, 'edit'])->name('modules.edit.case-outcomes.edit');
    Route::put('/edit/case/case-outcomes/{id}', [CaseOutcomeController::class, 'update'])->name('case-outcomes.update');
    Route::delete('/edit/case/case-outcomes/{id}', [CaseOutcomeController::class, 'destroy'])->name('case-outcomes.destroy');

    // Add the missing case-outcomes.index route that the controller redirects to
    Route::get('/case-outcomes', [CaseOutcomeController::class, 'index'])->name('case-outcomes.index');

    });

// Include Task Management Routes
require __DIR__.'/task-management.php';

// Case Status routes
Route::get('/edit/case/case-status', [ModuleController::class, 'caseStatus'])->name('modules.edit.case-status');
Route::get('/edit/case/case-status/list', [ModuleController::class, 'caseStatusList'])->name('modules.edit.case-status.list');
Route::get('/edit/case/case-status/add', [ModuleController::class, 'caseStatusAdd'])->name('modules.edit.case-status.add');
Route::post('/edit/case/case-status', [ModuleController::class, 'caseStatusStore'])->name('case-status.store');
Route::get('/edit/case/case-status/{status_code}', [ModuleController::class, 'caseStatusShow'])->name('modules.edit.case-status.show');
Route::get('/edit/case/case-status/{status_code}/edit', [ModuleController::class, 'caseStatusEdit'])->name('modules.edit.case-status.edit');
Route::put('/edit/case/case-status/{status_code}', [ModuleController::class, 'caseStatusUpdate'])->name('case-status.update');
Route::delete('/edit/case/case-status/{status_code}', [ModuleController::class, 'caseStatusDelete'])->name('case-status.destroy');



// Include Customer Journal Routes
require __DIR__.'/client-journal.php';
// Include Supplier Journal Routes
require __DIR__.'/supplier-journal.php';

// Diary Routes
Route::prefix('modules/processing')->name('modules.processing.')->group(function () {
    Route::resource('diary', \App\Http\Controllers\DiaryController::class);
    Route::get('diary-list', [\App\Http\Controllers\DiaryController::class, 'index'])->name('diary.list');
    Route::get('diary-add', [\App\Http\Controllers\DiaryController::class, 'create'])->name('diary.add');
    Route::get('diary/{id}', [\App\Http\Controllers\DiaryController::class, 'show'])->name('diary.show');
    Route::get('diary/{id}/edit', [\App\Http\Controllers\DiaryController::class, 'edit'])->name('diary.edit');
    Route::post('diary', [\App\Http\Controllers\DiaryController::class, 'store'])->name('diary.store');
    Route::put('diary/{id}', [\App\Http\Controllers\DiaryController::class, 'update'])->name('diary.update');
    Route::delete('diary/{id}', [\App\Http\Controllers\DiaryController::class, 'destroy'])->name('diary.delete');

    // Additional diary routes
    Route::get('diary-today', [\App\Http\Controllers\DiaryController::class, 'today'])->name('diary.today');
    Route::get('diary-upcoming', [\App\Http\Controllers\DiaryController::class, 'upcoming'])->name('diary.upcoming');
    Route::get('diary-overdue', [\App\Http\Controllers\DiaryController::class, 'overdue'])->name('diary.overdue');
    Route::get('diary-status/{status}', [\App\Http\Controllers\DiaryController::class, 'byStatus'])->name('diary.status');
    Route::get('diary-priority/{priority}', [\App\Http\Controllers\DiaryController::class, 'byPriority'])->name('diary.priority');
    Route::get('diary-type/{taskType}', [\App\Http\Controllers\DiaryController::class, 'byTaskType'])->name('diary.type');
    Route::get('diary-dashboard', [\App\Http\Controllers\DiaryController::class, 'dashboard'])->name('diary.dashboard');
    Route::get('diary-calendar', [ModuleController::class, 'diaryCalendar'])->name('diary.calendar');
    Route::get('diary-create-from-date', [\App\Http\Controllers\DiaryController::class, 'createFromDate'])->name('diary.create-from-date');
});

// General Journal Routes
Route::post('/general-journal/store', [ModuleController::class, 'storeGeneralJournal'])->name('general.journal.store');
Route::post('/general-journal/process', [ModuleController::class, 'processGeneralJournal'])->name('general.journal.process');
Route::post('/general-journal/process/{id}', [ModuleController::class, 'processSingleGeneralJournal'])->name('general.journal.processSingle');
Route::put('/general-journal/update', [ModuleController::class, 'updateGeneralJournal'])->name('general.journal.update');
Route::delete('/general-journal/delete/{id}', [ModuleController::class, 'deleteGeneralJournal'])->name('general.journal.delete');

Route::get('/modules/edit/judges', [\App\Http\Controllers\JudgeController::class, 'index'])->name('modules.edit.judges.index');
Route::get('/modules/edit/judges/list', [\App\Http\Controllers\JudgeController::class, 'index'])->name('modules.edit.judges.list');
Route::get('/modules/edit/judges/create', [\App\Http\Controllers\JudgeController::class, 'create'])->name('modules.edit.judges.create');
Route::post('/modules/edit/judges', [\App\Http\Controllers\JudgeController::class, 'store'])->name('modules.edit.judges.store');
Route::get('/modules/edit/judges/{judge_code}', [\App\Http\Controllers\JudgeController::class, 'show'])->name('modules.edit.judges.show');
Route::get('/modules/edit/judges/{judge_code}/edit', [\App\Http\Controllers\JudgeController::class, 'edit'])->name('modules.edit.judges.edit');
Route::put('/modules/edit/judges/{judge_code}', [\App\Http\Controllers\JudgeController::class, 'update'])->name('modules.edit.judges.update');
Route::delete('/modules/edit/judges/{judge_code}', [\App\Http\Controllers\JudgeController::class, 'destroy'])->name('modules.edit.judges.destroy');

Route::get('/modules/edit/court-areas', [\App\Http\Controllers\CourtAreaController::class, 'index'])->name('modules.edit.court-areas');
Route::get('/modules/edit/court-areas/create', [\App\Http\Controllers\CourtAreaController::class, 'create'])->name('modules.edit.court-areas.create');
Route::post('/modules/edit/court-areas', [\App\Http\Controllers\CourtAreaController::class, 'store'])->name('modules.edit.court-areas.store');
Route::get('/modules/edit/court-areas/{area_code}', [\App\Http\Controllers\CourtAreaController::class, 'show'])->name('modules.edit.court-areas.show');
Route::get('/modules/edit/court-areas/{area_code}/edit', [\App\Http\Controllers\CourtAreaController::class, 'edit'])->name('modules.edit.court-areas.edit');
Route::put('/modules/edit/court-areas/{area_code}', [\App\Http\Controllers\CourtAreaController::class, 'update'])->name('modules.edit.court-areas.update');
Route::delete('/modules/edit/court-areas/{area_code}', [\App\Http\Controllers\CourtAreaController::class, 'destroy'])->name('modules.edit.court-areas.destroy');

Route::get('/modules/edit/court-types', [\App\Http\Controllers\CourtTypeController::class, 'index'])->name('modules.edit.court-types');
Route::get('/modules/edit/court-types/create', [\App\Http\Controllers\CourtTypeController::class, 'create'])->name('modules.edit.court-types.create');
Route::post('/modules/edit/court-types', [\App\Http\Controllers\CourtTypeController::class, 'store'])->name('modules.edit.court-types.store');
Route::get('/modules/edit/court-types/{type_name}', [\App\Http\Controllers\CourtTypeController::class, 'show'])->name('modules.edit.court-types.show');
Route::get('/modules/edit/court-types/{type_name}/edit', [\App\Http\Controllers\CourtTypeController::class, 'edit'])->name('modules.edit.court-types.edit');
Route::put('/modules/edit/court-types/{type_name}', [\App\Http\Controllers\CourtTypeController::class, 'update'])->name('modules.edit.court-types.update');
Route::delete('/modules/edit/court-types/{type_name}', [\App\Http\Controllers\CourtTypeController::class, 'destroy'])->name('modules.edit.court-types.destroy');

Route::get('/modules/edit/court-details', [ModuleController::class, 'courtDetails'])->name('modules.edit.court-details');
Route::get('/modules/edit/judgements', [\App\Http\Controllers\JudgementController::class, 'index'])->name('modules.edit.judgements');
Route::get('/modules/edit/judgements/index', [\App\Http\Controllers\JudgementController::class, 'index'])->name('modules.edit.judgements.index');
Route::get('/modules/edit/judgements/create', [\App\Http\Controllers\JudgementController::class, 'create'])->name('modules.edit.judgements.create');
Route::post('/modules/edit/judgements', [\App\Http\Controllers\JudgementController::class, 'store'])->name('modules.edit.judgements.store');
Route::get('/modules/edit/judgements/{judgement_code}', [\App\Http\Controllers\JudgementController::class, 'show'])->name('modules.edit.judgements.show');
Route::get('/modules/edit/judgements/{judgement_code}/edit', [\App\Http\Controllers\JudgementController::class, 'edit'])->name('modules.edit.judgements.edit');
Route::put('/modules/edit/judgements/{judgement_code}', [\App\Http\Controllers\JudgementController::class, 'update'])->name('modules.edit.judgements.update');
Route::delete('/modules/edit/judgements/{judgement_code}', [\App\Http\Controllers\JudgementController::class, 'destroy'])->name('modules.edit.judgements.destroy');
});





