

<?php $__env->startSection('page-title', 'Login - Prolex Legal System'); ?>

<?php $__env->startSection('content'); ?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Cinzel:wght@400;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
<div class="auth-container">
    <!-- Left Panel - Branding -->
    <div class="auth-branding-panel">
        <div class="branding-content">
            <div class="logo-container">
                <i class="fas fa-balance-scale logo-icon"></i>
            </div>
            <h1 class="brand-title">Prolex Legal System</h1>
            <p class="brand-tagline">Secure Legal Management Platform</p>
            
            <div class="brand-features">
                <div class="feature-item">
                    <i class="fas fa-shield-alt"></i>
                    <span>Bank-Level Security</span>
                </div>
                <div class="feature-item">
                    <i class="fas fa-bolt"></i>
                    <span>Real-time Updates</span>
                </div>
                <div class="feature-item">
                    <i class="fas fa-chart-line"></i>
                    <span>Case Analytics</span>
                </div>
            </div>

            <!-- Social Media Links -->
            <div class="social-links">
                <a href="https://www.facebook.com/people/Melsoft-Zimbabwe/100072059177475" target="_blank" class="social-link" aria-label="Facebook">
                    <i class="fab fa-facebook-f"></i>
                </a>
                <a href="https://www.instagram.com/melsofttech?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" class="social-link" aria-label="Instagram">
                    <i class="fab fa-instagram"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- Right Panel - Login Form -->
    <div class="auth-form-panel">
        <div class="auth-form-wrapper">
            <div class="text-center mb-4">
                <img src="https://melsoftzim.co.zw/assets/uploads/logo.jpeg" alt="Melsoft Logo" class="mb-3" style="height: 80px;">
                <h1 class="display-4 fw-bold text-primary" style="font-family: 'Cinzel', serif;">
                    PROLEX
                </h1>
                <p class="text-muted">Law Firm Management System</p>
            </div>
            <div class="form-header">
                <h2 class="h4 fw-bold text-center mb-3">Welcome Back</h2>
                <p class="text-muted text-center mb-4">Sign in to your legal workspace</p>
            </div>

            <?php if(session('status')): ?>
                <div class="alert alert-success fade-in">
                    <div class="alert-icon">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <div class="alert-content">
                        <strong>Success!</strong>
                        <p><?php echo e(session('status')); ?></p>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($errors->any()): ?>
                <div class="alert alert-danger fade-in">
                    <div class="alert-icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <div class="alert-content">
                        <strong>Authentication Failed</strong>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p><?php echo e($error); ?></p>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('login')); ?>" class="login-form" id="loginForm">
                <?php echo csrf_field(); ?>

                <!-- Email Field -->
                <div class="form-group">
                    <label for="email" class="form-label">
                        <i class="fas fa-envelope"></i> Email Address
                    </label>
                    <div class="input-wrapper">
                        <input type="email"
                               class="form-input"
                               id="email"
                               name="email"
                               value="<?php echo e(old('email')); ?>"
                               placeholder="Enter your email address"
                               autocomplete="email"
                               required>
                        <i class="fas fa-user-circle input-icon"></i>
                    </div>
                </div>

                <!-- Password Field -->
                <div class="form-group">
                    <label for="password" class="form-label">
                        <i class="fas fa-lock"></i> Password
                    </label>
                    <div class="input-wrapper">
                        <input type="password"
                               class="form-input"
                               id="password"
                               name="password"
                               placeholder="Enter your password"
                               autocomplete="current-password"
                               required>
                        <i class="fas fa-key input-icon"></i>
                        <button type="button" class="password-toggle" id="togglePassword" aria-label="Toggle password visibility">
                            <i class="fas fa-eye" id="toggleIcon"></i>
                        </button>
                    </div>
                </div>

                <!-- Remember & Forgot -->
                <div class="form-options">
                    <div class="remember-me">
                        <label class="checkbox-container">
                            <input type="checkbox" name="remember" id="remember">
                            <span class="checkmark"></span>
                            <span class="checkbox-label">Remember this device</span>
                        </label>
                    </div>
                    <a href="<?php echo e(route('password.request')); ?>" class="forgot-password">
                        <i class="fas fa-question-circle"></i> Forgot Password?
                    </a>
                </div>

                <!-- Submit Button -->
                <button type="submit" class="btn-auth-primary" id="submitBtn">
                    <span class="btn-text">Sign In</span>
                    <i class="fas fa-arrow-right btn-icon"></i>
                </button>
            </form>

            <!-- Security Footer -->
            <div class="security-footer">
                <div class="security-badge">
                    <i class="fas fa-shield-check"></i>
                    <span>Protected by 256-bit SSL Encryption</span>
                </div>
                <div class="legal-links">
                    <a href="<?php echo e(url('/privacy')); ?>"><i class="fas fa-user-shield"></i> Privacy Policy</a>
                    <a href="<?php echo e(url('/terms')); ?>"><i class="fas fa-file-contract"></i> Terms of Service</a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
:root {
    --primary-color: #87CEEB;
    --secondary-color: #87CEEB;
    --accent-color: #e74c3c;
    --success-color: #27ae60;
    --warning-color: #f39c12;
    --light-bg: #f8f9fa;
    --dark-text: #2c3e50;
    --light-text: #7f8c8d;
    --border-color: #e0e6ed;
}

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background-color: #f8f9fa;
    overflow-x: hidden;
}

.auth-container {
    display: flex;
    min-height: 100vh;
    width: 100%;
    max-width: 968px;
    margin: 0 auto;
}

/* Left Panel Styles */
.auth-branding-panel {
    flex: 0 0 32%;
    background: linear-gradient(135deg, var(--primary-color) 0%, #b0c4de 100%);
    color: #1a1a1a;
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 1.51rem 1.26rem;
    overflow: hidden;
}

.auth-branding-panel::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 100%;
    height: 300%;
    background: radial-gradient(circle, rgba(0,0,0,0.05) 1px, transparent 1px);
    background-size: 50px 50px;
    animation: float 20s linear infinite;
    pointer-events: none;
}

@keyframes float {
    0% { transform: translate(0, 0) rotate(0deg); }
    100% { transform: translate(-50px, -50px) rotate(360deg); }
}

.branding-content {
    max-width: 100%;
    width: 100%;
    z-index: 1;
    text-align: center;
    position: relative;
}

.logo-container {
    width: 150px;
    height: 150px;
    margin: 0 auto 2rem;
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    backdrop-filter: blur(10px);
}

.logo-icon {
    font-size: 4.5rem;
    color: #1a1a1a;
}

.brand-title {
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 0.75rem;
    color: #1a1a1a;
    text-shadow: 2px 2px 4px rgba(255,255,255,0.3);
    font-family: 'Cinzel', serif;
    line-height: 1.2;
}

.brand-tagline {
    font-size: 1.1rem;
    color: rgba(0,0,0,0.7);
    margin-bottom: 2.5rem;
    font-weight: 500;
}

.brand-features {
    display: flex;
    flex-direction: column;
    gap: 1rem;
    margin-bottom: 2.5rem;
}

.feature-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem 1.25rem;
    background: rgba(255,255,255,0.2);
    border-radius: 10px;
    backdrop-filter: blur(10px);
    transition: transform 0.3s ease, background 0.3s ease;
}

.feature-item:hover {
    transform: translateX(10px);
    background: rgba(255,255,255,0.3);
}

.feature-item i {
    font-size: 1.2rem;
    color: #1a1a1a;
}

.feature-item span {
    color: #1a1a1a;
    font-weight: 500;
    font-size: 1rem;
}

.social-links {
    display: flex;
    justify-content: center;
    gap: 1.25rem;
    margin-top: 2rem;
}

.social-link {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    background: rgba(255,255,255,0.2);
    display: flex;
    align-items: center;
    justify-content: center;
    color: #1a1a1a;
    text-decoration: none;
    transition: all 0.3s ease;
    font-size: 1.1rem;
}

.social-link:hover {
    background: rgba(255,255,255,0.35);
    transform: translateY(-3px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

/* Right Panel Styles */
.auth-form-panel {
    flex: 0 0 68%;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 1.77rem;
    background: #f8f9fa;
    overflow-y: auto;
}

.auth-form-wrapper {
    width: 100%;
    max-width: 378px;
    background: white;
    border: 1px solid #e0e6ed;
    border-radius: 20px;
    box-shadow: 0 8px 24px rgba(0,0,0,0.1);
    padding: 2.02rem 1.77rem;
}

.form-header {
    margin-bottom: 2.5rem;
}

/* Alert Styles */
.alert {
    padding: 1.25rem 1.5rem;
    border-radius: 12px;
    margin-bottom: 2rem;
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    animation: fadeIn 0.5s ease;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

.alert-success {
    background: linear-gradient(135deg, #d4edda, #c3e6cb);
    border-left: 4px solid var(--success-color);
    color: #155724;
}

.alert-danger {
    background: linear-gradient(135deg, #f8d7da, #f5c6cb);
    border-left: 4px solid var(--accent-color);
    color: #721c24;
}

.alert-icon {
    font-size: 1.5rem;
}

.alert-content {
    flex: 1;
}

.alert-content strong {
    display: block;
    margin-bottom: 0.5rem;
    font-size: 1rem;
}

.alert-content p {
    margin: 0.25rem 0 0 0;
    font-size: 0.95rem;
}

/* Form Styles */
.login-form {
    width: 100%;
}

.form-group {
    margin-bottom: 2rem;
}

.form-label {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-size: 1rem;
    font-weight: 600;
    color: var(--dark-text);
    margin-bottom: 0.75rem;
}

.input-wrapper {
    position: relative;
    display: flex;
    align-items: center;
}

.input-icon {
    position: absolute;
    left: 1.25rem;
    color: var(--light-text);
    transition: color 0.3s ease;
    z-index: 1;
    pointer-events: none;
    font-size: 1.1rem;
}

.form-input {
    width: 100%;
    padding: 1.25rem 1.25rem 1.25rem 3.5rem;
    border: 2px solid var(--border-color);
    border-radius: 12px;
    font-size: 1.05rem;
    transition: all 0.3s ease;
    background: var(--light-bg);
}

.form-input:focus {
    outline: none;
    border-color: #87ceeb;
    background: white;
    box-shadow: 0 0 0 4px rgba(135,206,235,0.15);
}

.form-input:focus ~ .input-icon {
    color: var(--secondary-color);
}

.password-toggle {
    position: absolute;
    right: 1.25rem;
    background: none;
    border: none;
    color: var(--light-text);
    cursor: pointer;
    padding: 0.5rem;
    transition: color 0.3s ease;
    z-index: 2;
    font-size: 1.1rem;
}

.password-toggle:hover {
    color: var(--secondary-color);
}

.password-toggle:focus {
    outline: 2px solid var(--secondary-color);
    outline-offset: 2px;
    border-radius: 4px;
}

/* Form Options */
.form-options {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 2.25rem;
}

.checkbox-container {
    display: block;
    position: relative;
    padding-left: 2.25rem;
    cursor: pointer;
    user-select: none;
}

.checkbox-container input {
    position: absolute;
    opacity: 0;
    cursor: pointer;
    height: 0;
    width: 0;
}

.checkmark {
    position: absolute;
    top: 0;
    left: 0;
    height: 22px;
    width: 22px;
    background: var(--light-bg);
    border: 2px solid var(--border-color);
    border-radius: 5px;
    transition: all 0.3s ease;
}

.checkbox-container:hover input ~ .checkmark {
    border-color: var(--secondary-color);
}

.checkbox-container input:checked ~ .checkmark {
    background: var(--secondary-color);
    border-color: var(--secondary-color);
}

.checkmark:after {
    content: "";
    position: absolute;
    display: none;
    left: 7px;
    top: 3px;
    width: 5px;
    height: 10px;
    border: solid white;
    border-width: 0 2.5px 2.5px 0;
    transform: rotate(45deg);
}

.checkbox-container input:checked ~ .checkmark:after {
    display: block;
}

.checkbox-label {
    font-size: 0.95rem;
    color: var(--dark-text);
}

.forgot-password {
    color: var(--secondary-color);
    text-decoration: none;
    font-size: 0.95rem;
    transition: color 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 500;
}

.forgot-password:hover {
    color: var(--primary-color);
    text-decoration: underline;
}

/* Submit Button */
.btn-auth-primary {
    width: 100%;
    padding: 1.25rem 2rem;
    background: linear-gradient(90deg, #87ceeb 0%, #00a3ff 100%);
    color: white;
    border: none;
    border-radius: 12px;
    font-size: 1.1rem;
    font-weight: 600;
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.75rem;
    transition: all 0.3s ease;
    margin-bottom: 2.5rem;
}

.btn-auth-primary:hover:not(:disabled) {
    transform: translateY(-2px);
    box-shadow: 0 12px 24px rgba(135,206,235,0.35);
    background: linear-gradient(90deg, #00a3ff 0%, #87ceeb 100%);
}

.btn-auth-primary:active:not(:disabled) {
    transform: translateY(0);
}

.btn-auth-primary:disabled {
    opacity: 0.6;
    cursor: not-allowed;
}

.btn-icon {
    transition: transform 0.3s ease;
    font-size: 1rem;
}

.btn-auth-primary:hover:not(:disabled) .btn-icon {
    transform: translateX(5px);
}

/* Security Footer */
.security-footer {
    margin-top: 2.5rem;
    padding-top: 2.5rem;
    border-top: 1px solid var(--border-color);
}

.security-badge {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 0.6rem;
    color: var(--success-color);
    font-size: 0.95rem;
    margin-bottom: 1.25rem;
}

.legal-links {
    display: flex;
    justify-content: center;
    gap: 2.5rem;
}

.legal-links a {
    color: var(--light-text);
    text-decoration: none;
    font-size: 0.9rem;
    transition: color 0.3s ease;
    display: flex;
    align-items: center;
    gap: 0.5rem;
}

.legal-links a:hover {
    color: var(--secondary-color);
}

/* Responsive Design */
@media (max-width: 1400px) {
    .auth-container {
        max-width: 100%;
    }
    
    .auth-form-wrapper {
        max-width: 600px;
        padding: 3rem 2.5rem;
    }
}

@media (max-width: 1200px) {
    .auth-branding-panel {
        flex: 0 0 35%;
    }
    
    .auth-form-panel {
        flex: 0 0 65%;
    }
}

@media (max-width: 992px) {
    .auth-container {
        flex-direction: column;
    }
    
    .auth-branding-panel {
        flex: none;
        min-height: 350px;
        padding: 2.5rem 2rem;
    }
    
    .auth-form-panel {
        flex: none;
        padding: 2.5rem 2rem;
        min-height: auto;
    }

    .auth-form-wrapper {
        max-width: 600px;
    }
}

@media (max-width: 768px) {
    .auth-branding-panel {
        min-height: 300px;
        padding: 2rem 1.5rem;
    }

    .brand-title {
        font-size: 2rem;
    }

    .brand-tagline {
        font-size: 1rem;
    }

    .auth-form-panel {
        padding: 2rem 1.5rem;
    }

    .auth-form-wrapper {
        padding: 2.5rem 2rem;
    }
}

@media (max-width: 576px) {
    .auth-form-panel {
        padding: 1.5rem 1rem;
    }

    .auth-form-wrapper {
        padding: 2rem 1.5rem;
    }

    .form-options {
        flex-direction: column;
        gap: 1rem;
        align-items: flex-start;
    }

    .brand-title {
        font-size: 1.75rem;
    }

    .auth-branding-panel {
        min-height: 250px;
        padding: 1.5rem 1rem;
    }

    .logo-container {
        width: 120px;
        height: 120px;
    }

    .logo-icon {
        font-size: 3.5rem;
    }

    .brand-features {
        gap: 0.75rem;
    }

    .feature-item {
        padding: 0.75rem 1rem;
        font-size: 0.9rem;
    }
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Password toggle functionality
    const togglePassword = document.getElementById('togglePassword');
    const passwordInput = document.getElementById('password');
    const toggleIcon = document.getElementById('toggleIcon');

    if (togglePassword && passwordInput && toggleIcon) {
        togglePassword.addEventListener('click', function() {
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                toggleIcon.classList.remove('fa-eye');
                toggleIcon.classList.add('fa-eye-slash');
                togglePassword.setAttribute('aria-label', 'Hide password');
            } else {
                passwordInput.type = 'password';
                toggleIcon.classList.remove('fa-eye-slash');
                toggleIcon.classList.add('fa-eye');
                togglePassword.setAttribute('aria-label', 'Show password');
            }
        });
    }

    // Form submission handling
    const loginForm = document.getElementById('loginForm');
    const submitBtn = document.getElementById('submitBtn');

    if (loginForm && submitBtn) {
        loginForm.addEventListener('submit', function(e) {
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<span class="btn-text">Signing In...</span><i class="fas fa-spinner fa-spin btn-icon"></i>';
            
            setTimeout(function() {
                submitBtn.disabled = false;
                submitBtn.innerHTML = '<span class="btn-text">Sign In</span><i class="fas fa-arrow-right btn-icon"></i>';
            }, 3000);
        });
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\admin\Desktop\prolex\resources\views/auth/login.blade.php ENDPATH**/ ?>