

<?php $__env->startSection('title', 'Chat Options'); ?>
<?php $__env->startSection('page-title', 'Chat Options'); ?>

<?php $__env->startSection('styles'); ?>
<style>
.options-container {
    max-width: 800px;
    margin: 0 auto;
    padding: 20px;
}

.options-section {
    background: #fff;
    border-radius: 10px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.options-section h3 {
    margin-bottom: 15px;
    color: #333;
    font-size: 1.2em;
}

.form-group {
    margin-bottom: 15px;
}

.form-group label {
    display: block;
    margin-bottom: 5px;
    font-weight: 500;
}

.form-group input[type="text"],
.form-group select {
    width: 100%;
    padding: 8px 12px;
    border: 1px solid #ddd;
    border-radius: 5px;
    font-size: 14px;
}

.form-group input[type="checkbox"] {
    margin-right: 8px;
}

.btn {
    padding: 10px 20px;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 14px;
    margin-right: 10px;
}

.btn-primary {
    background: #007bff;
    color: white;
}

.btn-success {
    background: #28a745;
    color: white;
}

.btn-danger {
    background: #dc3545;
    color: white;
}

.btn-sm {
    padding: 5px 10px;
    font-size: 12px;
}

.back-link {
    display: inline-block;
    margin-bottom: 20px;
    color: #007bff;
    text-decoration: none;
    font-weight: 500;
}

.back-link:hover {
    text-decoration: underline;
}

.notification {
    padding: 10px;
    margin-bottom: 10px;
    border-radius: 5px;
}

.success {
    background: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
}

.error {
    background: #f8d7da;
    color: #721c24;
    border: 1px solid #f5c6cb;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="options-container">
    <a href="<?php echo e(route('chat.room')); ?>" class="back-link">&larr; Back to Chat Room</a>

    <div class="options-section">
        <h3>Settings</h3>
        <form id="settingsForm">
            <div class="form-group">
                <label>
                    <input type="checkbox" id="soundNotifications" checked> Enable sound notifications
                </label>
            </div>
            <div class="form-group">
                <label>
                    <input type="checkbox" id="autoScroll" checked> Auto-scroll to new messages
                </label>
            </div>
            <div class="form-group">
                <label>
                    <input type="checkbox" id="showTyping" checked> Show typing indicators
                </label>
            </div>
            <button type="submit" class="btn btn-primary">Save Settings</button>
        </form>
    </div>

    <div class="options-section">
        <h3>Send Request</h3>
        <form id="sendRequestForm">
            <div class="form-group">
                <label for="contactName">Contact Name:</label>
                <input type="text" id="contactName" placeholder="Enter contact name..." required>
            </div>
            <button type="submit" class="btn btn-primary">Send Request</button>
        </form>
    </div>

    <div class="options-section">
        <h3>Create Group</h3>
        <form id="createGroupForm">
            <div class="form-group">
                <label for="groupName">Group Name:</label>
                <input type="text" id="groupName" placeholder="Enter group name..." required>
            </div>
            <div class="form-group">
                <label for="memberSearch">Search Members:</label>
                <input type="text" id="memberSearch" placeholder="Search for members...">
            </div>
            <div class="form-group">
                <label>Available Members:</label>
                <div id="availableMembers" style="max-height: 150px; overflow-y: auto; border: 1px solid #ddd; border-radius: 5px; padding: 10px;">
                    <!-- Members will be listed here -->
                </div>
            </div>
            <div class="form-group">
                <label>Selected Members:</label>
                <div id="selectedMembers" style="min-height: 50px; border: 1px solid #ddd; border-radius: 5px; padding: 10px; background: #f9f9f9;">
                    <!-- Selected members will be shown here -->
                </div>
            </div>
            <button type="submit" class="btn btn-primary">Create Group</button>
        </form>
    </div>

    <div id="notificationArea"></div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', () => {
    const settingsForm = document.getElementById('settingsForm');
    const sendRequestForm = document.getElementById('sendRequestForm');
    const createGroupForm = document.getElementById('createGroupForm');
    const notificationArea = document.getElementById('notificationArea');

    function showNotification(message, type = 'success') {
        const notification = document.createElement('div');
        notification.className = `notification ${type}`;
        notification.textContent = message;
        notificationArea.appendChild(notification);
        setTimeout(() => {
            notification.remove();
        }, 5000);
    }

    settingsForm.addEventListener('submit', (e) => {
        e.preventDefault();
        // In a real app, you'd send this to the server
        showNotification('Settings saved successfully!');
    });

    sendRequestForm.addEventListener('submit', (e) => {
        e.preventDefault();
        const contactName = document.getElementById('contactName').value.trim();
        if (contactName) {
            // In a real app, you'd send this to the server
            showNotification(`Request sent: "Request to chat with ${contactName}"`);
            document.getElementById('contactName').value = '';
        }
    });

    // Available members list
    const availableMembersList = ['Jeff Reynolds', 'Henry Clarke', 'Anna Byrne'];
    let selectedMembers = [];

    const memberSearch = document.getElementById('memberSearch');
    const availableMembersDiv = document.getElementById('availableMembers');
    const selectedMembersDiv = document.getElementById('selectedMembers');

    function renderAvailableMembers(filter = '') {
        availableMembersDiv.innerHTML = '';
        const filtered = availableMembersList.filter(member =>
            member.toLowerCase().includes(filter.toLowerCase()) && !selectedMembers.includes(member)
        );
        filtered.forEach(member => {
            const memberDiv = document.createElement('div');
            memberDiv.style.display = 'flex';
            memberDiv.style.justifyContent = 'space-between';
            memberDiv.style.alignItems = 'center';
            memberDiv.style.padding = '5px 0';
            memberDiv.innerHTML = `
                <span>${member}</span>
                <button type="button" class="btn btn-primary btn-sm add-member-btn" data-member="${member}">Add</button>
            `;
            availableMembersDiv.appendChild(memberDiv);
        });
        // Add event listeners to add buttons
        document.querySelectorAll('.add-member-btn').forEach(btn => {
            btn.addEventListener('click', (e) => {
                const member = e.target.dataset.member;
                selectedMembers.push(member);
                renderAvailableMembers(memberSearch.value);
                renderSelectedMembers();
            });
        });
    }

    function renderSelectedMembers() {
        selectedMembersDiv.innerHTML = '';
        if (selectedMembers.length === 0) {
            selectedMembersDiv.innerHTML = '<em>No members selected</em>';
        } else {
            selectedMembers.forEach(member => {
                const memberDiv = document.createElement('div');
                memberDiv.style.display = 'flex';
                memberDiv.style.justifyContent = 'space-between';
                memberDiv.style.alignItems = 'center';
                memberDiv.style.padding = '5px 0';
                memberDiv.innerHTML = `
                    <span>${member}</span>
                    <button type="button" class="btn btn-danger btn-sm remove-member-btn" data-member="${member}">Remove</button>
                `;
                selectedMembersDiv.appendChild(memberDiv);
            });
            // Add event listeners to remove buttons
            document.querySelectorAll('.remove-member-btn').forEach(btn => {
                btn.addEventListener('click', (e) => {
                    const member = e.target.dataset.member;
                    selectedMembers = selectedMembers.filter(m => m !== member);
                    renderAvailableMembers(memberSearch.value);
                    renderSelectedMembers();
                });
            });
        }
    }

    memberSearch.addEventListener('input', (e) => {
        renderAvailableMembers(e.target.value);
    });

    createGroupForm.addEventListener('submit', (e) => {
        e.preventDefault();
        const name = document.getElementById('groupName').value.trim();
        if (name && selectedMembers.length > 0) {
            // In a real app, you'd send this to the server
            showNotification(`Group "${name}" created with members: ${selectedMembers.join(', ')}`);
            document.getElementById('groupName').value = '';
            selectedMembers = [];
            renderAvailableMembers();
            renderSelectedMembers();
        } else {
            showNotification('Please enter a group name and select at least one member.', 'error');
        }
    });

    // Initial render
    renderAvailableMembers();
    renderSelectedMembers();
});
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\admin\Desktop\prolex\resources\views/chat/options.blade.php ENDPATH**/ ?>