

<?php $__env->startSection('title', 'Loading'); ?>
<?php $__env->startSection('page-title', 'Loading'); ?>

<?php $__env->startSection('styles'); ?>
<style>
  body {
    margin: 0;
    height: 100vh;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #eaf4ff 0%, #c2e0ff 100%);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: #003366;
    overflow: hidden;
  }

  .loading-container {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    position: relative;
  }

  .lock-container {
    position: relative;
    width: 120px;
    height: 150px;
    margin-bottom: 30px;
  }

  /* Enhanced lock body */
  .lock-body {
    width: 120px;
    height: 80px;
    background: linear-gradient(to bottom, #007bff, #0056b3);
    border-radius: 15px;
    position: absolute;
    bottom: 0;
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2), 
                inset 0 -4px 10px rgba(0, 0, 0, 0.1),
                inset 0 4px 10px rgba(255, 255, 255, 0.3);
    z-index: 2;
    animation: lockPulse 2s infinite ease-in-out;
  }

  /* Enhanced shackle animation */
  .lock-shackle {
    width: 70px;
    height: 70px;
    border: 8px solid #007bff;
    border-bottom: none;
    border-radius: 40px 40px 0 0;
    position: absolute;
    left: 25px;
    top: -80px;
    background: transparent;
    z-index: 1;
    animation: shackleDown 2.5s ease-in-out forwards;
  }

  /* Keyhole detail */
  .keyhole {
    position: absolute;
    width: 20px;
    height: 30px;
    background: #003366;
    border-radius: 10px;
    top: 25px;
    left: 50px;
    z-index: 3;
  }

  .keyhole::after {
    content: '';
    position: absolute;
    width: 12px;
    height: 12px;
    background: #003366;
    border-radius: 50%;
    top: -8px;
    left: 4px;
  }

  /* Security shield */
  .security-shield {
    position: absolute;
    width: 100px;
    height: 120px;
    top: -20px;
    left: 10px;
    opacity: 0;
    animation: shieldAppear 3s ease-in-out forwards;
    z-index: 0;
  }

  .shield-body {
    width: 100px;
    height: 120px;
    background: rgba(255, 255, 255, 0.7);
    clip-path: polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);
    position: absolute;
    top: 0;
    left: 0;
  }

  .shield-inner {
    width: 80px;
    height: 100px;
    background: rgba(255, 255, 255, 0.9);
    clip-path: polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%);
    position: absolute;
    top: 10px;
    left: 10px;
  }

  /* Enhanced text styling */
  .text {
    margin-top: 30px;
    font-size: 1.8rem;
    font-weight: 700;
    letter-spacing: 1.5px;
    text-align: center;
    opacity: 0;
    animation: fadeIn 2.5s ease-in forwards;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
  }

  .subtext {
    margin-top: 10px;
    font-size: 1rem;
    font-weight: 400;
    opacity: 0;
    animation: fadeIn 3s ease-in forwards;
    color: #0056b3;
  }

  /* Loading dots */
  .loading-dots {
    display: flex;
    margin-top: 20px;
    opacity: 0;
    animation: fadeIn 3.5s ease-in forwards;
  }

  .dot {
    width: 10px;
    height: 10px;
    background: #007bff;
    border-radius: 50%;
    margin: 0 5px;
    animation: dotPulse 1.5s infinite ease-in-out;
  }

  .dot:nth-child(2) {
    animation-delay: 0.2s;
  }

  .dot:nth-child(3) {
    animation-delay: 0.4s;
  }

  /* Enhanced animations */
  @keyframes shackleDown {
    0% { top: -80px; opacity: 0; transform: rotate(0deg); }
    20% { top: -60px; opacity: 1; transform: rotate(5deg); }
    40% { top: -40px; transform: rotate(-3deg); }
    60% { top: -20px; transform: rotate(2deg); }
    80% { top: -5px; transform: rotate(-1deg); }
    100% { top: 0px; transform: rotate(0deg); }
  }

  @keyframes lockPulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.02); }
  }

  @keyframes shieldAppear {
    0% { opacity: 0; transform: scale(0.8); }
    70% { opacity: 0; transform: scale(0.8); }
    100% { opacity: 1; transform: scale(1); }
  }

  @keyframes fadeIn {
    0% { opacity: 0; transform: translateY(10px); }
    100% { opacity: 1; transform: translateY(0); }
  }

  @keyframes dotPulse {
    0%, 100% { transform: scale(1); opacity: 0.7; }
    50% { transform: scale(1.3); opacity: 1; }
  }

  .fade-out {
    animation: fadeOut 0.8s ease-in forwards;
  }

  @keyframes fadeOut {
    from { opacity: 1; transform: scale(1); }
    to { opacity: 0; transform: scale(1.05); }
  }

  /* Particles background */
  .particles {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: -1;
  }

  .particle {
    position: absolute;
    width: 4px;
    height: 4px;
    background: rgba(0, 123, 255, 0.3);
    border-radius: 50%;
    animation: float 15s infinite linear;
  }

  @keyframes float {
    0% { transform: translateY(100vh) translateX(0); opacity: 0; }
    10% { opacity: 1; }
    90% { opacity: 1; }
    100% { transform: translateY(-100px) translateX(20px); opacity: 0; }
  }

  /* Maintain Laravel layout compatibility */
  .main-content, .app-page-content {
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    height: 100vh !important;
    padding: 0 !important;
  }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="particles" id="particles"></div>

<div class="loading-container">
  <div class="lock-container">
    <div class="security-shield">
      <div class="shield-body"></div>
      <div class="shield-inner"></div>
    </div>
    <div class="lock-shackle"></div>
    <div class="lock-body"></div>
    <div class="keyhole"></div>
  </div>
  
  <div class="text">Prolex Secure Chat</div>
  <div class="subtext">Initializing secure connection...</div>
  
  <div class="loading-dots">
    <div class="dot"></div>
    <div class="dot"></div>
    <div class="dot"></div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
  // Create floating particles
  function createParticles() {
    const particlesContainer = document.getElementById('particles');
    const particleCount = 30;
    
    for (let i = 0; i < particleCount; i++) {
      const particle = document.createElement('div');
      particle.classList.add('particle');
      
      // Random position and animation delay
      const left = Math.random() * 100;
      const delay = Math.random() * 15;
      const duration = 10 + Math.random() * 10;
      
      particle.style.left = `${left}vw`;
      particle.style.animationDelay = `${delay}s`;
      particle.style.animationDuration = `${duration}s`;
      
      particlesContainer.appendChild(particle);
    }
  }
  
  // After 4 seconds, fade out and go to next page (keeping your Laravel route)
  setTimeout(() => {
    document.body.classList.add('fade-out');
    setTimeout(() => {
      window.location.href = '<?php echo e(route("chat.room")); ?>'; // redirect after animation
    }, 800);
  }, 4000);
  
  // Initialize particles when page loads
  document.addEventListener('DOMContentLoaded', createParticles);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\admin\Desktop\prolex\resources\views/loading.blade.php ENDPATH**/ ?>