

<?php $__env->startSection('title', 'Administration Menu - Prolex Law Firm'); ?>

<?php $__env->startSection('content'); ?>
<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    .admin-container {
        min-height: 100vh;
        background: linear-gradient(135deg, #f8fafc 0%, #e0f2fe 100%);
        padding: 2rem 1.5rem;
    }

    .admin-header {
        max-width: 1200px;
        margin: 0 auto 3rem;
        text-align: center;
    }

    .admin-header h1 {
        font-size: 2.5rem;
        color: #1f2937;
        margin-bottom: 0.5rem;
        font-weight: bold;
    }

    .admin-header p {
        color: #6b7280;
        font-size: 1.125rem;
    }

    .services-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
        gap: 1.5rem;
        max-width: 1200px;
        margin: 0 auto;
    }

    .service-card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        overflow: hidden;
        cursor: pointer;
        transition: all 0.3s ease;
        position: relative;
        text-decoration: none;
        display: block;
    }

    .service-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 20px 25px rgba(0,0,0,0.15);
    }

    .card-header {
        height: 8px;
        background: linear-gradient(90deg, #2563eb, #1d4ed8);
    }

    .card-header.color-purple {
        background: linear-gradient(90deg, #8b5cf6, #7c3aed);
    }

    .card-content {
        padding: 1.5rem;
    }

    .card-top {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 1rem;
    }

    .icon-wrapper {
        padding: 0.75rem;
        border-radius: 8px;
        background: linear-gradient(135deg, #2563eb, #1d4ed8);
        transition: transform 0.3s ease;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .icon-wrapper.purple-bg {
        background: linear-gradient(135deg, #8b5cf6, #7c3aed);
    }

    .service-card:hover .icon-wrapper {
        transform: scale(1.1);
    }

    .card-icon {
        font-size: 2rem;
        color: white;
    }

    .arrow-icon {
        width: 24px;
        height: 24px;
        fill: #2563eb;
        transition: transform 0.3s ease;
    }

    .arrow-icon.purple-arrow {
        fill: #8b5cf6;
    }

    .service-card:hover .arrow-icon {
        transform: translateX(4px);
    }

    .card-title {
        font-size: 1.25rem;
        font-weight: bold;
        color: #1f2937;
        margin-bottom: 0.5rem;
    }

    .card-description {
        color: #6b7280;
        line-height: 1.6;
    }

    .learn-more {
        margin-top: 1rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        color: #2563eb;
        font-weight: 600;
        opacity: 0;
        transition: all 0.3s ease;
    }

    .learn-more.purple-text {
        color: #8b5cf6;
    }

    .service-card:hover .learn-more {
        opacity: 1;
    }

    .learn-more svg {
        width: 16px;
        height: 16px;
        fill: #2563eb;
    }

    .learn-more.purple-text svg {
        fill: #8b5cf6;
    }

    .card-footer {
        height: 4px;
        background: linear-gradient(90deg, #2563eb, #1d4ed8);
        width: 0;
        transition: width 0.3s ease;
    }

    .card-footer.purple-footer {
        background: linear-gradient(90deg, #8b5cf6, #7c3aed);
    }

    .service-card:hover .card-footer {
        width: 100%;
    }

    @media (max-width: 768px) {
        .admin-header h1 {
            font-size: 1.875rem;
        }
        .services-grid {
            grid-template-columns: 1fr;
        }
    }
</style>

<div class="admin-container">
    <div class="admin-header">
        <h1>Administration Menu</h1>
        <p>Manage your law firm's settings and configurations</p>
    </div>

    <div class="services-grid">
        <!-- General Settings -->
        <a href="<?php echo e(route('administration.general-settings')); ?>" class="service-card">
            <div class="card-header"></div>
            <div class="card-content">
                <div class="card-top">
                    <div class="icon-wrapper">
                        <i class="fas fa-cog card-icon"></i>
                    </div>
                    <svg class="arrow-icon" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
                <h3 class="card-title">General Settings</h3>
                <p class="card-description">Configure system-wide settings, preferences, and global configurations for your firm</p>
                <div class="learn-more">
                    Manage Settings
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
            </div>
            <div class="card-footer"></div>
        </a>

        <!-- User Settings -->
        <a href="<?php echo e(route('administration.user-settings')); ?>" class="service-card">
            <div class="card-header color-purple"></div>
            <div class="card-content">
                <div class="card-top">
                    <div class="icon-wrapper purple-bg">
                        <i class="fas fa-user card-icon"></i>
                    </div>
                    <svg class="arrow-icon purple-arrow" viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
                <h3 class="card-title">User Settings</h3>
                <p class="card-description">Manage user accounts, permissions, roles, and access controls for staff members</p>
                <div class="learn-more purple-text">
                    Manage Users
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9 6L15 12L9 18"></path>
                    </svg>
                </div>
            </div>
            <div class="card-footer purple-footer"></div>
        </a>
    </div>
</div>

<script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\admin\Desktop\prolex\resources\views/modules/administration.blade.php ENDPATH**/ ?>