

<?php $__env->startSection('title', 'Admin Approvals - Prolex Law Firm System'); ?>

<?php $__env->startSection('page-title', 'Admin Approvals'); ?>

<?php $__env->startSection('content'); ?>
<style>
/* Professional color palette for law firm */
:root {
    --primary-blue: #1e40af;
    --secondary-blue: #3b82f6;
    --accent-blue: #60a5fa;
    --dark-blue: #1e3a8a;
    --light-gray: #f8fafc;
    --medium-gray: #e2e8f0;
    --dark-gray: #475569;
    --success-green: #10b981;
    --warning-orange: #f59e0b;
    --danger-red: #ef4444;
    --text-primary: #1e293b;
    --text-secondary: #64748b;
    --border-color: #e2e8f0;
    --shadow: 0 1px 3px rgba(0, 0, 0, 0.1), 0 1px 2px rgba(0, 0, 0, 0.06);
    --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
}

.approvals-dashboard {
    background-color: var(--light-gray);
    min-height: 100vh;
    padding: 2rem 0;
}

.dashboard-header {
    background: linear-gradient(135deg, var(--primary-blue) 0%, var(--secondary-blue) 100%);
    color: white;
    padding: 2rem;
    border-radius: 12px;
    margin-bottom: 2rem;
    box-shadow: var(--shadow-lg);
}

.dashboard-stats {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.stat-card {
    background: white;
    padding: 1.5rem;
    border-radius: 12px;
    box-shadow: var(--shadow);
    border-left: 4px solid var(--primary-blue);
    transition: transform 0.2s ease, box-shadow 0.2s ease;
}

.stat-card:hover {
    transform: translateY(-2px);
    box-shadow: var(--shadow-lg);
}

.stat-number {
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--primary-blue);
    margin-bottom: 0.5rem;
}

.stat-label {
    color: var(--text-secondary);
    font-size: 0.875rem;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.filters-section {
    background: white;
    padding: 1.5rem;
    border-radius: 12px;
    box-shadow: var(--shadow);
    margin-bottom: 2rem;
}

.filters-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
    align-items: end;
}

.filter-group {
    display: flex;
    flex-direction: column;
}

.filter-label {
    font-size: 0.875rem;
    font-weight: 500;
    color: var(--text-primary);
    margin-bottom: 0.5rem;
}

.filter-select, .filter-input {
    padding: 0.75rem;
    border: 1px solid var(--border-color);
    border-radius: 8px;
    font-size: 0.875rem;
    transition: border-color 0.2s ease, box-shadow 0.2s ease;
}

.filter-select:focus, .filter-input:focus {
    outline: none;
    border-color: var(--secondary-blue);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

.approvals-table-container {
    background: white;
    border-radius: 12px;
    box-shadow: var(--shadow);
    overflow: hidden;
}

.approvals-table {
    width: 100%;
    border-collapse: collapse;
}

.approvals-table th {
    background-color: var(--light-gray);
    padding: 1rem;
    text-align: left;
    font-weight: 600;
    color: var(--text-primary);
    border-bottom: 1px solid var(--border-color);
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.approvals-table td {
    padding: 1rem;
    border-bottom: 1px solid var(--medium-gray);
    vertical-align: middle;
}

.approval-row {
    transition: background-color 0.2s ease;
}

.approval-row:hover {
    background-color: var(--light-gray);
}

.priority-high {
    border-left: 4px solid var(--danger-red);
}

.priority-medium {
    border-left: 4px solid var(--warning-orange);
}

.priority-low {
    border-left: 4px solid var(--success-green);
}

.user-info {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.user-avatar {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: linear-gradient(135deg, var(--secondary-blue) 0%, var(--accent-blue) 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 600;
    font-size: 0.875rem;
}

.user-details h6 {
    margin: 0;
    font-size: 0.875rem;
    font-weight: 600;
    color: var(--text-primary);
}

.user-details small {
    color: var(--text-secondary);
    font-size: 0.75rem;
}

.request-type {
    display: inline-block;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.75rem;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.type-client-onboarding {
    background-color: rgba(16, 185, 129, 0.1);
    color: var(--success-green);
}

.type-case-assignment {
    background-color: rgba(245, 158, 11, 0.1);
    color: var(--warning-orange);
}

.type-billing {
    background-color: rgba(59, 130, 246, 0.1);
    color: var(--secondary-blue);
}

.type-document {
    background-color: rgba(139, 92, 246, 0.1);
    color: #8b5cf6;
}

.attachments {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.attachment {
    display: flex;
    align-items: center;
    gap: 0.25rem;
    padding: 0.25rem 0.5rem;
    background-color: var(--light-gray);
    border-radius: 6px;
    font-size: 0.75rem;
    color: var(--text-secondary);
}

.action-buttons {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.btn-approve {
    background-color: var(--success-green);
    color: white;
    border: none;
    padding: 0.5rem 1rem;
    border-radius: 6px;
    font-size: 0.875rem;
    font-weight: 500;
    cursor: pointer;
    transition: background-color 0.2s ease;
}

.btn-approve:hover {
    background-color: #059669;
}

.btn-decline {
    background-color: var(--danger-red);
    color: white;
    border: none;
    padding: 0.5rem 1rem;
    border-radius: 6px;
    font-size: 0.875rem;
    font-weight: 500;
    cursor: pointer;
    transition: background-color 0.2s ease;
}

.btn-decline:hover {
    background-color: #dc2626;
}

.btn-request-changes {
    background-color: var(--warning-orange);
    color: white;
    border: none;
    padding: 0.5rem 1rem;
    border-radius: 6px;
    font-size: 0.875rem;
    font-weight: 500;
    cursor: pointer;
    transition: background-color 0.2s ease;
}

.btn-request-changes:hover {
    background-color: #d97706;
}

.notifications-panel {
    background: white;
    padding: 1.5rem;
    border-radius: 12px;
    box-shadow: var(--shadow);
    margin-bottom: 2rem;
}

.notifications-header {
    display: flex;
    justify-content: between;
    align-items: center;
    margin-bottom: 1rem;
}

.notifications-list {
    max-height: 300px;
    overflow-y: auto;
}

.notification-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1rem;
    border-bottom: 1px solid var(--medium-gray);
    transition: background-color 0.2s ease;
}

.notification-item:hover {
    background-color: var(--light-gray);
}

.notification-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1rem;
}

.notification-icon.success {
    background-color: rgba(16, 185, 129, 0.1);
    color: var(--success-green);
}

.notification-icon.warning {
    background-color: rgba(245, 158, 11, 0.1);
    color: var(--warning-orange);
}

.notification-content h6 {
    margin: 0;
    font-size: 0.875rem;
    font-weight: 600;
    color: var(--text-primary);
}

.notification-content small {
    color: var(--text-secondary);
    font-size: 0.75rem;
}

.audit-log {
    background: white;
    padding: 1.5rem;
    border-radius: 12px;
    box-shadow: var(--shadow);
}

.audit-log-header {
    display: flex;
    justify-content: between;
    align-items: center;
    margin-bottom: 1rem;
}

.audit-table {
    width: 100%;
    border-collapse: collapse;
}

.audit-table th, .audit-table td {
    padding: 0.75rem;
    text-align: left;
    border-bottom: 1px solid var(--medium-gray);
}

.audit-table th {
    font-weight: 600;
    color: var(--text-primary);
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.audit-action {
    display: inline-block;
    padding: 0.25rem 0.5rem;
    border-radius: 4px;
    font-size: 0.75rem;
    font-weight: 500;
}

.audit-action.approved {
    background-color: rgba(16, 185, 129, 0.1);
    color: var(--success-green);
}

.audit-action.declined {
    background-color: rgba(239, 68, 68, 0.1);
    color: var(--danger-red);
}

.audit-action.requested-changes {
    background-color: rgba(245, 158, 11, 0.1);
    color: var(--warning-orange);
}

/* Modal Styles */
.modal-content {
    border-radius: 12px;
    border: none;
    box-shadow: var(--shadow-lg);
}

.modal-header {
    background: linear-gradient(135deg, var(--primary-blue) 0%, var(--secondary-blue) 100%);
    color: white;
    border-radius: 12px 12px 0 0;
    border-bottom: none;
}

.modal-body {
    padding: 2rem;
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 500;
    color: var(--text-primary);
}

.form-textarea {
    width: 100%;
    padding: 0.75rem;
    border: 1px solid var(--border-color);
    border-radius: 8px;
    font-size: 0.875rem;
    min-height: 100px;
    resize: vertical;
}

.form-textarea:focus {
    outline: none;
    border-color: var(--secondary-blue);
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

/* Responsive Design */
@media (max-width: 768px) {
    .dashboard-header {
        padding: 1.5rem;
    }

    .dashboard-stats {
        grid-template-columns: 1fr;
    }

    .filters-grid {
        grid-template-columns: 1fr;
    }

    .approvals-table {
        font-size: 0.875rem;
    }

    .approvals-table th, .approvals-table td {
        padding: 0.75rem 0.5rem;
    }

    .action-buttons {
        flex-direction: column;
        gap: 0.25rem;
    }

    .btn-approve, .btn-decline, .btn-request-changes {
        padding: 0.375rem 0.75rem;
        font-size: 0.75rem;
    }
}

@media (max-width: 480px) {
    .approvals-dashboard {
        padding: 1rem 0;
    }

    .dashboard-header h1 {
        font-size: 1.5rem;
    }

    .stat-number {
        font-size: 2rem;
    }

    .user-info {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
    }

    .attachments {
        flex-direction: column;
        gap: 0.25rem;
    }
}
</style>

<div class="approvals-dashboard">
    <div class="container-fluid">
        <!-- Dashboard Header -->
        <div class="dashboard-header">
            <div class="row">
                <div class="col-lg-8">
                    <h1 class="mb-2">Admin Approvals Dashboard</h1>
                    <p class="mb-0 opacity-90">Manage and review pending approval requests across the system</p>
                </div>
                <div class="col-lg-4 text-lg-end">
                    <div class="d-flex justify-content-lg-end gap-2">
                        <button class="btn btn-light" onclick="exportApprovals()">
                            <i class="fas fa-download me-2"></i>Export
                        </button>
                        <button class="btn btn-light" onclick="refreshApprovals()">
                            <i class="fas fa-sync-alt me-2"></i>Refresh
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="dashboard-stats">
            <div class="stat-card">
                <div class="stat-number" id="pending-count">0</div>
                <div class="stat-label">Pending Approvals</div>
            </div>
            <div class="stat-card">
                <div class="stat-number" id="approved-today">0</div>
                <div class="stat-label">Approved Today</div>
            </div>
            <div class="stat-card">
                <div class="stat-number" id="high-priority">0</div>
                <div class="stat-label">High Priority</div>
            </div>
            <div class="stat-card">
                <div class="stat-number" id="overdue-count">0</div>
                <div class="stat-label">Overdue</div>
            </div>
        </div>

        <!-- Filters Section -->
        <div class="filters-section">
            <h5 class="mb-3">Filter & Search</h5>
            <div class="filters-grid">
                <div class="filter-group">
                    <label class="filter-label">Request Type</label>
                    <select class="filter-select" id="filter-type">
                        <option value="">All Types</option>
                        <option value="client-onboarding">Client Onboarding</option>
                        <option value="case-assignment">Case Assignment</option>
                        <option value="billing">Billing</option>
                        <option value="document-submission">Document Submission</option>
                    </select>
                </div>
                <div class="filter-group">
                    <label class="filter-label">Urgency</label>
                    <select class="filter-select" id="filter-urgency">
                        <option value="">All Priorities</option>
                        <option value="high">High</option>
                        <option value="medium">Medium</option>
                        <option value="low">Low</option>
                    </select>
                </div>
                <div class="filter-group">
                    <label class="filter-label">Date Range</label>
                    <select class="filter-select" id="filter-date">
                        <option value="">All Dates</option>
                        <option value="today">Today</option>
                        <option value="week">This Week</option>
                        <option value="month">This Month</option>
                        <option value="overdue">Overdue</option>
                    </select>
                </div>
                <div class="filter-group">
                    <label class="filter-label">Search</label>
                    <input type="text" class="filter-input" id="filter-search" placeholder="Search by user, case, or client...">
                </div>
            </div>
        </div>

        <!-- Recent Notifications Panel -->
        <div class="notifications-panel">
            <div class="notifications-header">
                <h5 class="mb-0">Recent Activity</h5>
                <button class="btn btn-sm btn-outline-primary" onclick="viewAllNotifications()">
                    View All
                </button>
            </div>
            <div class="notifications-list" id="notifications-list">
                <!-- Notifications will be loaded here -->
            </div>
        </div>

        <!-- Main Approvals Table -->
        <div class="approvals-table-container">
            <div class="table-responsive">
                <table class="approvals-table">
                    <thead>
                        <tr>
                            <th>Request Details</th>
                            <th>Type</th>
                            <th>Priority</th>
                            <th>Submitted</th>
                            <th>Attachments</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="approvals-table-body">
                        <!-- Approval requests will be loaded here -->
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Audit Log Section -->
        <div class="audit-log mt-4">
            <div class="audit-log-header">
                <h5 class="mb-0">Approval Audit Log</h5>
                <button class="btn btn-sm btn-outline-primary" onclick="exportAuditLog()">
                    <i class="fas fa-download me-2"></i>Export Log
                </button>
            </div>
            <div class="table-responsive">
                <table class="audit-table">
                    <thead>
                        <tr>
                            <th>Action</th>
                            <th>Request</th>
                            <th>Approved By</th>
                            <th>Timestamp</th>
                            <th>Comments</th>
                        </tr>
                    </thead>
                    <tbody id="audit-table-body">
                        <!-- Audit log entries will be loaded here -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Action Modal -->
<div class="modal fade" id="actionModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="actionModalTitle">Approval Action</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label class="form-label" for="action-comments">Comments (Optional)</label>
                    <textarea class="form-textarea" id="action-comments" rows="4" placeholder="Add any comments or notes..."></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn" id="confirm-action-btn">Confirm</button>
            </div>
        </div>
    </div>
</div>

<script>
// Mock data for demonstration
const mockApprovals = [
    {
        id: 1,
        user: { name: "John Smith", role: "Associate Lawyer", avatar: "JS" },
        type: "client-onboarding",
        priority: "high",
        submittedDate: "2024-01-15",
        case: "Case #2024-001",
        client: "ABC Corporation",
        attachments: ["contract.pdf", "id_proof.jpg"],
        description: "New client onboarding request for ABC Corporation"
    },
    {
        id: 2,
        user: { name: "Sarah Johnson", role: "Paralegal", avatar: "SJ" },
        type: "case-assignment",
        priority: "medium",
        submittedDate: "2024-01-14",
        case: "Case #2024-002",
        client: "XYZ Industries",
        attachments: ["case_details.pdf"],
        description: "Case assignment request for XYZ Industries litigation"
    },
    {
        id: 3,
        user: { name: "Mike Davis", role: "Billing Clerk", avatar: "MD" },
        type: "billing",
        priority: "low",
        submittedDate: "2024-01-13",
        case: "Case #2024-003",
        client: "Tech Solutions Ltd",
        attachments: ["invoice.pdf", "timesheet.xlsx"],
        description: "Billing approval for completed legal services"
    }
];

const mockNotifications = [
    { type: "success", message: "Client onboarding approved for ABC Corporation", time: "2 hours ago" },
    { type: "warning", message: "Case assignment request pending review", time: "4 hours ago" },
    { type: "success", message: "Billing approval processed for Tech Solutions", time: "1 day ago" }
];

const mockAuditLog = [
    { action: "approved", request: "Client Onboarding - ABC Corp", approvedBy: "Admin User", timestamp: "2024-01-15 14:30", comments: "All documents verified" },
    { action: "declined", request: "Case Assignment - XYZ Industries", approvedBy: "Senior Partner", timestamp: "2024-01-14 11:15", comments: "Missing required documentation" },
    { action: "approved", request: "Billing - Tech Solutions", approvedBy: "Finance Manager", timestamp: "2024-01-13 09:45", comments: "Approved as per standard rates" }
];

document.addEventListener('DOMContentLoaded', function() {
    loadDashboardStats();
    loadApprovals();
    loadNotifications();
    loadAuditLog();
    setupFilters();
});

function loadDashboardStats() {
    // Mock statistics
    document.getElementById('pending-count').textContent = '12';
    document.getElementById('approved-today').textContent = '8';
    document.getElementById('high-priority').textContent = '3';
    document.getElementById('overdue-count').textContent = '2';
}

function loadApprovals() {
    const tbody = document.getElementById('approvals-table-body');
    tbody.innerHTML = '';

    mockApprovals.forEach(approval => {
        const row = createApprovalRow(approval);
        tbody.appendChild(row);
    });
}

function createApprovalRow(approval) {
    const row = document.createElement('tr');
    row.className = `approval-row priority-${approval.priority}`;

    row.innerHTML = `
        <td>
            <div class="user-info">
                <div class="user-avatar">${approval.user.avatar}</div>
                <div class="user-details">
                    <h6>${approval.user.name}</h6>
                    <small>${approval.user.role}</small>
                    <br>
                    <small class="text-muted">${approval.case} • ${approval.client}</small>
                </div>
            </div>
        </td>
        <td>
            <span class="request-type type-${approval.type}">${formatType(approval.type)}</span>
        </td>
        <td>
            <span class="badge bg-${getPriorityColor(approval.priority)}">${approval.priority.toUpperCase()}</span>
        </td>
        <td>${formatDate(approval.submittedDate)}</td>
        <td>
            <div class="attachments">
                ${approval.attachments.map(att => `<span class="attachment"><i class="fas fa-paperclip"></i>${att}</span>`).join('')}
            </div>
        </td>
        <td>
            <div class="action-buttons">
                <button class="btn-approve" onclick="approveRequest(${approval.id})">
                    <i class="fas fa-check"></i> Approve
                </button>
                <button class="btn-decline" onclick="declineRequest(${approval.id})">
                    <i class="fas fa-times"></i> Decline
                </button>
                <button class="btn-request-changes" onclick="requestChanges(${approval.id})">
                    <i class="fas fa-edit"></i> Request Changes
                </button>
            </div>
        </td>
    `;

    return row;
}

function loadNotifications() {
    const container = document.getElementById('notifications-list');
    container.innerHTML = '';

    mockNotifications.forEach(notification => {
        const item = document.createElement('div');
        item.className = 'notification-item';

        item.innerHTML = `
            <div class="notification-icon ${notification.type}">
                <i class="fas fa-${getNotificationIcon(notification.type)}"></i>
            </div>
            <div class="notification-content">
                <h6>${notification.message}</h6>
                <small>${notification.time}</small>
            </div>
        `;

        container.appendChild(item);
    });
}

function loadAuditLog() {
    const tbody = document.getElementById('audit-table-body');
    tbody.innerHTML = '';

    mockAuditLog.forEach(entry => {
        const row = document.createElement('tr');

        row.innerHTML = `
            <td><span class="audit-action ${entry.action}">${formatAction(entry.action)}</span></td>
            <td>${entry.request}</td>
            <td>${entry.approvedBy}</td>
            <td>${entry.timestamp}</td>
            <td>${entry.comments || '-'}</td>
        `;

        tbody.appendChild(row);
    });
}

function setupFilters() {
    const filters = ['filter-type', 'filter-urgency', 'filter-date', 'filter-search'];
    filters.forEach(filterId => {
        document.getElementById(filterId).addEventListener('change', applyFilters);
    });
}

function applyFilters() {
    // Filter logic would be implemented here
    console.log('Filters applied');
}

function approveRequest(id) {
    showActionModal('Approve Request', 'approve', id);
}

function declineRequest(id) {
    showActionModal('Decline Request', 'decline', id);
}

function requestChanges(id) {
    showActionModal('Request Changes', 'request-changes', id);
}

function showActionModal(title, action, id) {
    const modal = new bootstrap.Modal(document.getElementById('actionModal'));
    const modalTitle = document.getElementById('actionModalTitle');
    const confirmBtn = document.getElementById('confirm-action-btn');

    modalTitle.textContent = title;
    confirmBtn.textContent = title.split(' ')[0];
    confirmBtn.className = `btn btn-${getActionColor(action)}`;

    confirmBtn.onclick = () => {
        const comments = document.getElementById('action-comments').value;
        processAction(action, id, comments);
        modal.hide();
    };

    modal.show();
}

function processAction(action, id, comments) {
    // Process the action (would make API call in real implementation)
    console.log(`Processing ${action} for request ${id} with comments: ${comments}`);

    // Show success message
    showToast(`${action.replace('-', ' ')} processed successfully`, 'success');

    // Refresh data
    loadApprovals();
    loadNotifications();
    loadAuditLog();
    loadDashboardStats();
}

function showToast(message, type) {
    // Simple toast implementation
    const toast = document.createElement('div');
    toast.className = `alert alert-${type} position-fixed`;
    toast.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    toast.innerHTML = `
        <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-circle'} me-2"></i>
        ${message}
        <button type="button" class="btn-close" onclick="this.parentElement.remove()"></button>
    `;

    document.body.appendChild(toast);

    setTimeout(() => {
        toast.remove();
    }, 5000);
}

// Utility functions
function formatType(type) {
    return type.split('-').map(word => word.charAt(0).toUpperCase() + word.slice(1)).join(' ');
}

function getPriorityColor(priority) {
    switch (priority) {
        case 'high': return 'danger';
        case 'medium': return 'warning';
        case 'low': return 'success';
        default: return 'secondary';
    }
}

function formatDate(dateString) {
    const date = new Date(dateString);
    return date.toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' });
}

function getNotificationIcon(type) {
    switch (type) {
        case 'success': return 'check-circle';
        case 'warning': return 'exclamation-triangle';
        case 'error': return 'times-circle';
        default: return 'info-circle';
    }
}

function formatAction(action) {
    return action.charAt(0).toUpperCase() + action.slice(1).replace('-', ' ');
}

function getActionColor(action) {
    switch (action) {
        case 'approve': return 'success';
        case 'decline': return 'danger';
        case 'request-changes': return 'warning';
        default: return 'primary';
    }
}

function exportApprovals() {
    console.log('Exporting approvals...');
    showToast('Export feature coming soon', 'info');
}

function refreshApprovals() {
    loadApprovals();
    loadDashboardStats();
    showToast('Data refreshed', 'success');
}

function viewAllNotifications() {
    console.log('Viewing all notifications...');
    showToast('Full notifications view coming soon', 'info');
}

function exportAuditLog() {
    console.log('Exporting audit log...');
    showToast('Export feature coming soon', 'info');
}
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\admin\Desktop\prolex\resources\views/modules/administration/approvals.blade.php ENDPATH**/ ?>