

<?php $__env->startSection('title', 'Court Filings Management - Prolex Law Firm'); ?>

<?php $__env->startSection('content'); ?>
<style>
    .filings-container {
        max-width: 1400px;
        margin: 40px auto;
        background-color: #f8fafc;
        padding: 30px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    }

    h1 {
        text-align: center;
        color: #1e40af;
        margin-bottom: 30px;
        font-size: 2.5rem;
        font-weight: 700;
    }

    .controls-section {
        background: white;
        padding: 25px;
        border-radius: 10px;
        margin-bottom: 25px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        border: 1px solid #e2e8f0;
    }

    .filters-row {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 15px;
        margin-bottom: 20px;
    }

    .search-box {
        grid-column: 1 / -1;
        max-width: 400px;
        margin: 0 auto;
    }

    .search-input {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #d1d5db;
        border-radius: 8px;
        font-size: 1rem;
    }

    .search-input:focus {
        outline: none;
        border-color: #3b82f6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    }

    .filings-table {
        background: white;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        border: 1px solid #e2e8f0;
    }

    .table-header {
        background: linear-gradient(135deg, #1e40af, #3b82f6);
        color: white;
        padding: 20px;
        font-weight: 600;
        font-size: 1.1rem;
    }

    table {
        width: 100%;
        border-collapse: collapse;
    }

    th, td {
        padding: 15px;
        text-align: left;
        border-bottom: 1px solid #e2e8f0;
    }

    th {
        background-color: #f8fafc;
        font-weight: 600;
        color: #374151;
    }

    tr:hover {
        background-color: #f1f5f9;
    }

    .filing-title {
        font-weight: 600;
        color: #1e40af;
        text-decoration: none;
    }

    .filing-title:hover {
        text-decoration: underline;
    }

    .status-badge {
        display: inline-flex;
        align-items: center;
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 0.8rem;
        font-weight: 600;
        text-transform: uppercase;
    }

    .status-draft {
        background-color: #fef3c7;
        color: #92400e;
    }

    .status-ready_for_filing {
        background-color: #dbeafe;
        color: #1e40af;
    }

    .status-filed {
        background-color: #dcfce7;
        color: #166534;
    }

    .status-rejected {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .status-awaiting_response {
        background-color: #fef3c7;
        color: #92400e;
    }

    .filing-type-badge {
        background-color: #e0e7ff;
        color: #3730a3;
        padding: 2px 8px;
        border-radius: 12px;
        font-size: 0.75rem;
        font-weight: 500;
    }

    .lawyer-name {
        font-weight: 500;
        color: #374151;
    }

    .case-info {
        color: #6b7280;
        font-size: 0.9rem;
    }

    .due-date {
        font-weight: 500;
    }

    .overdue {
        color: #dc2626;
        font-weight: 600;
    }

    .actions-cell {
        white-space: nowrap;
    }

    .btn {
        padding: 6px 12px;
        border: none;
        border-radius: 6px;
        font-size: 0.85rem;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.3s ease;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 4px;
        margin-right: 5px;
    }

    .btn-primary {
        background-color: #3b82f6;
        color: white;
    }

    .btn-primary:hover {
        background-color: #2563eb;
    }

    .btn-success {
        background-color: #10b981;
        color: white;
    }

    .btn-success:hover {
        background-color: #059669;
    }

    .btn-warning {
        background-color: #f59e0b;
        color: white;
    }

    .btn-warning:hover {
        background-color: #d97706;
    }

    .btn-danger {
        background-color: #ef4444;
        color: white;
    }

    .btn-danger:hover {
        background-color: #dc2626;
    }

    .btn-info {
        background-color: #06b6d4;
        color: white;
    }

    .btn-info:hover {
        background-color: #0891b2;
    }

    .pagination {
        display: flex;
        justify-content: center;
        align-items: center;
        margin-top: 30px;
        gap: 10px;
    }

    .pagination a, .pagination span {
        padding: 8px 12px;
        border: 1px solid #d1d5db;
        border-radius: 6px;
        text-decoration: none;
        color: #374151;
        transition: all 0.3s ease;
    }

    .pagination a:hover {
        background-color: #3b82f6;
        color: white;
        border-color: #3b82f6;
    }

    .pagination .current {
        background-color: #3b82f6;
        color: white;
        border-color: #3b82f6;
    }

    .stats-section {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 20px;
        margin-bottom: 25px;
    }

    .stat-card {
        background: white;
        padding: 20px;
        border-radius: 10px;
        text-align: center;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        border: 1px solid #e2e8f0;
    }

    .stat-number {
        font-size: 2.5rem;
        font-weight: 700;
        color: #1e40af;
        margin-bottom: 5px;
    }

    .stat-label {
        color: #6b7280;
        font-size: 0.9rem;
        font-weight: 500;
    }

    .no-filings {
        text-align: center;
        padding: 60px 20px;
        color: #6b7280;
    }

    .no-filings i {
        font-size: 4rem;
        color: #d1d5db;
        margin-bottom: 20px;
    }

    .create-button {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        background-color: #10b981;
        color: white;
        padding: 12px 24px;
        border-radius: 8px;
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s ease;
        margin-bottom: 20px;
    }

    .create-button:hover {
        background-color: #059669;
        transform: translateY(-1px);
    }

    @media (max-width: 768px) {
        .filters-row {
            grid-template-columns: 1fr;
        }

        .search-box {
            max-width: 100%;
        }

        table {
            font-size: 0.9rem;
        }

        th, td {
            padding: 10px;
        }

        .filings-container {
            margin: 20px;
            padding: 20px;
        }
    }
</style>

<div class="filings-container">
    <h1><i class="fas fa-file-alt"></i> Court Filings Management</h1>

    <!-- Statistics Cards -->
    <div class="stats-section">
        <div class="stat-card">
            <div class="stat-number"><?php echo e($totalFilings); ?></div>
            <div class="stat-label">Total Filings</div>
        </div>
        <div class="stat-card">
            <div class="stat-number"><?php echo e($draftCount); ?></div>
            <div class="stat-label">Draft</div>
        </div>
        <div class="stat-card">
            <div class="stat-number"><?php echo e($readyForFilingCount); ?></div>
            <div class="stat-label">Ready for Filing</div>
        </div>
        <div class="stat-card">
            <div class="stat-number"><?php echo e($filedCount); ?></div>
            <div class="stat-label">Filed</div>
        </div>
        <div class="stat-card">
            <div class="stat-number"><?php echo e($rejectedCount); ?></div>
            <div class="stat-label">Rejected</div>
        </div>
        <div class="stat-card">
            <div class="stat-number"><?php echo e($awaitingResponseCount); ?></div>
            <div class="stat-label">Awaiting Response</div>
        </div>
    </div>

    <!-- Controls Section -->
    <div class="controls-section">
        <div style="margin-bottom: 20px; display: flex; gap: 15px; flex-wrap: wrap;">
            <a href="<?php echo e(route('court-filings.create')); ?>" class="create-button">
                <i class="fas fa-plus"></i>
                Add New Filing
            </a>
            <a href="<?php echo e(route('modules.processing')); ?>" class="create-button" style="background-color: #8b5cf6;">
                <i class="fas fa-arrow-left"></i>
                Back to Processing
            </a>
        </div>

        <form method="GET" action="<?php echo e(route('court-filings.index')); ?>" id="filterForm">
            <div class="filters-row">
                <div class="search-box">
                    <input type="text" name="search" class="search-input"
                           placeholder="Search filings by title, jurisdiction, lawyer, or case..."
                           value="<?php echo e(request('search')); ?>">
                </div>

                <select name="filing_type" onchange="document.getElementById('filterForm').submit()">
                    <option value="">All Filing Types</option>
                    <option value="Complaint" <?php echo e(request('filing_type') == 'Complaint' ? 'selected' : ''); ?>>Complaint</option>
                    <option value="Motion" <?php echo e(request('filing_type') == 'Motion' ? 'selected' : ''); ?>>Motion</option>
                    <option value="Affidavit" <?php echo e(request('filing_type') == 'Affidavit' ? 'selected' : ''); ?>>Affidavit</option>
                    <option value="Appeal" <?php echo e(request('filing_type') == 'Appeal' ? 'selected' : ''); ?>>Appeal</option>
                    <option value="Brief" <?php echo e(request('filing_type') == 'Brief' ? 'selected' : ''); ?>>Brief</option>
                    <option value="Notice" <?php echo e(request('filing_type') == 'Notice' ? 'selected' : ''); ?>>Notice</option>
                    <option value="Petition" <?php echo e(request('filing_type') == 'Petition' ? 'selected' : ''); ?>>Petition</option>
                    <option value="Response" <?php echo e(request('filing_type') == 'Response' ? 'selected' : ''); ?>>Response</option>
                    <option value="Reply" <?php echo e(request('filing_type') == 'Reply' ? 'selected' : ''); ?>>Reply</option>
                    <option value="Other" <?php echo e(request('filing_type') == 'Other' ? 'selected' : ''); ?>>Other</option>
                </select>

                <select name="filing_status" onchange="document.getElementById('filterForm').submit()">
                    <option value="">All Statuses</option>
                    <option value="draft" <?php echo e(request('filing_status') == 'draft' ? 'selected' : ''); ?>>Draft</option>
                    <option value="ready for filing" <?php echo e(request('filing_status') == 'ready for filing' ? 'selected' : ''); ?>>Ready for Filing</option>
                    <option value="filed" <?php echo e(request('filing_status') == 'filed' ? 'selected' : ''); ?>>Filed</option>
                    <option value="rejected" <?php echo e(request('filing_status') == 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                    <option value="awaiting response" <?php echo e(request('awaiting response') == 'awaiting response' ? 'selected' : ''); ?>>Awaiting Response</option>
                </select>

                <input type="date" name="start_date" value="<?php echo e(request('start_date')); ?>"
                       onchange="document.getElementById('filterForm').submit()" placeholder="Filing Start Date">

                <input type="date" name="end_date" value="<?php echo e(request('end_date')); ?>"
                       onchange="document.getElementById('filterForm').submit()" placeholder="Filing End Date">
            </div>
        </form>
    </div>

    <!-- Filings Table -->
    <div class="filings-table">
        <?php if($courtFilings->count() > 0): ?>
            <div class="table-header">
                <i class="fas fa-list"></i>
                Court Filings List (<?php echo e($courtFilings->total()); ?> total)
            </div>

            <table>
                <thead>
                    <tr>
                        <th>Filing Details</th>
                        <th>Case Information</th>
                        <th>Filing Type</th>
                        <th>Status</th>
                        <th>Filing Date</th>
                        <th>Due Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $courtFilings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $filing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <a href="<?php echo e(route('court-filings.show', $filing->filing_id)); ?>"
                                   class="filing-title">
                                    <?php echo e($filing->filing_title); ?>

                                </a>
                                <div class="case-info">
                                    <?php echo e($filing->court_jurisdiction); ?>

                                </div>
                            </td>
                            <td>
                                <div class="lawyer-name">
                                    <?php if($filing->legalCase): ?>
                                        <?php echo e($filing->legalCase->case_id); ?> - <?php echo e($filing->legalCase->client_name); ?>

                                    <?php else: ?>
                                        <?php echo e($filing->case_reference ?: 'No case linked'); ?>

                                    <?php endif; ?>
                                </div>
                                <div class="case-info">
                                    Filed by: <?php echo e($filing->createdBy ? $filing->createdBy->name : 'Unknown'); ?>

                                </div>
                            </td>
                            <td>
                                <span class="filing-type-badge">
                                    <?php echo e($filing->filingType ? $filing->filingType->filing_type_name : 'N/A'); ?>

                                </span>
                            </td>
                            <td>
                                <span class="status-badge status-<?php echo e(str_replace(' ', '_', strtolower($filing->filingStatus ? $filing->filingStatus->status_code : ''))); ?>">
                                    <?php echo e($filing->filingStatus ? ucfirst(str_replace('_', ' ', $filing->filingStatus->status_name)) : 'Unknown'); ?>

                                </span>
                            </td>
                            <td>
                                <div class="due-date">
                                    <?php echo e($filing->filing_date->format('M d, Y')); ?>

                                </div>
                            </td>
                            <td>
                                <?php if($filing->due_date): ?>
                                    <div class="due-date <?php echo e($filing->due_date < now() && $filing->filing_status !== 'filed' ? 'overdue' : ''); ?>">
                                        <?php echo e($filing->due_date->format('M d, Y')); ?>

                                    </div>
                                <?php else: ?>
                                    <span style="color: #9ca3af;">N/A</span>
                                <?php endif; ?>
                            </td>
                            <td class="actions-cell">
                                <a href="<?php echo e(route('court-filings.show', $filing->filing_id)); ?>"
                                   class="btn btn-info" title="View Details">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('court-filings.edit', $filing->filing_id)); ?>"
                                   class="btn btn-warning" title="Edit Filing">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form method="POST" action="<?php echo e(route('court-filings.destroy', $filing->filing_id)); ?>"
                                      style="display: inline;"
                                      onsubmit="return confirm('Are you sure you want to delete this court filing?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger" title="Delete Filing">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <!-- Pagination -->
            <div class="pagination">
                <?php echo e($courtFilings->appends(request()->query())->links()); ?>

            </div>
        <?php else: ?>
            <div class="no-filings">
                <i class="fas fa-file-alt"></i>
                <h3>No Court Filings Found</h3>
                <p>No filings match your current filters.</p>
                <a href="<?php echo e(route('court-filings.create')); ?>" class="create-button">
                    <i class="fas fa-plus"></i>
                    Create Your First Filing
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    // Auto-submit form when search input changes
    document.querySelector('.search-input').addEventListener('input', function() {
        clearTimeout(this.searchTimeout);
        this.searchTimeout = setTimeout(() => {
            document.getElementById('filterForm').submit();
        }, 500);
    });

    // Add loading state to form submissions
    document.getElementById('filterForm').addEventListener('submit', function() {
        const submitBtns = document.querySelectorAll('button[type="submit"]');
        submitBtns.forEach(btn => {
            btn.disabled = true;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Loading...';
        });
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\admin\Desktop\prolex\resources\views/modules/processing/court-filings-list.blade.php ENDPATH**/ ?>