

<?php $__env->startSection('title', 'Create Court Filing - Prolex Law Firm'); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/court-filings.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="main-container">
    
    <?php if(session('success')): ?>
    <div class="alert alert-success">
        <svg class="alert-icon" fill="currentColor" viewBox="0 0 20 20">
            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
        </svg>
        <div class="alert-content">
            <?php echo e(session('success')); ?>

        </div>
    </div>
    <?php endif; ?>

    
    <?php if($errors->any()): ?>
    <div class="alert alert-error">
        <svg class="alert-icon" fill="currentColor" viewBox="0 0 20 20">
            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
        </svg>
        <div class="alert-content">
            <h3>Please correct the following errors:</h3>
            <ul class="alert-list">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>
    <?php endif; ?>

    
    <div class="page-header">
        <h1 class="page-title">Create Court Filing</h1>
        <p class="page-subtitle">Complete the form below to submit a new court filing to the system</p>
    </div>

    
    <div class="progress-container">
        <div class="progress-header">
            <span class="progress-label">Form Completion</span>
            <span id="progress-percentage" class="progress-percentage">0%</span>
        </div>
        <div class="progress-bar-bg">
            <div id="progress-bar" class="progress-bar-fill" style="width: 0%"></div>
        </div>
    </div>

    
    <form id="filing-form" action="<?php echo e(route('court-filings.store')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        
        <div class="form-card">
            <div class="form-card-header" data-toggle-card>
                <div class="form-card-title">
                    <svg class="form-card-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5a2 2 0 012-2h4a2 2 0 012 2v2H8V5z" />
                    </svg>
                    Case Management Integration
                </div>
                <svg class="collapse-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                </svg>
            </div>
            <div class="form-card-body">
                <div class="form-grid">
                    <div class="form-field">
                        <label for="case_id" class="form-label">Link to Existing Case (Optional)</label>
                        <select name="case_id" id="case_id" class="form-select">
                            <option value="">Select a case</option>
                            <?php $__currentLoopData = $cases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($case->id); ?>" <?php echo e(old('case_id') == $case->id ? 'selected' : ''); ?>>
                                    <?php echo e($case->case_id); ?> - <?php echo e($case->client_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <div class="helper-text">
                            <svg class="helper-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            Link this filing to an existing case for better tracking
                        </div>
                        <?php $__errorArgs = ['case_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-field">
                        <label for="case_reference" class="form-label">Case Reference (Manual)</label>
                        <input type="text" name="case_reference" id="case_reference" value="<?php echo e(old('case_reference')); ?>" placeholder="Enter case reference manually" class="form-input" />
                        <div class="helper-text">
                            <svg class="helper-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            Use this if the case is not yet in the system
                        </div>
                        <?php $__errorArgs = ['case_reference'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="form-card">
            <div class="form-card-header" data-toggle-card>
                <div class="form-card-title">
                    <svg class="form-card-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                    Basic Filing Information
                </div>
                <svg class="collapse-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                </svg>
            </div>
            <div class="form-card-body">
                <div class="form-grid">
                    <div class="form-field">
                        <label for="filing_code" class="form-label">Filing Code <span class="required">*</span></label>
                        <input type="text" name="filing_code" id="filing_code" value="<?php echo e(old('filing_code')); ?>" placeholder="e.g., CF-2024-001" class="form-input" required />
                        <?php $__errorArgs = ['filing_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-field">
                        <label for="filing_title" class="form-label">Filing Title <span class="required">*</span></label>
                        <input type="text" name="filing_title" id="filing_title" value="<?php echo e(old('filing_title')); ?>" placeholder="e.g., Motion for Summary Judgment" maxlength="200" class="form-input" required />
                        <div class="char-counter" data-field="filing_title">0 / 200</div>
                        <?php $__errorArgs = ['filing_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-field">
                        <label for="filing_type_id" class="form-label">Filing Type <span class="required">*</span></label>
                        <select name="filing_type_id" id="filing_type_id" class="form-select" required>
                            <option value="">Select filing type</option>
                            <?php $__currentLoopData = $filingTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($type->filing_type_id); ?>" <?php echo e(old('filing_type_id') == $type->filing_type_id ? 'selected' : ''); ?>>
                                    <?php echo e($type->type_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['filing_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-field">
                        <label for="court_jurisdiction" class="form-label">Court / Jurisdiction <span class="required">*</span></label>
                        <input type="text" name="court_jurisdiction" id="court_jurisdiction" value="<?php echo e(old('court_jurisdiction')); ?>" placeholder="e.g., High Court – Civil Division" class="form-input" required />
                        <?php $__errorArgs = ['court_jurisdiction'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-field">
                        <label for="filing_date" class="form-label">Filing Date <span class="required">*</span></label>
                        <input type="date" name="filing_date" id="filing_date" value="<?php echo e(old('filing_date')); ?>" class="form-input" required />
                        <?php $__errorArgs = ['filing_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-field">
                        <label for="due_date" class="form-label">Due Date / Deadline</label>
                        <input type="date" name="due_date" id="due_date" value="<?php echo e(old('due_date')); ?>" class="form-input" />
                        <div id="deadline-warning" class="hidden"></div>
                        <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-field">
                        <label for="filed_by" class="form-label">Filed By <span class="required">*</span></label>
                        <input type="text" name="filed_by" id="filed_by" value="<?php echo e(old('filed_by')); ?>" placeholder="Secretary, paralegal, or lawyer name" class="form-input" required />
                        <?php $__errorArgs = ['filed_by'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="form-card">
            <div class="form-card-header" data-toggle-card>
                <div class="form-card-title">
                    <svg class="form-card-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                    </svg>
                    Document Management
                </div>
                <svg class="collapse-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                </svg>
            </div>
            <div class="form-card-body">
                <div class="form-grid">
                    <div class="form-field">
                        <label for="document_path" class="form-label">Document Upload</label>
                        <div class="file-upload-area">
                            <input type="file" name="document_path" id="document_path" class="file-upload-input" accept=".pdf,.doc,.docx" data-file-upload />
                            <svg class="file-upload-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12" />
                            </svg>
                            <p class="file-upload-text">Click to upload or drag and drop</p>
                            <p class="file-upload-hint">PDF, DOC, DOCX up to 10MB</p>
                        </div>
                        <div id="file-info" class="hidden"></div>
                        <?php $__errorArgs = ['document_path'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-field">
                        <label for="version" class="form-label">Version / Revision Number</label>
                        <input type="text" name="version" id="version" value="<?php echo e(old('version')); ?>" placeholder="e.g., v1.0, v1.1" class="form-input" />
                        <div class="helper-text">
                            <svg class="helper-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            Track document versions for revision history
                        </div>
                        <?php $__errorArgs = ['version'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-field form-grid-full">
                        <label for="filing_description" class="form-label">Filing Description</label>
                        <textarea name="filing_description" id="filing_description" placeholder="Detailed description of the filing" maxlength="500" class="form-textarea"><?php echo e(old('filing_description')); ?></textarea>
                        <div class="char-counter" data-field="filing_description">0 / 500</div>
                        <?php $__errorArgs = ['filing_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="form-card">
            <div class="form-card-header" data-toggle-card>
                <div class="form-card-title">
                    <svg class="form-card-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                    </svg>
                    Court Details
                </div>
                <svg class="collapse-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                </svg>
            </div>
            <div class="form-card-body">
                <div class="form-grid">
                    <div class="form-field">
                        <label for="court_area_id" class="form-label">Court Area</label>
                        <select name="court_area_id" id="court_area_id" class="form-select">
                            <option value="">Select court area</option>
                            <?php $__currentLoopData = $courtAreas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($area->area_code); ?>" <?php echo e(old('court_area_id') == $area->area_code ? 'selected' : ''); ?>>
                                    <?php echo e($area->area_name); ?> - <?php echo e($area->city); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['court_area_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-field">
                        <label for="judge_id" class="form-label">Assigned Judge</label>
                        <select name="judge_id" id="judge_id" class="form-select">
                            <option value="">Select judge</option>
                            <?php $__currentLoopData = $judges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $judge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($judge->judge_code); ?>" <?php echo e(old('judge_id') == $judge->judge_code ? 'selected' : ''); ?>>
                                    <?php echo e($judge->judge_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['judge_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="form-card">
            <div class="form-card-header" data-toggle-card>
                <div class="form-card-title">
                    <svg class="form-card-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V9a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4" />
                    </svg>
                    Status Tracking
                </div>
                <svg class="collapse-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                </svg>
            </div>
            <div class="form-card-body">
                <div class="form-grid">
                    <div class="form-field">
                        <label for="filing_status_id" class="form-label">Filing Status <span class="required">*</span></label>
                        <select name="filing_status_id" id="filing_status_id" class="form-select" required>
                            <option value="">Select filing status</option>
                            <?php $__currentLoopData = $filingStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($status->id); ?>" <?php echo e(old('filing_status_id') == $status->id ? 'selected' : ''); ?>>
                                    <?php echo e($status->status_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <div id="status-badge"></div>
                        <?php $__errorArgs = ['filing_status_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-field">
                        <label for="court_acknowledgment" class="form-label">Court Acknowledgment</label>
                        <input type="date" name="court_acknowledgment" id="court_acknowledgment" value="<?php echo e(old('court_acknowledgment')); ?>" class="form-input" />
                        <?php $__errorArgs = ['court_acknowledgment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-field form-grid-full">
                        <label for="next_action" class="form-label">Next Action / Follow-Up</label>
                        <input type="text" name="next_action" id="next_action" value="<?php echo e(old('next_action')); ?>" placeholder="e.g., Serve Opposing Party, Prepare Response" class="form-input" />
                        <?php $__errorArgs = ['next_action'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="form-card">
            <div class="form-card-header" data-toggle-card>
                <div class="form-card-title">
                    <svg class="form-card-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                    </svg>
                    Assignment & Notes
                </div>
                <svg class="collapse-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                </svg>
            </div>
            <div class="form-card-body">
                <div class="form-grid">
                    <div class="form-field">
                        <label for="assigned_lawyers" class="form-label">Assigned Lawyer(s)</label>
                        <select name="assigned_lawyers[]" id="assigned_lawyers" multiple class="form-select" style="min-height: 140px; padding: 0.5rem;">
                            <?php $__currentLoopData = $lawyers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lawyer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($lawyer->id); ?>" <?php echo e((collect(old('assigned_lawyers'))->contains($lawyer->id)) ? 'selected' : ''); ?>>
                                    <?php echo e($lawyer->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <div class="helper-text">
                            <svg class="helper-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            Hold Ctrl/Cmd to select multiple lawyers
                        </div>
                        <?php $__errorArgs = ['assigned_lawyers'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-field">
                        <label for="internal_notes" class="form-label">Internal Notes</label>
                        <textarea name="internal_notes" id="internal_notes" placeholder="Special handling notes, reminders, or client instructions" maxlength="1000" class="form-textarea"><?php echo e(old('internal_notes')); ?></textarea>
                        <div class="char-counter" data-field="internal_notes">0 / 1000</div>
                        <?php $__errorArgs = ['internal_notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-field form-grid-full">
                        <label for="external_notes" class="form-label">External Notes</label>
                        <textarea name="external_notes" id="external_notes" placeholder="Notes intended for client or co-counsel communication" maxlength="500" class="form-textarea" style="min-height: 80px;"><?php echo e(old('external_notes')); ?></textarea>
                        <div class="char-counter" data-field="external_notes">0 / 500</div>
                        <?php $__errorArgs = ['external_notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="warning-message error"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="action-bar">
            <div class="action-info">
                <div class="info-item">
                    <svg class="info-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                    Required fields marked with *
                </div>
                <div class="info-item">
                    <svg class="info-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                    </svg>
                    Data will be securely saved
                </div>
            </div>
            <div class="action-buttons">
                <button type="button" data-reset-form class="btn btn-secondary">
                    <svg class="btn-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                    </svg>
                    Reset Form
                </button>
                <a href="<?php echo e(route('court-filings.index')); ?>" class="btn btn-danger">
                    <svg class="btn-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                    Cancel
                </a>
                <button type="submit" class="btn btn-primary">
                    <svg class="btn-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                    </svg>
                    Save Filing
                </button>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('js/court-filings.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\admin\Desktop\prolex\resources\views/modules/processing/court-filings-create.blade.php ENDPATH**/ ?>