

<?php $__env->startSection('title', 'System Settings - Prolex Law Firm'); ?>

<?php $__env->startSection('content'); ?>
<style>
/* Modern CSS Variables */
:root {
    --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    --card-bg: rgba(255, 255, 255, 0.95);
    --card-border: rgba(255, 255, 255, 0.2);
    --card-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
    --section-bg: rgba(255, 255, 255, 0.9);
    --section-border: rgba(255, 255, 255, 0.3);
    --section-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
    --focus-ring: 0 0 0 3px rgba(102, 126, 234, 0.1);
    --transition: all 0.3s ease;
}

/* Modern Reset & Base Styles */
.system-settings-modern {
    background: var(--primary-gradient);
    min-height: 100vh;
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
}

.settings-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 2rem 1rem;
}

.settings-header {
    text-align: center;
    margin-bottom: 3rem;
}

.settings-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: #1a202c;
    margin-bottom: 0.5rem;
    background: linear-gradient(135deg, #1a202c 0%, #2d3748 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.settings-subtitle {
    color: #718096;
    font-size: 1.125rem;
    font-weight: 400;
}

/* Card Design */
.settings-card {
    background: var(--card-bg);
    backdrop-filter: blur(10px);
    border: 1px solid var(--card-border);
    box-shadow: var(--card-shadow);
    border-radius: 16px;
    padding: 2.5rem;
    margin-bottom: 2rem;
    animation: fadeInUp 0.6s ease-out;
}

.section-card {
    background: var(--section-bg);
    backdrop-filter: blur(5px);
    border: 1px solid var(--section-border);
    border-radius: 12px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    transition: var(--transition);
    position: relative;
    overflow: hidden;
}

.section-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 4px;
    height: 100%;
    background: var(--primary-gradient);
    opacity: 0;
    transition: var(--transition);
}

.section-card:hover {
    transform: translateY(-4px);
    box-shadow: var(--section-shadow);
}

.section-card:hover::before {
    opacity: 1;
}

.section-header {
    display: flex;
    align-items: center;
    margin-bottom: 1.5rem;
    padding-bottom: 0.75rem;
    border-bottom: 1px solid #e2e8f0;
}

.section-icon {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border-radius: 10px;
    margin-right: 1rem;
    background: var(--primary-gradient);
    color: white;
    font-size: 1.125rem;
}

.section-title {
    font-size: 1.25rem;
    font-weight: 600;
    color: #2d3748;
    margin: 0;
}

/* Form Elements */
.form-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
    gap: 1.5rem;
}

.form-group {
    display: flex;
    flex-direction: column;
}

.form-label {
    font-size: 0.875rem;
    font-weight: 500;
    color: #4a5568;
    margin-bottom: 0.5rem;
    display: flex;
    align-items: center;
}

.required::after {
    content: '*';
    color: #e53e3e;
    margin-left: 0.25rem;
}

.form-input, .form-select {
    padding: 0.75rem 1rem;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    font-size: 0.875rem;
    transition: var(--transition);
    background: white;
}

.form-input:focus, .form-select:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: var(--focus-ring);
}

.checkbox-group {
    display: flex;
    align-items: center;
    margin-top: 1.75rem;
}

.checkbox {
    width: 18px;
    height: 18px;
    border-radius: 4px;
    border: 1px solid #cbd5e0;
    margin-right: 0.75rem;
    position: relative;
    cursor: pointer;
    transition: var(--transition);
}

.checkbox:checked {
    background: var(--primary-gradient);
    border-color: transparent;
}

.checkbox:checked::after {
    content: '✓';
    position: absolute;
    color: white;
    font-size: 0.75rem;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
}

.checkbox-label {
    font-size: 0.875rem;
    color: #4a5568;
    cursor: pointer;
}

/* Button Styles */
.submit-section {
    display: flex;
    justify-content: flex-end;
    margin-top: 2rem;
}

.submit-btn {
    background: var(--primary-gradient);
    color: white;
    border: none;
    border-radius: 8px;
    padding: 0.875rem 2rem;
    font-weight: 500;
    font-size: 0.875rem;
    cursor: pointer;
    transition: var(--transition);
    display: flex;
    align-items: center;
    box-shadow: 0 4px 6px rgba(102, 126, 234, 0.2);
}

.submit-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(102, 126, 234, 0.3);
}

.submit-btn:active {
    transform: translateY(0);
}

.submit-btn i {
    margin-right: 0.5rem;
}

/* Animations */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Responsive Adjustments */
@media (max-width: 768px) {
    .settings-container {
        padding: 1rem 0.5rem;
    }
    
    .settings-card {
        padding: 1.5rem;
    }
    
    .form-grid {
        grid-template-columns: 1fr;
    }
    
    .section-header {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .section-icon {
        margin-bottom: 0.75rem;
    }
}
</style>

<div class="system-settings-modern">
    <div class="settings-container">
        <div class="settings-card">
            <div class="settings-header">
                <a href="<?php echo e(route('administration.general-settings')); ?>" class="btn btn-secondary mb-3">
                    <i class="fas fa-arrow-left me-2"></i>Back to General Settings
                </a>
                <h1 class="settings-title">System Settings</h1>
                <p class="settings-subtitle">Configure your system preferences and defaults</p>
            </div>

            <form id="system-settings-form">
                <?php echo csrf_field(); ?>

                <!-- General Settings -->
                <div class="section-card">
                    <div class="section-header">
                        <div class="section-icon">
                            <i class="fas fa-cogs"></i>
                        </div>
                        <h2 class="section-title">General Settings</h2>
                    </div>
                    
                    <div class="form-grid">
                        <!-- Default Currency -->
                        <div class="form-group">
                            <label for="default_currency_id" class="form-label">Default Currency</label>
                            <select id="default_currency_id" name="default_currency_id" class="form-select">
                                <option value="">Select Currency</option>
                            </select>
                        </div>

                        <!-- Default Language -->
                        <div class="form-group">
                            <label for="default_language" class="form-label required">Default Language</label>
                            <select id="default_language" name="default_language" class="form-select" required>
                                <option value="en">English</option>
                                <option value="es">Spanish</option>
                                <option value="fr">French</option>
                                <option value="de">German</option>
                            </select>
                        </div>

                        <!-- Timezone -->
                        <div class="form-group">
                            <label for="timezone" class="form-label required">Timezone</label>
                            <select id="timezone" name="timezone" class="form-select" required>
                                <option value="UTC">UTC</option>
                                <option value="America/New_York">Eastern Time</option>
                                <option value="America/Chicago">Central Time</option>
                                <option value="America/Denver">Mountain Time</option>
                                <option value="America/Los_Angeles">Pacific Time</option>
                                <option value="Europe/London">London</option>
                                <option value="Europe/Paris">Paris</option>
                                <option value="Asia/Tokyo">Tokyo</option>
                            </select>
                        </div>

                        <!-- Date Format -->
                        <div class="form-group">
                            <label for="date_format" class="form-label required">Date Format</label>
                            <select id="date_format" name="date_format" class="form-select" required>
                                <option value="Y-m-d">YYYY-MM-DD</option>
                                <option value="d/m/Y">DD/MM/YYYY</option>
                                <option value="m/d/Y">MM/DD/YYYY</option>
                            </select>
                        </div>

                        <!-- Number Format -->
                        <div class="form-group">
                            <label for="number_format" class="form-label required">Number Format</label>
                            <select id="number_format" name="number_format" class="form-select" required>
                                <option value="en">1,234.56</option>
                                <option value="de">1.234,56</option>
                                <option value="fr">1 234,56</option>
                            </select>
                        </div>

                        <!-- Email Notifications -->
                        <div class="checkbox-group">
                            <input type="checkbox" id="email_notifications" name="email_notifications" value="1" class="checkbox">
                            <label for="email_notifications" class="checkbox-label">Enable email notifications</label>
                        </div>
                    </div>
                </div>

                <!-- Document Numbering -->
                <div class="section-card">
                    <div class="section-header">
                        <div class="section-icon">
                            <i class="fas fa-hashtag"></i>
                        </div>
                        <h2 class="section-title">Document Numbering</h2>
                    </div>
                    
                    <div class="form-grid">
                        <!-- Case Number Prefix -->
                        <div class="form-group">
                            <label for="case_number_prefix" class="form-label required">Case Number Prefix</label>
                            <input type="text" id="case_number_prefix" name="case_number_prefix" 
                                   class="form-input" placeholder="CASE" required>
                        </div>

                        <!-- Invoice Number Prefix -->
                        <div class="form-group">
                            <label for="invoice_number_prefix" class="form-label required">Invoice Number Prefix</label>
                            <input type="text" id="invoice_number_prefix" name="invoice_number_prefix" 
                                   class="form-input" placeholder="INV" required>
                        </div>

                        <!-- Quotation Number Prefix -->
                        <div class="form-group">
                            <label for="quotation_number_prefix" class="form-label required">Quotation Number Prefix</label>
                            <input type="text" id="quotation_number_prefix" name="quotation_number_prefix" 
                                   class="form-input" placeholder="QUO" required>
                        </div>

                        <!-- Receipt Number Prefix -->
                        <div class="form-group">
                            <label for="receipt_number_prefix" class="form-label required">Receipt Number Prefix</label>
                            <input type="text" id="receipt_number_prefix" name="receipt_number_prefix" 
                                   class="form-input" placeholder="REC" required>
                        </div>
                    </div>
                </div>

                <!-- Business Rules -->
                <div class="section-card">
                    <div class="section-header">
                        <div class="section-icon">
                            <i class="fas fa-gavel"></i>
                        </div>
                        <h2 class="section-title">Business Rules</h2>
                    </div>
                    
                    <div class="form-grid">
                        <!-- Default Case Status -->
                        <div class="form-group">
                            <label for="default_case_status" class="form-label required">Default Case Status</label>
                            <select id="default_case_status" name="default_case_status" class="form-select" required>
                                <option value="Open">Open</option>
                                <option value="Pending">Pending</option>
                                <option value="Active">Active</option>
                            </select>
                        </div>

                        <!-- Default Payment Terms -->
                        <div class="form-group">
                            <label for="default_payment_terms" class="form-label required">Default Payment Terms (days)</label>
                            <input type="number" id="default_payment_terms" name="default_payment_terms" 
                                   class="form-input" min="1" required>
                        </div>

                        <!-- Tax Calculation Method -->
                        <div class="form-group">
                            <label for="tax_calculation_method" class="form-label required">Tax Calculation Method</label>
                            <select id="tax_calculation_method" name="tax_calculation_method" class="form-select" required>
                                <option value="inclusive">Inclusive</option>
                                <option value="exclusive">Exclusive</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- System Configuration -->
                <div class="section-card">
                    <div class="section-header">
                        <div class="section-icon">
                            <i class="fas fa-server"></i>
                        </div>
                        <h2 class="section-title">System Configuration</h2>
                    </div>
                    
                    <div class="form-grid">
                        <!-- Auto Backup Frequency -->
                        <div class="form-group">
                            <label for="auto_backup_frequency" class="form-label required">Auto Backup Frequency</label>
                            <select id="auto_backup_frequency" name="auto_backup_frequency" class="form-select" required>
                                <option value="daily">Daily</option>
                                <option value="weekly">Weekly</option>
                                <option value="monthly">Monthly</option>
                                <option value="never">Never</option>
                            </select>
                        </div>

                        <!-- File Upload Size Limit -->
                        <div class="form-group">
                            <label for="file_upload_size_limit" class="form-label required">File Upload Size Limit (MB)</label>
                            <input type="number" id="file_upload_size_limit" name="file_upload_size_limit" 
                                   class="form-input" min="1" required>
                        </div>

                        <!-- Session Timeout -->
                        <div class="form-group">
                            <label for="session_timeout" class="form-label required">Session Timeout (minutes)</label>
                            <input type="number" id="session_timeout" name="session_timeout" 
                                   class="form-input" min="1" required>
                        </div>

                        <!-- Maintenance Mode -->
                        <div class="checkbox-group">
                            <input type="checkbox" id="maintenance_mode" name="maintenance_mode" value="1" class="checkbox">
                            <label for="maintenance_mode" class="checkbox-label">Enable maintenance mode</label>
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="submit-section">
                    <button type="submit" class="submit-btn">
                        <i class="fas fa-save"></i> Save System Settings
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    loadSystemSettings();
    loadCurrencies();

    // Form submission
    document.getElementById('system-settings-form').addEventListener('submit', function(e) {
        e.preventDefault();
        saveSystemSettings();
    });
});

function loadSystemSettings() {
    fetch('/administration/api/system-settings')
        .then(response => response.json())
        .then(data => {
            if (data.id) {
                // General Settings
                document.getElementById('default_currency_id').value = data.default_currency_id || '';
                document.getElementById('default_language').value = data.default_language || 'en';
                document.getElementById('timezone').value = data.timezone || 'UTC';
                document.getElementById('date_format').value = data.date_format || 'Y-m-d';
                document.getElementById('number_format').value = data.number_format || 'en';
                document.getElementById('email_notifications').checked = data.email_notifications || false;

                // Document Numbering
                document.getElementById('case_number_prefix').value = data.case_number_prefix || 'CASE';
                document.getElementById('invoice_number_prefix').value = data.invoice_number_prefix || 'INV';
                document.getElementById('quotation_number_prefix').value = data.quotation_number_prefix || 'QUO';
                document.getElementById('receipt_number_prefix').value = data.receipt_number_prefix || 'REC';

                // Business Rules
                document.getElementById('default_case_status').value = data.default_case_status || 'Open';
                document.getElementById('default_payment_terms').value = data.default_payment_terms || 30;
                document.getElementById('tax_calculation_method').value = data.tax_calculation_method || 'exclusive';

                // System Configuration
                document.getElementById('auto_backup_frequency').value = data.auto_backup_frequency || 'weekly';
                document.getElementById('file_upload_size_limit').value = data.file_upload_size_limit || 10;
                document.getElementById('session_timeout').value = data.session_timeout || 60;
                document.getElementById('maintenance_mode').checked = data.maintenance_mode || false;
            }
        })
        .catch(error => {
            console.error('Error loading system settings:', error);
        });
}

function loadCurrencies() {
    // This would typically fetch currencies from an API endpoint
    // For now, we'll add a placeholder option
    const currencySelect = document.getElementById('default_currency_id');
    // You might want to fetch currencies from your backend
    // fetch('/api/currencies')
    //     .then(response => response.json())
    //     .then(data => {
    //         data.forEach(currency => {
    //             const option = document.createElement('option');
    //             option.value = currency.id;
    //             option.textContent = currency.name;
    //             currencySelect.appendChild(option);
    //         });
    //     });
}

function saveSystemSettings() {
    const formData = new FormData(document.getElementById('system-settings-form'));

    const data = {
        default_currency_id: formData.get('default_currency_id') || null,
        default_language: formData.get('default_language'),
        timezone: formData.get('timezone'),
        date_format: formData.get('date_format'),
        number_format: formData.get('number_format'),
        email_notifications: formData.get('email_notifications') ? true : false,
        auto_backup_frequency: formData.get('auto_backup_frequency'),
        case_number_prefix: formData.get('case_number_prefix'),
        invoice_number_prefix: formData.get('invoice_number_prefix'),
        quotation_number_prefix: formData.get('quotation_number_prefix'),
        receipt_number_prefix: formData.get('receipt_number_prefix'),
        default_case_status: formData.get('default_case_status'),
        default_payment_terms: parseInt(formData.get('default_payment_terms')),
        tax_calculation_method: formData.get('tax_calculation_method'),
        file_upload_size_limit: parseInt(formData.get('file_upload_size_limit')),
        session_timeout: parseInt(formData.get('session_timeout')),
        maintenance_mode: formData.get('maintenance_mode') ? true : false,
    };

    fetch('/administration/api/system-settings', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(data => {
        alert('System settings saved successfully!');
        console.log('Success:', data);
    })
    .catch(error => {
        alert('Error saving system settings. Please try again.');
        console.error('Error:', error);
    });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\admin\Desktop\prolex\resources\views/modules/administration/system-settings.blade.php ENDPATH**/ ?>