<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ModuleController;

// Assignment Management Routes
Route::prefix('modules/processing')->name('modules.processing.')->group(function () {
    // Assignment routes
    Route::get('assignment/add', [ModuleController::class, 'createAssignment'])->name('assignment.add');
    Route::post('assignment/store', [ModuleController::class, 'storeAssignment'])->name('assignment.store');
    Route::get('assignment/list', [ModuleController::class, 'listAssignments'])->name('assignment.list');
    Route::get('assignment/{id}', [ModuleController::class, 'showAssignment'])->name('assignment.show');
    Route::get('assignment/{id}/edit', [ModuleController::class, 'editAssignment'])->name('assignment.edit');
    Route::put('assignment/{id}', [ModuleController::class, 'updateAssignment'])->name('assignment.update');
    Route::delete('assignment/{id}', [ModuleController::class, 'deleteAssignment'])->name('assignment.delete');
    Route::get('assignment/reports', [ModuleController::class, 'assignmentReports'])->name('assignment.reports');
});
