<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LedgerController;
use App\Http\Controllers\AccountTypeController;
use App\Http\Controllers\DepartmentController;

use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ModuleController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\DefendantController;
use App\Http\Controllers\AgeingAnalysisController;
use App\Http\Controllers\LawyerController;
use App\Http\Controllers\CaseController;
use App\Http\Controllers\TaxController;
use App\Http\Controllers\CaseTypeController;

// Authentication routes
Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
Route::post('/register', [AuthController::class, 'register']);
Route::get('/logout', [AuthController::class, 'logout'])->name('logout');

// Dashboard
Route::get('/', [AuthController::class, 'showLogin'])->name('home');
Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
Route::get('/chat', [DashboardController::class, 'chat'])->name('chat');
Route::get('/profile', [DashboardController::class, 'profile'])->name('profile');
Route::get('/system-settings', function () {
    return view('system-settings');
})->name('system.settings');
Route::get('/permissions', function () {
    return view('permissions');
})->name('permissions');
Route::get('/company-info', function () {
    return view('company-info');
})->name('company.info');

// Module routes
Route::prefix('modules')->group(function () {
    Route::get('/edit', [ModuleController::class, 'edit'])->name('modules.edit');
    Route::get('/edit/general-ledger', [ModuleController::class, 'chartOfAccounts'])->name('modules.edit.general-ledger');
    Route::get('/edit/chart-of-accounts', [ModuleController::class, 'chartOfAccountsOptions'])->name('modules.edit.chart-of-accounts');
    Route::get('/edit/chart-of-accounts/general-ledger', [ModuleController::class, 'chartOfAccounts'])->name('modules.edit.chart-of-accounts.general-ledger');
    Route::get('/edit/chart-of-accounts/account-types', [ModuleController::class, 'accountTypes'])->name('modules.edit.chart-of-accounts.account-types');
    Route::get('/edit/chart-of-accounts/departments', [DepartmentController::class, 'index'])->name('modules.edit.chart-of-accounts.departments');
    Route::get('/edit/chart-of-accounts/cashbooks', [ModuleController::class, 'cashbooks'])->name('modules.edit.chart-of-accounts.cashbooks');
    Route::get('/edit/account-types', [ModuleController::class, 'accountTypes'])->name('modules.edit.account-types');
    Route::get('/edit/multi-currency', [ModuleController::class, 'multiCurrency'])->name('modules.edit.multi-currency');
    Route::get('/edit/multi-currency/add-currency', [ModuleController::class, 'multiCurrency'])->name('modules.edit.multi-currency.add-currency');
    Route::get('/edit/multi-currency/home-currency', [ModuleController::class, 'multiCurrency'])->name('modules.edit.multi-currency.home-currency');
    Route::get('/edit/multi-currency/daily-rates', [ModuleController::class, 'multiCurrency'])->name('modules.edit.multi-currency.daily-rates');

    Route::post('/currency/store', [ModuleController::class, 'storeCurrency'])->name('currency.store');
    Route::put('/currency/update', [ModuleController::class, 'updateCurrency'])->name('currency.update');
    Route::delete('/currency/delete/{id}', [ModuleController::class, 'deleteCurrency'])->name('currency.delete');
    Route::post('/home-currency/store', [ModuleController::class, 'storeHomeCurrency'])->name('home.currency.store');
    Route::put('/home-currency/update', [ModuleController::class, 'updateHomeCurrency'])->name('home.currency.update');
    Route::delete('/home-currency/delete/{id}', [ModuleController::class, 'deleteHomeCurrency'])->name('home.currency.delete');
    Route::post('/rate/store', [ModuleController::class, 'storeRate'])->name('rate.store');
    Route::post('/rate/update', [ModuleController::class, 'updateRate'])->name('rate.update');
    Route::delete('/rate/delete/{id}', [ModuleController::class, 'deleteRate'])->name('rate.delete');

    Route::get('/edit/tax', [TaxController::class, 'index'])->name('modules.edit.tax');
    Route::get('/edit/suppliers', [ModuleController::class, 'suppliers'])->name('modules.edit.suppliers');
    Route::get('/edit/suppliers/accounts', [ModuleController::class, 'supplierAccounts'])->name('modules.edit.suppliers.accounts');
    Route::get('/edit/suppliers/accounts/create', [ModuleController::class, 'createSupplierAccount'])->name('modules.edit.suppliers.accounts.create');
    Route::post('/edit/suppliers/accounts/store', [ModuleController::class, 'storeSupplierAccount'])->name('modules.edit.suppliers.accounts.store');
    Route::get('/edit/suppliers/accounts/{id}', [ModuleController::class, 'showSupplierAccount'])->name('modules.edit.suppliers.accounts.show');
    Route::get('/edit/suppliers/accounts/{id}/edit', [ModuleController::class, 'editSupplierAccount'])->name('modules.edit.suppliers.accounts.edit');
    Route::put('/edit/suppliers/accounts/{id}', [ModuleController::class, 'updateSupplierAccount'])->name('modules.edit.suppliers.accounts.update');
    Route::delete('/edit/suppliers/accounts/{id}', [ModuleController::class, 'destroySupplierAccount'])->name('modules.edit.suppliers.accounts.destroy');
    Route::get('/edit/suppliers/age-analysis', [ModuleController::class, 'supplierAgeAnalysis'])->name('modules.edit.suppliers.age-analysis');
    Route::get('/edit/suppliers/area', [ModuleController::class, 'supplierArea'])->name('modules.edit.suppliers.area');
    Route::get('/edit/suppliers/area/create', [ModuleController::class, 'createSupplierArea'])->name('modules.edit.suppliers.area.create');
    Route::post('/edit/suppliers/area/store', [ModuleController::class, 'storeSupplierArea'])->name('modules.edit.suppliers.area.store');
    Route::get('/edit/suppliers/area/{id}', [ModuleController::class, 'showSupplierArea'])->name('modules.edit.suppliers.area.show');
    Route::get('/edit/suppliers/area/{id}/edit', [ModuleController::class, 'editSupplierArea'])->name('modules.edit.suppliers.area.edit');
    Route::put('/edit/suppliers/area/{id}', [ModuleController::class, 'updateSupplierArea'])->name('modules.edit.suppliers.area.update');
    Route::delete('/edit/suppliers/area/{id}', [ModuleController::class, 'destroySupplierArea'])->name('modules.edit.suppliers.area.destroy');
    Route::get('/edit/suppliers/categories', [ModuleController::class, 'supplierCategories'])->name('modules.edit.suppliers.categories');
    Route::get('/edit/clients', [ClientController::class, 'index'])->name('modules.edit.clients');
    Route::get('/edit/client', [ClientController::class, 'index'])->name('modules.edit.client');
    Route::get('/edit/add-clients', [ClientController::class, 'create'])->name('modules.edit.add-clients');
    Route::post('/edit/clients', [ClientController::class, 'store'])->name('clients.store');
    Route::get('/edit/clients/{id}', [ClientController::class, 'show'])->name('clients.show');
    Route::get('/edit/clients/{id}/edit', [ClientController::class, 'edit'])->name('clients.edit');
    Route::put('/edit/clients/{id}', [ClientController::class, 'update'])->name('clients.update');
    Route::delete('/edit/clients/{id}', [ClientController::class, 'destroy'])->name('clients.destroy');
    Route::get('/edit/lawyers', [LawyerController::class, 'index'])->name('modules.edit.lawyers');
    Route::get('/edit/lawyer', [LawyerController::class, 'index'])->name('modules.edit.lawyer');
    Route::get('/edit/add-lawyer', [LawyerController::class, 'create'])->name('modules.edit.add-lawyer');
    Route::post('/edit/lawyer', [LawyerController::class, 'store'])->name('modules.edit.lawyer.store');
    Route::get('/edit/lawyer/{id}', [LawyerController::class, 'show'])->name('modules.edit.lawyer.show');
    Route::get('/edit/lawyer/{id}/edit', [LawyerController::class, 'edit'])->name('modules.edit.lawyer.edit');
    Route::put('/edit/lawyer/{id}', [LawyerController::class, 'update'])->name('modules.edit.lawyer.update');
    Route::delete('/edit/lawyer/{id}', [LawyerController::class, 'destroy'])->name('modules.edit.lawyer.destroy');
    Route::get('/edit/client-categories', [\App\Http\Controllers\ClientCategoryController::class, 'index'])->name('modules.edit.client-categories');
    Route::post('/edit/client-categories', [\App\Http\Controllers\ClientCategoryController::class, 'store'])->name('client-categories.store');
    Route::get('/edit/client-categories/{id}/edit', [\App\Http\Controllers\ClientCategoryController::class, 'edit'])->name('client-categories.edit');
    Route::put('/edit/client-categories/{id}', [\App\Http\Controllers\ClientCategoryController::class, 'update'])->name('client-categories.update');
    Route::delete('/edit/client-categories/{id}', [\App\Http\Controllers\ClientCategoryController::class, 'destroy'])->name('client-categories.destroy');
    Route::get('/edit/add-age-analysis', [ClientController::class, 'addAgeAnalysis'])->name('modules.edit.add-age-analysis');
    Route::post('/age-analysis/store', [AgeingAnalysisController::class, 'store'])->name('age-analysis.store');
    Route::get('/age-analysis/edit/{id}', [AgeingAnalysisController::class, 'edit'])->name('ageing.edit');
    Route::put('/age-analysis/update/{id}', [AgeingAnalysisController::class, 'update'])->name('ageing.update');
    Route::delete('/age-analysis/delete/{id}', [AgeingAnalysisController::class, 'destroy'])->name('ageing.delete');
    Route::get('/edit/add-age-analysis-new', [AgeingAnalysisController::class, 'index'])->name('modules.edit.add-age-analysis-new');

    Route::get('/edit/case', [ModuleController::class, 'case'])->name('modules.edit.case');
    Route::get('/edit/cases', [CaseController::class, 'index'])->name('modules.edit.cases');
    Route::get('/edit/add-case', [CaseController::class, 'create'])->name('modules.edit.add-case');
    Route::post('/edit/case', [CaseController::class, 'store'])->name('case.store');
    Route::get('/edit/case/{id}', [CaseController::class, 'show'])->name('case.show');
    Route::get('/edit/case/{id}/edit', [CaseController::class, 'edit'])->name('case.edit');
    Route::put('/edit/case/{id}', [CaseController::class, 'update'])->name('case.update');
    Route::delete('/edit/case/{id}', [CaseController::class, 'destroy'])->name('case.destroy');
    Route::get('/edit/defendants', [DefendantController::class, 'index'])->name('defendants.index');
    Route::get('/edit/defendant', [DefendantController::class, 'create'])->name('defendants.create');
    Route::get('/edit/add-defendant', [DefendantController::class, 'create'])->name('defendants.add');
    Route::post('/edit/defendant', [DefendantController::class, 'store'])->name('defendants.store');
    Route::get('/edit/defendant/{id}', [DefendantController::class, 'show'])->name('defendants.show');
    Route::get('/edit/defendant/{id}/edit', [DefendantController::class, 'edit'])->name('defendants.edit');
    Route::put('/edit/defendant/{id}', [DefendantController::class, 'update'])->name('defendants.update');
    Route::delete('/edit/defendant/{id}', [DefendantController::class, 'destroy'])->name('defendants.destroy');
    Route::get ('/edit/tariff', [ModuleController::class, 'tariff'])->name('modules.edit.tariff');
    Route::resource('tariffs', \App\Http\Controllers\TariffController::class);


    Route::get('/edit/tax/{id}', [TaxController::class, 'show'])->name('taxes.show');
    Route::get('/edit/tax/{id}/edit', [TaxController::class, 'edit'])->name('taxes.edit');
    Route::put('/edit/tax/{id}', [TaxController::class, 'update'])->name('taxes.update');
    Route::delete('/edit/tax/{id}', [TaxController::class, 'destroy'])->name('taxes.destroy');
    Route::get('/processing', [ModuleController::class, 'processing'])->name('modules.processing');
    Route::get('/processing/task-management', [ModuleController::class, 'taskManagement'])->name('modules.processing.task-management');
    Route::get('/processing/diary', [ModuleController::class, 'diary'])->name('modules.processing.diary');
    Route::get('/processing/assignment-collaboration', [ModuleController::class, 'assignmentCollaboration'])->name('modules.processing.assignment-collaboration');
    Route::get('/processing/court-filings', [ModuleController::class, 'courtFilings'])->name('modules.processing.court-filings');
    Route::resource('court-filings', \App\Http\Controllers\CourtFilingController::class);
    Route::get('/processing/client', [ModuleController::class, 'client'])->name('modules.processing.client');
    Route::get('/processing/client-invoice', [ModuleController::class, 'clientInvoice'])->name('modules.processing.client-invoice');
    Route::get('/processing/client-receipt', [ModuleController::class, 'clientReceipt'])->name('modules.processing.client-receipt');
    Route::get('/processing/supplier-invoice', [ModuleController::class, 'supplierInvoice'])->name('modules.processing.supplier-invoice');
    Route::get('/processing/cash-book', [ModuleController::class, 'cashBook'])->name('modules.processing.cash-book');
    Route::post('/processing/cash-book/store', [ModuleController::class, 'storeCashbookEntry'])->name('cashbook.entry.store');
    Route::get('/processing/cash-book/{id}/edit', [ModuleController::class, 'editCashbookEntry'])->name('cashbook.edit');
    Route::put('/processing/cash-book/{id}', [ModuleController::class, 'updateCashbookEntry'])->name('cashbook.update');
    Route::delete('/processing/cash-book/{id}', [ModuleController::class, 'deleteCashbookEntry'])->name('cashbook.delete');
    Route::get('/processing/journal', [ModuleController::class, 'journal'])->name('modules.processing.journal');
    Route::get('/reports', [ModuleController::class, 'reports'])->name('modules.reports');
    Route::get('/reports/general-ledger', [ReportController::class, 'generalLedger'])->name('modules.reports.general-ledger');
    Route::get('/reports/general-ledger/{glcode}', [ReportController::class, 'glAccountDetail'])->name('modules.reports.gl-account-detail');
    Route::get('/reports/client-statement', [ReportController::class, 'clientStatement'])->name('modules.reports.client-statement');
    Route::get('/reports/case-status', [ReportController::class, 'caseStatus'])->name('modules.reports.case-status');
    Route::get('/reports/lawyer-statement', [ReportController::class, 'lawyerStatement'])->name('modules.reports.lawyer-statement');
    Route::get('/reports/supplier-statement', [ReportController::class, 'supplierStatement'])->name('modules.reports.supplier-statement');
    Route::get('/reports/cash-book', [ReportController::class, 'cashBook'])->name('modules.reports.cash-book');
    Route::get('/reports/tax-reports', [ReportController::class, 'taxReports'])->name('modules.reports.tax-reports');
    Route::get('/reports/fee-collection', [ReportController::class, 'feeCollection'])->name('modules.reports.fee-collection');
    Route::get('/reports/outstanding-fees', [ReportController::class, 'outstandingFees'])->name('modules.reports.outstanding-fees');
    Route::get('/reports/total-fees', [ReportController::class, 'totalFees'])->name('modules.reports.total-fees');
    Route::get('/reports/income-statements', [ReportController::class, 'incomeStatements'])->name('modules.reports.income-statements');
    Route::get('/reports/balance-sheet', [ReportController::class, 'balanceSheet'])->name('modules.reports.balance-sheet');
    Route::get('/reports/trial-balance', [ReportController::class, 'trialBalance'])->name('modules.reports.trial-balance');

    Route::get('/ledger/create', [LedgerController::class, 'create'])->name('ledger.create');
    Route::post('/ledger/store', [LedgerController::class, 'store'])->name('ledger.store');
    Route::post('/ledger/edit', [LedgerController::class, 'edit'])->name('editMainAccount');
    Route::delete('/ledger/delete/{id}', [LedgerController::class, 'destroy'])->name('deleteMainAccount');
    Route::get('/ledger/subacc/add/{id}', [LedgerController::class, 'addSubAccount'])->name('subacc.add');
    Route::post('/ledger/subacc/store', [LedgerController::class, 'storeSubAccount'])->name('subacc.store');
    Route::post('/ledger/subacc/edit', [LedgerController::class, 'editSubAccount'])->name('subacc.edit');
    Route::delete('/ledger/subacc/delete/{id}', [LedgerController::class, 'deleteSubAccount'])->name('subacc.delete');

    Route::get('/account-types', [AccountTypeController::class, 'index'])->name('account_types.index');
    Route::post('/account-types/store', [AccountTypeController::class, 'store'])->name('account_types.store');
    Route::post('/account-types/edit', [AccountTypeController::class, 'edit'])->name('account_types.edit');
    Route::get('/account-types/delete/{id}', [AccountTypeController::class, 'destroy'])->name('account_types.delete');

    Route::get('/departments', [DepartmentController::class, 'index'])->name('departments.index');
    Route::post('/departments/store', [DepartmentController::class, 'store'])->name('departments.store');
    Route::post('/departments/edit', [DepartmentController::class, 'edit'])->name('departments.edit');
    Route::get('/departments/delete/{id}', [DepartmentController::class, 'destroy'])->name('departments.delete');

    //case category
    Route::get('/edit/case/case-categories', [CaseCategoryController::class, 'index'])->name('case-categories.index');
    Route::get('/edit/case/case-categories', [CaseCategoryController::class, 'create'])->name('case-categories.create');
    Route::post('/edit/case/case-categories', [CaseCategoryController::class, 'store'])->name('case-categories.store');
    Route::get('/edit/case/case-categories/{id}', [CaseCategoryController::class, 'show'])->name('case-categories.show');
    Route::get('/edit/case/case-categories/{id}/edit', [CaseCategoryController::class, 'edit'])->name('case-categories.edit');
    Route::put('/edit/case/case-categories/{id}', [CaseCategoryController::class, 'update'])->name('case-categories.update');
    Route::delete('/edit/case/case-categories/{id}', [CaseCategoryController::class, 'destroy'])->name('case-categories.destroy');

    //case types
    Route::get('/edit/case/case-type', [CaseTypeController::class, 'index'])->name('case-type.index');
    Route::get('/edit/case/case-type', [CaseTypeController::class, 'create'])->name('case-type.create');
    Route::post('/edit/case/case-type', [CaseTypeController::class, 'store'])->name('case-type.store');
    Route::get('/edit/case/case-type/{id}', [CaseTypeController::class, 'show'])->name('case-type.show');
    Route::get('/edit/case/case-type/{id}/edit', [CaseTypeController::class, 'edit'])->name('case-type.edit');
    Route::put('/edit/case/case-type/{id}', [CaseTypeController::class, 'update'])->name('case-type.update');
    Route::delete('/edit/case/case-type/{id}', [CaseTypeController::class, 'destroy'])->name('case-type.destroy');

    // Tax routes
    Route::resource('taxes', TaxController::class);

    // Supplier routes
    Route::resource('suppliers', \App\Http\Controllers\SupplierController::class);

    // Supplier Categories routes
    Route::get('/edit/suppliers/categories', [ModuleController::class, 'supplierCategories'])->name('modules.edit.suppliers.categories');
    Route::get('/edit/suppliers/categories/create', [ModuleController::class, 'createSupplierCategory'])->name('modules.edit.suppliers.categories.create');
    Route::post('/edit/suppliers/categories', [ModuleController::class, 'storeSupplierCategory'])->name('modules.edit.suppliers.categories.store');
    Route::get('/edit/suppliers/categories/{id}', [ModuleController::class, 'showSupplierCategory'])->name('modules.edit.suppliers.categories.show');
    Route::get('/edit/suppliers/categories/{id}/edit', [ModuleController::class, 'editSupplierCategory'])->name('modules.edit.suppliers.categories.edit');
    Route::put('/edit/suppliers/categories/{id}', [ModuleController::class, 'updateSupplierCategory'])->name('modules.edit.suppliers.categories.update');
    Route::delete('/edit/suppliers/categories/{id}', [ModuleController::class, 'destroySupplierCategory'])->name('modules.edit.suppliers.categories.destroy');

    // Case Type routes
    Route::resource('case-types', CaseTypeController::class);

    // Case Category routes
    Route::resource('case-categories', \App\Http\Controllers\CaseCategoryController::class);
});

// Include Task Management Routes
require __DIR__.'/task-management.php';
    // Case Reasons routes
    Route::get('/edit/case/case-reasons', [ModuleController::class, 'caseReasons'])->name('modules.edit.case-reasons');
    Route::get('/edit/case/case-reasons/list', [ModuleController::class, 'caseReasonsList'])->name('modules.edit.case-reasons.list');
    Route::get('/edit/case/case-reasons/add', [ModuleController::class, 'caseReasonsAdd'])->name('modules.edit.case-reasons.add');
    Route::post('/edit/case/case-reasons', [ModuleController::class, 'caseReasonsStore'])->name('case-reasons.store');
    Route::get('/edit/case/case-reasons/{id}', [ModuleController::class, 'caseReasonsShow'])->name('modules.edit.case-reasons.show');
    Route::get('/edit/case/case-reasons/{id}/edit', [ModuleController::class, 'caseReasonsEdit'])->name('modules.edit.case-reasons.edit');
    Route::put('/edit/case/case-reasons/{id}', [ModuleController::class, 'caseReasonsUpdate'])->name('case-reasons.update');
    Route::delete('/edit/case/case-reasons/{id}', [ModuleController::class, 'caseReasonsDelete'])->name('case-reasons.destroy');

    // Case Status routes
    Route::get('/edit/case/case-status', [ModuleController::class, 'caseStatus'])->name('modules.edit.case-status');
    Route::get('/edit/case/case-status/list', [ModuleController::class, 'caseStatusList'])->name('modules.edit.case-status.list');
    Route::get('/edit/case/case-status/add', [ModuleController::class, 'caseStatusAdd'])->name('modules.edit.case-status.add');
    Route::post('/edit/case/case-status', [ModuleController::class, 'caseStatusStore'])->name('case-status.store');
    Route::get('/edit/case/case-status/{id}', [ModuleController::class, 'caseStatusShow'])->name('modules.edit.case-status.show');
    Route::get('/edit/case/case-status/{id}/edit', [ModuleController::class, 'caseStatusEdit'])->name('modules.edit.case-status.edit');
    Route::put('/edit/case/case-status/{id}', [ModuleController::class, 'caseStatusUpdate'])->name('case-status.update');
    Route::delete('/edit/case/case-status/{id}', [ModuleController::class, 'caseStatusDelete'])->name('case-status.destroy');
