import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import tailwindcss from '@tailwindcss/vite';

export default defineConfig({
    plugins: [
        laravel({
            input: [
                'resources/css/app.css',
                'resources/css/dashboard.css',
                'resources/js/app.js',
                'resources/js/global.js',
                'resources/js/dashboard.js',
                'resources/js/dashboard-charts.js',
                'resources/js/dashboard-app.js'
            ],
            refresh: true,
        }),
        tailwindcss(),
    ],
    server: {
        host: 'localhost',
        port: 8080,
        hmr: {
            host: 'localhost',
        },
    },
});
